/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.unity;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.login.DeviceLoginManager;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.facebook.unity.FB;
import com.facebook.unity.FBUnityLoginActivity;
import com.facebook.unity.UnityMessage;
import com.facebook.unity.UnityParams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class FBLogin {
    public static void loginWithReadPermissions(String params, FBUnityLoginActivity activity) {
        FBLogin.login(params, activity, false, false);
    }

    public static void loginWithPublishPermissions(String params, FBUnityLoginActivity activity) {
        FBLogin.login(params, activity, true, false);
    }

    public static void loginForTVWithReadPermissions(String params, FBUnityLoginActivity activity) {
        FBLogin.login(params, activity, false, true);
    }

    public static void loginForTVWithPublishPermissions(String params, FBUnityLoginActivity activity) {
        FBLogin.login(params, activity, true, true);
    }

    public static void sendLoginSuccessMessage(AccessToken token, String callbackID) {
        UnityMessage unityMessage = new UnityMessage("OnLoginComplete");
        FBLogin.addLoginParametersToMessage(unityMessage, token, callbackID);
        unityMessage.send();
    }

    public static void addLoginParametersToMessage(UnityMessage unityMessage, AccessToken token, String callbackID) {
        unityMessage.put("key_hash", (Serializable)((Object)FB.getKeyHash()));
        unityMessage.put("opened", Boolean.valueOf(true));
        unityMessage.put("access_token", (Serializable)((Object)token.getToken()));
        Long expiration = token.getExpires().getTime() / 1000L;
        unityMessage.put("expiration_timestamp", (Serializable)((Object)expiration.toString()));
        unityMessage.put("user_id", (Serializable)((Object)token.getUserId()));
        unityMessage.put("permissions", (Serializable)((Object)TextUtils.join((CharSequence)",", (Iterable)token.getPermissions())));
        unityMessage.put("declined_permissions", (Serializable)((Object)TextUtils.join((CharSequence)",", (Iterable)token.getDeclinedPermissions())));
        unityMessage.put("graph_domain", (Serializable)((Object)(token.getGraphDomain() != null ? token.getGraphDomain() : "facebook")));
        if (token.getLastRefresh() != null) {
            Long lastRefresh = token.getLastRefresh().getTime() / 1000L;
            unityMessage.put("last_refresh", (Serializable)((Object)lastRefresh.toString()));
        }
        if (callbackID != null && !callbackID.isEmpty()) {
            unityMessage.put("callback_id", (Serializable)((Object)callbackID));
        }
    }

    private static void login(String params, FBUnityLoginActivity activity, boolean isPublishPermLogin, boolean isDeviceAuthLogin) {
        if (!FacebookSdk.isInitialized()) {
            Log.w((String)FB.TAG, (String)"Facebook SDK not initialized. Call init() before calling login()");
            return;
        }
        final UnityMessage unityMessage = new UnityMessage("OnLoginComplete");
        unityMessage.put("key_hash", (Serializable)((Object)FB.getKeyHash()));
        UnityParams unity_params = UnityParams.parse(params, "couldn't parse login params: " + params);
        ArrayList<String> permissions = null;
        if (unity_params.hasString("scope").booleanValue()) {
            permissions = new ArrayList<String>(Arrays.asList(unity_params.getString("scope").split(",")));
        }
        String callbackIDString = null;
        if (unity_params.has("callback_id")) {
            callbackIDString = unity_params.getString("callback_id");
            unityMessage.put("callback_id", (Serializable)((Object)callbackIDString));
        }
        final String callbackID = callbackIDString;
        LoginManager.getInstance().registerCallback(activity.getCallbackManager(), (FacebookCallback)new FacebookCallback<LoginResult>(){

            public void onSuccess(LoginResult loginResult) {
                FBLogin.sendLoginSuccessMessage(loginResult.getAccessToken(), callbackID);
            }

            public void onCancel() {
                unityMessage.putCancelled();
                unityMessage.send();
            }

            public void onError(FacebookException e) {
                unityMessage.sendError(e.getMessage());
            }
        });
        Object loginManager = isDeviceAuthLogin ? DeviceLoginManager.getInstance() : LoginManager.getInstance();
        if (isPublishPermLogin) {
            loginManager.logInWithPublishPermissions((Activity)activity, permissions);
        } else {
            loginManager.logInWithReadPermissions((Activity)activity, permissions);
        }
    }
}

