/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.unity;

import android.app.Activity;
import android.os.Bundle;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.share.model.AppGroupCreationContent;
import com.facebook.share.widget.CreateAppGroupDialog;
import com.facebook.unity.BaseActivity;
import com.facebook.unity.UnityMessage;
import java.io.Serializable;
import java.util.Locale;

public class FBUnityCreateGameGroupActivity
extends BaseActivity {
    public static String CREATE_GAME_GROUP_PARAMS = "create_game_group_params";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        AppGroupCreationContent.Builder contentBuilder = new AppGroupCreationContent.Builder();
        Bundle params = this.getIntent().getBundleExtra(CREATE_GAME_GROUP_PARAMS);
        final UnityMessage response = new UnityMessage("OnGroupCreateComplete");
        if (params.containsKey("callback_id")) {
            response.put("callback_id", (Serializable)((Object)params.getString("callback_id")));
        }
        if (params.containsKey("name")) {
            contentBuilder.setName(params.getString("name"));
        }
        if (params.containsKey("description")) {
            contentBuilder.setDescription(params.getString("name"));
        }
        if (params.containsKey("privacy")) {
            String privacyStr = params.getString("privacy");
            AppGroupCreationContent.AppGroupPrivacy privacy = AppGroupCreationContent.AppGroupPrivacy.Closed;
            if (privacyStr.equalsIgnoreCase("closed")) {
                privacy = AppGroupCreationContent.AppGroupPrivacy.Closed;
            } else if (privacyStr.equalsIgnoreCase("open")) {
                privacy = AppGroupCreationContent.AppGroupPrivacy.Open;
            } else {
                response.sendError(String.format(Locale.ROOT, "Unknown privacy setting for group creation: %s", privacyStr));
                this.finish();
            }
            contentBuilder.setAppGroupPrivacy(privacy);
        }
        CreateAppGroupDialog dialog = new CreateAppGroupDialog((Activity)this);
        dialog.registerCallback(this.mCallbackManager, (FacebookCallback)new FacebookCallback<CreateAppGroupDialog.Result>(){

            public void onSuccess(CreateAppGroupDialog.Result result) {
                response.put("id", (Serializable)((Object)result.getId()));
                response.send();
            }

            public void onCancel() {
                response.putCancelled();
                response.send();
            }

            public void onError(FacebookException e) {
                response.sendError(e.getLocalizedMessage());
            }
        });
        dialog.show((Object)contentBuilder.build());
    }
}

