/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.unity;

import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.share.model.GameRequestContent;
import com.facebook.share.widget.GameRequestDialog;
import com.facebook.unity.BaseActivity;
import com.facebook.unity.UnityMessage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;

public class FBUnityGameRequestActivity
extends BaseActivity {
    public static final String GAME_REQUEST_PARAMS = "game_request_params";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.showDialog();
        }
    }

    private void showDialog() {
        Bundle params = this.getIntent().getBundleExtra(GAME_REQUEST_PARAMS);
        final UnityMessage response = new UnityMessage("OnAppRequestsComplete");
        if (params.containsKey("callback_id")) {
            response.put("callback_id", (Serializable)((Object)params.getString("callback_id")));
        }
        GameRequestContent.Builder contentBuilder = new GameRequestContent.Builder();
        if (params.containsKey("message")) {
            contentBuilder.setMessage(params.getString("message"));
        }
        if (params.containsKey("action_type")) {
            String actionTypeStr = params.getString("action_type");
            try {
                GameRequestContent.ActionType type = GameRequestContent.ActionType.valueOf((String)actionTypeStr);
                contentBuilder.setActionType(type);
            }
            catch (IllegalArgumentException exception) {
                response.sendError("Unknown action type: " + actionTypeStr);
                this.finish();
                return;
            }
        }
        if (params.containsKey("object_id")) {
            contentBuilder.setObjectId(params.getString("object_id"));
        }
        if (params.containsKey("to")) {
            String toStr = params.getString("to");
            contentBuilder.setRecipients(Arrays.asList(toStr.split(",")));
        }
        if (params.containsKey("filters")) {
            String filtersStr = params.getString("filters").toUpperCase(Locale.ROOT);
            try {
                GameRequestContent.Filters filters = GameRequestContent.Filters.valueOf((String)filtersStr);
                contentBuilder.setFilters(filters);
            }
            catch (IllegalArgumentException exception) {
                response.sendError("Unsupported filter type: " + filtersStr);
                this.finish();
                return;
            }
        }
        if (params.containsKey("data")) {
            contentBuilder.setData(params.getString("data"));
        }
        if (params.containsKey("title")) {
            contentBuilder.setTitle(params.getString("title"));
        }
        GameRequestContent content = contentBuilder.build();
        GameRequestDialog requestDialog = new GameRequestDialog((Activity)this);
        requestDialog.registerCallback(this.mCallbackManager, (FacebookCallback)new FacebookCallback<GameRequestDialog.Result>(){

            public void onSuccess(GameRequestDialog.Result result) {
                response.put("request", (Serializable)((Object)result.getRequestId()));
                response.put("to", (Serializable)((Object)TextUtils.join((CharSequence)",", (Iterable)result.getRequestRecipients())));
                response.send();
            }

            public void onCancel() {
                response.putCancelled();
                response.send();
            }

            public void onError(FacebookException e) {
                response.sendError(e.getMessage());
            }
        });
        try {
            requestDialog.show((Object)content);
        }
        catch (IllegalArgumentException exception) {
            response.sendError("Unexpected exception encountered: " + exception.toString());
            this.finish();
        }
    }
}

