/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.unity;

import android.util.Log;
import com.facebook.unity.FB;
import com.facebook.unity.UnityParams;
import com.facebook.unity.UnityReflection;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UnityMessage {
    private String methodName;
    private Map<String, Serializable> params = new HashMap<String, Serializable>();

    public UnityMessage(String methodName) {
        this.methodName = methodName;
    }

    public UnityMessage put(String name, Serializable value) {
        this.params.put(name, value);
        return this;
    }

    public UnityMessage putCancelled() {
        this.put("cancelled", Boolean.valueOf(true));
        return this;
    }

    public UnityMessage putID(String id) {
        this.put("id", (Serializable)((Object)id));
        return this;
    }

    public void sendError(String errorMsg) {
        this.put("error", (Serializable)((Object)errorMsg));
        this.send();
    }

    public void send() {
        assert (this.methodName != null) : "no method specified";
        String message = new UnityParams(this.params).toString();
        Log.v((String)FB.TAG, (String)("sending to Unity " + this.methodName + "(" + message + ")"));
        try {
            UnityReflection.SendMessage("UnityFacebookSDKPlugin", this.methodName, message);
        }
        catch (UnsatisfiedLinkError e) {
            Log.v((String)FB.TAG, (String)"message not send, Unity not initialized");
        }
    }

    public static UnityMessage createWithCallbackFromParams(String methodName, UnityParams params) {
        UnityMessage unityMessage = new UnityMessage(methodName);
        if (params.hasString("callback_id").booleanValue()) {
            unityMessage.put("callback_id", (Serializable)((Object)params.getString("callback_id")));
        }
        return unityMessage;
    }
}

