/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import android.annotation.TargetApi;
import android.app.Application;
import android.os.Build;
import android.os.ConditionVariable;
import com.unity3d.services.core.api.Lifecycle;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.IModuleConfiguration;
import com.unity3d.services.core.connectivity.ConnectivityMonitor;
import com.unity3d.services.core.connectivity.IConnectivityListener;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.WebRequest;
import com.unity3d.services.core.webview.WebViewApp;
import java.io.File;
import java.net.MalformedURLException;

public class InitializeThread
extends Thread {
    private static InitializeThread _thread;
    private InitializeState _state;
    private boolean _stopThread = false;

    private InitializeThread(InitializeState state) {
        this._state = state;
    }

    @Override
    public void run() {
        try {
            while (this._state != null && !(this._state instanceof InitializeStateComplete) && !this._stopThread) {
                try {
                    this._state = this._state.execute();
                }
                catch (Exception e) {
                    DeviceLog.exception("Unity Ads SDK encountered an error during initialization, cancel initialization", e);
                    this._state = new InitializeStateForceReset();
                }
                catch (OutOfMemoryError oom) {
                    DeviceLog.exception("Application doesn't have enough memory to initialize Unity Ads SDK", new Exception(oom));
                    this._state = new InitializeStateForceReset();
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        _thread = null;
    }

    public void quit() {
        this._stopThread = true;
    }

    public static synchronized void initialize(Configuration configuration) {
        if (_thread == null) {
            _thread = new InitializeThread(new InitializeStateReset(configuration));
            _thread.setName("UnityAdsInitializeThread");
            _thread.start();
        }
    }

    public static synchronized void reset() {
        if (_thread == null) {
            _thread = new InitializeThread(new InitializeStateForceReset());
            _thread.setName("UnityAdsResetThread");
            _thread.start();
        }
    }

    public static class InitializeStateRetry
    extends InitializeState {
        InitializeState _state;
        int _delay;

        public InitializeStateRetry(InitializeState state, int delay) {
            this._state = state;
            this._delay = delay;
        }

        @Override
        public InitializeState execute() {
            DeviceLog.debug("Unity Ads init: retrying in " + this._delay + " seconds");
            try {
                Thread.sleep((long)this._delay * 1000L);
            }
            catch (Exception e) {
                DeviceLog.exception("Init retry interrupted", e);
            }
            return this._state;
        }
    }

    public static class InitializeStateNetworkError
    extends InitializeStateError
    implements IConnectivityListener {
        protected static final int CONNECTED_EVENT_THRESHOLD_MS = 10000;
        protected static final int MAX_CONNECTED_EVENTS = 500;
        private static int _receivedConnectedEvents = 0;
        private static long _lastConnectedEventTimeMs = 0L;
        private InitializeState _erroredState;
        private ConditionVariable _conditionVariable;

        public InitializeStateNetworkError(Exception exception, InitializeState erroredState, Configuration configuration) {
            super("network error", exception, configuration);
            this._erroredState = erroredState;
        }

        @Override
        public InitializeState execute() {
            DeviceLog.error("Unity Ads init: network error, waiting for connection events");
            this._conditionVariable = new ConditionVariable();
            ConnectivityMonitor.addListener(this);
            if (this._conditionVariable.block(600000L)) {
                ConnectivityMonitor.removeListener(this);
                return this._erroredState;
            }
            ConnectivityMonitor.removeListener(this);
            return new InitializeStateError("network error", new Exception("No connected events within the timeout!"), this._configuration);
        }

        @Override
        public void onConnected() {
            ++_receivedConnectedEvents;
            DeviceLog.debug("Unity Ads init got connected event");
            if (this.shouldHandleConnectedEvent()) {
                this._conditionVariable.open();
            }
            if (_receivedConnectedEvents > 500) {
                ConnectivityMonitor.removeListener(this);
            }
            _lastConnectedEventTimeMs = System.currentTimeMillis();
        }

        @Override
        public void onDisconnected() {
            DeviceLog.debug("Unity Ads init got disconnected event");
        }

        private boolean shouldHandleConnectedEvent() {
            return System.currentTimeMillis() - _lastConnectedEventTimeMs >= 10000L && _receivedConnectedEvents <= 500;
        }
    }

    public static class InitializeStateError
    extends InitializeState {
        String _state;
        Exception _exception;
        protected Configuration _configuration;

        public InitializeStateError(String state, Exception exception, Configuration configuration) {
            this._state = state;
            this._exception = exception;
            this._configuration = configuration;
        }

        @Override
        public InitializeState execute() {
            DeviceLog.error("Unity Ads init: halting init in " + this._state + ": " + this._exception.getMessage());
            for (String moduleName : this._configuration.getModuleConfigurationList()) {
                IModuleConfiguration moduleConfiguration = this._configuration.getModuleConfiguration(moduleName);
                if (moduleConfiguration == null) continue;
                moduleConfiguration.initErrorState(this._configuration, this._state, this._exception.getMessage());
            }
            return null;
        }
    }

    public static class InitializeStateComplete
    extends InitializeState {
        private Configuration _configuration;

        public InitializeStateComplete(Configuration configuration) {
            this._configuration = configuration;
        }

        @Override
        public InitializeState execute() {
            for (String moduleName : this._configuration.getModuleConfigurationList()) {
                IModuleConfiguration moduleConfiguration = this._configuration.getModuleConfiguration(moduleName);
                if (moduleConfiguration == null) continue;
                moduleConfiguration.initCompleteState(this._configuration);
            }
            return null;
        }
    }

    public static class InitializeStateCreate
    extends InitializeState {
        private Configuration _configuration;
        private String _webViewData;

        public InitializeStateCreate(Configuration configuration, String webViewData) {
            this._configuration = configuration;
            this._webViewData = webViewData;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        public String getWebData() {
            return this._webViewData;
        }

        @Override
        public InitializeState execute() {
            boolean createSuccessFull;
            DeviceLog.debug("Unity Ads init: creating webapp");
            Configuration configuration = this._configuration;
            configuration.setWebViewData(this._webViewData);
            try {
                createSuccessFull = WebViewApp.create(configuration);
            }
            catch (IllegalThreadStateException e) {
                DeviceLog.exception("Illegal Thread", e);
                return new InitializeStateError("create webapp", e, this._configuration);
            }
            if (createSuccessFull) {
                return new InitializeStateComplete(this._configuration);
            }
            DeviceLog.error("Unity Ads WebApp creation failed!");
            return new InitializeStateError("create webapp", new Exception("Creation of WebApp failed!"), this._configuration);
        }
    }

    public static class InitializeStateLoadWeb
    extends InitializeState {
        private Configuration _configuration;
        private int _retries = 0;
        private int _maxRetries = 6;
        private int _retryDelay = 5;

        public InitializeStateLoadWeb(Configuration configuration) {
            this._configuration = configuration;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public InitializeState execute() {
            String webViewData;
            WebRequest request;
            DeviceLog.info("Unity Ads init: loading webapp from " + this._configuration.getWebViewUrl());
            try {
                request = new WebRequest(this._configuration.getWebViewUrl(), "GET", null);
            }
            catch (MalformedURLException e) {
                DeviceLog.exception("Malformed URL", e);
                return new InitializeStateError("make webrequest", e, this._configuration);
            }
            try {
                webViewData = request.makeRequest();
            }
            catch (Exception e) {
                if (this._retries < this._maxRetries) {
                    this._retryDelay *= 2;
                    ++this._retries;
                    return new InitializeStateRetry(this, this._retryDelay);
                }
                return new InitializeStateNetworkError(e, this, this._configuration);
            }
            String webViewHash = this._configuration.getWebViewHash();
            if (webViewHash != null && !Utilities.Sha256(webViewData).equals(webViewHash)) {
                return new InitializeStateError("load web", new Exception("Invalid webViewHash"), this._configuration);
            }
            if (webViewHash != null) {
                Utilities.writeFile(new File(SdkProperties.getLocalWebViewFile()), webViewData);
            }
            return new InitializeStateCreate(this._configuration, webViewData);
        }
    }

    public static class InitializeStateLoadCache
    extends InitializeState {
        private Configuration _configuration;

        public InitializeStateLoadCache(Configuration configuration) {
            this._configuration = configuration;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public InitializeState execute() {
            byte[] localWebViewData;
            DeviceLog.debug("Unity Ads init: check if webapp can be loaded from local cache");
            try {
                localWebViewData = Utilities.readFileBytes(new File(SdkProperties.getLocalWebViewFile()));
            }
            catch (Exception e) {
                DeviceLog.debug("Unity Ads init: webapp not found in local cache: " + e.getMessage());
                return new InitializeStateLoadWeb(this._configuration);
            }
            String localWebViewHash = Utilities.Sha256(localWebViewData);
            if (localWebViewHash != null && localWebViewHash.equals(this._configuration.getWebViewHash())) {
                String webViewDataString;
                try {
                    webViewDataString = new String(localWebViewData, "UTF-8");
                }
                catch (Exception e) {
                    return new InitializeStateError("load cache", e, this._configuration);
                }
                DeviceLog.info("Unity Ads init: webapp loaded from local cache");
                return new InitializeStateCreate(this._configuration, webViewDataString);
            }
            return new InitializeStateLoadWeb(this._configuration);
        }
    }

    public static class InitializeStateConfig
    extends InitializeState {
        private int _retries = 0;
        private int _maxRetries = 6;
        private int _retryDelay = 5;
        private Configuration _configuration;

        public InitializeStateConfig(Configuration configuration) {
            this._configuration = configuration;
        }

        @Override
        public InitializeState execute() {
            DeviceLog.info("Unity Ads init: load configuration from " + SdkProperties.getConfigUrl());
            try {
                this._configuration.makeRequest();
            }
            catch (Exception e) {
                if (this._retries < this._maxRetries) {
                    this._retryDelay *= 2;
                    ++this._retries;
                    return new InitializeStateRetry(this, this._retryDelay);
                }
                return new InitializeStateNetworkError(e, this, this._configuration);
            }
            return new InitializeStateLoadCache(this._configuration);
        }
    }

    public static class InitializeStateInitModules
    extends InitializeState {
        private Configuration _configuration;

        public InitializeStateInitModules(Configuration configuration) {
            this._configuration = configuration;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public InitializeState execute() {
            for (String moduleName : this._configuration.getModuleConfigurationList()) {
                IModuleConfiguration moduleConfiguration = this._configuration.getModuleConfiguration(moduleName);
                if (moduleConfiguration == null || moduleConfiguration.initModuleState(this._configuration)) continue;
                return null;
            }
            return new InitializeStateConfig(this._configuration);
        }
    }

    public static class InitializeStateForceReset
    extends InitializeStateReset {
        public InitializeStateForceReset() {
            super(new Configuration());
        }

        @Override
        public InitializeState execute() {
            super.execute();
            return null;
        }
    }

    public static class InitializeStateReset
    extends InitializeState {
        private Configuration _configuration;

        public InitializeStateReset(Configuration configuration) {
            this._configuration = configuration;
        }

        @Override
        public InitializeState execute() {
            DeviceLog.debug("Unity Ads init: starting init");
            final ConditionVariable cv = new ConditionVariable();
            final WebViewApp currentApp = WebViewApp.getCurrentApp();
            boolean success = true;
            if (currentApp != null) {
                currentApp.setWebAppLoaded(false);
                currentApp.setWebAppInitialized(false);
                if (currentApp.getWebView() != null) {
                    Utilities.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            currentApp.getWebView().destroy();
                            currentApp.setWebView(null);
                            cv.open();
                        }
                    });
                    success = cv.block(10000L);
                }
                if (!success) {
                    return new InitializeStateError("reset webapp", new Exception("Reset failed on opening ConditionVariable"), this._configuration);
                }
            }
            if (Build.VERSION.SDK_INT > 13) {
                this.unregisterLifecycleCallbacks();
            }
            SdkProperties.setCacheDirectory(null);
            File cacheDir = SdkProperties.getCacheDirectory();
            if (cacheDir == null) {
                return new InitializeStateError("reset webapp", new Exception("Cache directory is NULL"), this._configuration);
            }
            SdkProperties.setInitialized(false);
            this._configuration.setConfigUrl(SdkProperties.getConfigUrl());
            for (String moduleName : this._configuration.getModuleConfigurationList()) {
                IModuleConfiguration moduleConfiguration = this._configuration.getModuleConfiguration(moduleName);
                if (moduleConfiguration == null) continue;
                moduleConfiguration.resetState(this._configuration);
            }
            return new InitializeStateInitModules(this._configuration);
        }

        @TargetApi(value=14)
        private void unregisterLifecycleCallbacks() {
            if (Lifecycle.getLifecycleListener() != null) {
                if (ClientProperties.getApplication() != null) {
                    ClientProperties.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)Lifecycle.getLifecycleListener());
                }
                Lifecycle.setLifecycleListener(null);
            }
        }
    }

    private static abstract class InitializeState {
        private InitializeState() {
        }

        public abstract InitializeState execute();
    }
}

