/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.monetization.placementcontent.purchasing;

import com.unity3d.services.monetization.placementcontent.purchasing.Item;
import com.unity3d.services.monetization.placementcontent.purchasing.PromoMetadata;
import com.unity3d.services.purchasing.core.Product;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PromoMetadataUtilities {
    public static PromoMetadata createPromoMetadataFromParamsMap(Map<String, Object> params) {
        PromoMetadata.Builder builder = PromoMetadata.newBuilder();
        if (params.containsKey("impressionDate")) {
            long impression = (Long)params.get("impressionDate");
            builder.withImpressionDate(new Date(impression));
        }
        if (params.containsKey("offerDuration")) {
            builder.withOfferDuration(Long.valueOf(params.get("offerDuration").toString()));
        }
        if (params.containsKey("costs")) {
            List itemsList = (List)params.get("costs");
            List<Item> costs = PromoMetadataUtilities.getItemListFromList(itemsList);
            builder.withCosts(costs);
        }
        if (params.containsKey("payouts")) {
            List itemsList = (List)params.get("payouts");
            List<Item> payouts = PromoMetadataUtilities.getItemListFromList(itemsList);
            builder.withPayouts(payouts);
        }
        if (params.containsKey("product")) {
            Map productParams = (Map)params.get("product");
            builder.withPremiumProduct(PromoMetadataUtilities.createProductFromMap(productParams));
        }
        if (params.containsKey("userInfo")) {
            builder.withCustomInfo((Map)params.get("userInfo"));
        }
        return builder.build();
    }

    private static List<Item> getItemListFromList(List<Map<String, Object>> itemsList) {
        ArrayList<Item> items = new ArrayList<Item>(itemsList.size());
        for (Map<String, Object> itemMap : itemsList) {
            Item item = PromoMetadataUtilities.createItemFromMap(itemMap);
            items.add(item);
        }
        return items;
    }

    private static Item createItemFromMap(Map<String, Object> itemMap) {
        Item.Builder itemBuilder = Item.newBuilder();
        if (itemMap.containsKey("itemId")) {
            itemBuilder.withItemId((String)itemMap.get("itemId"));
        }
        if (itemMap.containsKey("quantity")) {
            itemBuilder.withQuantity(((Number)itemMap.get("quantity")).longValue());
        }
        if (itemMap.containsKey("type")) {
            itemBuilder.withType((String)itemMap.get("type"));
        }
        return itemBuilder.build();
    }

    private static Product createProductFromMap(Map<String, Object> productParams) {
        Product.Builder productBuilder = Product.newBuilder();
        if (productParams.containsKey("productId")) {
            productBuilder.withProductId((String)productParams.get("productId"));
        }
        if (productParams.containsKey("isoCurrencyCode")) {
            productBuilder.withIsoCurrencyCode((String)productParams.get("isoCurrencyCode"));
        }
        if (productParams.containsKey("localizedPriceString")) {
            productBuilder.withLocalizedPriceString((String)productParams.get("localizedPriceString"));
        }
        if (productParams.containsKey("localizedDescription")) {
            productBuilder.withLocalizedDescription((String)productParams.get("localizedDescription"));
        }
        if (productParams.containsKey("localizedTitle")) {
            productBuilder.withLocalizedTitle((String)productParams.get("localizedTitle"));
        }
        if (productParams.containsKey("localizedPrice")) {
            productBuilder.withLocalizedPrice(new Double(productParams.get("localizedPrice").toString()));
        }
        if (productParams.containsKey("productType")) {
            productBuilder.withProductType((String)productParams.get("productType"));
        }
        return productBuilder.build();
    }
}

