/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.browseractions;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.browser.browseractions.BrowserActionItem;
import androidx.browser.browseractions.BrowserActionsFallbackMenuUi;
import androidx.core.content.ContextCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BrowserActionsIntent {
    private static final String TAG = "BrowserActions";
    private static final String TEST_URL = "https://www.example.com";
    public static final String EXTRA_APP_ID = "androidx.browser.browseractions.APP_ID";
    public static final String ACTION_BROWSER_ACTIONS_OPEN = "androidx.browser.browseractions.browser_action_open";
    public static final String KEY_ICON_ID = "androidx.browser.browseractions.ICON_ID";
    public static final String KEY_TITLE = "androidx.browser.browseractions.TITLE";
    public static final String KEY_ACTION = "androidx.browser.browseractions.ACTION";
    public static final String EXTRA_TYPE = "androidx.browser.browseractions.extra.TYPE";
    public static final String EXTRA_MENU_ITEMS = "androidx.browser.browseractions.extra.MENU_ITEMS";
    public static final String EXTRA_SELECTED_ACTION_PENDING_INTENT = "androidx.browser.browseractions.extra.SELECTED_ACTION_PENDING_INTENT";
    public static final int MAX_CUSTOM_ITEMS = 5;
    public static final int URL_TYPE_NONE = 0;
    public static final int URL_TYPE_IMAGE = 1;
    public static final int URL_TYPE_VIDEO = 2;
    public static final int URL_TYPE_AUDIO = 3;
    public static final int URL_TYPE_FILE = 4;
    public static final int URL_TYPE_PLUGIN = 5;
    public static final int ITEM_INVALID_ITEM = -1;
    public static final int ITEM_OPEN_IN_NEW_TAB = 0;
    public static final int ITEM_OPEN_IN_INCOGNITO = 1;
    public static final int ITEM_DOWNLOAD = 2;
    public static final int ITEM_COPY = 3;
    public static final int ITEM_SHARE = 4;
    @NonNull
    private final Intent mIntent;
    private static BrowserActionsFallDialogListener sDialogListenter;

    @NonNull
    public Intent getIntent() {
        return this.mIntent;
    }

    BrowserActionsIntent(@NonNull Intent intent) {
        this.mIntent = intent;
    }

    public static void openBrowserAction(Context context, Uri uri) {
        BrowserActionsIntent intent = new Builder(context, uri).build();
        BrowserActionsIntent.launchIntent(context, intent.getIntent());
    }

    public static void openBrowserAction(Context context, Uri uri, int type, ArrayList<BrowserActionItem> items, PendingIntent pendingIntent) {
        BrowserActionsIntent intent = new Builder(context, uri).setUrlType(type).setCustomItems(items).setOnItemSelectedAction(pendingIntent).build();
        BrowserActionsIntent.launchIntent(context, intent.getIntent());
    }

    public static void launchIntent(Context context, Intent intent) {
        List<ResolveInfo> handlers = BrowserActionsIntent.getBrowserActionsIntentHandlers(context);
        BrowserActionsIntent.launchIntent(context, intent, handlers);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @VisibleForTesting
    static void launchIntent(Context context, Intent intent, List<ResolveInfo> handlers) {
        if (handlers == null || handlers.size() == 0) {
            BrowserActionsIntent.openFallbackBrowserActionsMenu(context, intent);
            return;
        }
        if (handlers.size() == 1) {
            intent.setPackage(handlers.get((int)0).activityInfo.packageName);
        } else {
            Intent viewIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)TEST_URL));
            PackageManager pm = context.getPackageManager();
            ResolveInfo defaultHandler = pm.resolveActivity(viewIntent, 65536);
            if (defaultHandler != null) {
                String defaultPackageName = defaultHandler.activityInfo.packageName;
                for (int i = 0; i < handlers.size(); ++i) {
                    if (!defaultPackageName.equals(handlers.get((int)i).activityInfo.packageName)) continue;
                    intent.setPackage(defaultPackageName);
                    break;
                }
            }
        }
        ContextCompat.startActivity((Context)context, (Intent)intent, null);
    }

    private static List<ResolveInfo> getBrowserActionsIntentHandlers(Context context) {
        Intent intent = new Intent(ACTION_BROWSER_ACTIONS_OPEN, Uri.parse((String)TEST_URL));
        PackageManager pm = context.getPackageManager();
        return pm.queryIntentActivities(intent, 131072);
    }

    private static void openFallbackBrowserActionsMenu(Context context, Intent intent) {
        Uri uri = intent.getData();
        int type = intent.getIntExtra(EXTRA_TYPE, 0);
        ArrayList bundles = intent.getParcelableArrayListExtra(EXTRA_MENU_ITEMS);
        List<BrowserActionItem> items = bundles != null ? BrowserActionsIntent.parseBrowserActionItems(bundles) : null;
        BrowserActionsIntent.openFallbackBrowserActionsMenu(context, uri, type, items);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @VisibleForTesting
    static void setDialogShownListenter(BrowserActionsFallDialogListener dialogListener) {
        sDialogListenter = dialogListener;
    }

    private static void openFallbackBrowserActionsMenu(Context context, Uri uri, int type, List<BrowserActionItem> menuItems) {
        BrowserActionsFallbackMenuUi menuUi = new BrowserActionsFallbackMenuUi(context, uri, menuItems);
        menuUi.displayMenu();
        if (sDialogListenter != null) {
            sDialogListenter.onDialogShown();
        }
    }

    public static List<BrowserActionItem> parseBrowserActionItems(ArrayList<Bundle> bundles) {
        ArrayList<BrowserActionItem> mActions = new ArrayList<BrowserActionItem>();
        for (int i = 0; i < bundles.size(); ++i) {
            Bundle bundle = bundles.get(i);
            String title = bundle.getString(KEY_TITLE);
            PendingIntent action = (PendingIntent)bundle.getParcelable(KEY_ACTION);
            int iconId = bundle.getInt(KEY_ICON_ID);
            if (TextUtils.isEmpty((CharSequence)title) || action == null) {
                throw new IllegalArgumentException("Custom item should contain a non-empty title and non-null intent.");
            }
            BrowserActionItem item = new BrowserActionItem(title, action, iconId);
            mActions.add(item);
        }
        return mActions;
    }

    public static String getCreatorPackageName(Intent intent) {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra(EXTRA_APP_ID);
        if (pendingIntent != null) {
            if (Build.VERSION.SDK_INT >= 17) {
                return pendingIntent.getCreatorPackage();
            }
            return pendingIntent.getTargetPackage();
        }
        return null;
    }

    public static final class Builder {
        private final Intent mIntent = new Intent("androidx.browser.browseractions.browser_action_open");
        private Context mContext;
        private Uri mUri;
        private int mType;
        private ArrayList<Bundle> mMenuItems = null;
        private PendingIntent mOnItemSelectedPendingIntent = null;

        public Builder(Context context, Uri uri) {
            this.mContext = context;
            this.mUri = uri;
            this.mType = 0;
            this.mMenuItems = new ArrayList();
        }

        public Builder setUrlType(int type) {
            this.mType = type;
            return this;
        }

        public Builder setCustomItems(ArrayList<BrowserActionItem> items) {
            if (items.size() > 5) {
                throw new IllegalStateException("Exceeded maximum toolbar item count of 5");
            }
            for (int i = 0; i < items.size(); ++i) {
                if (TextUtils.isEmpty((CharSequence)items.get(i).getTitle()) || items.get(i).getAction() == null) {
                    throw new IllegalArgumentException("Custom item should contain a non-empty title and non-null intent.");
                }
                this.mMenuItems.add(this.getBundleFromItem(items.get(i)));
            }
            return this;
        }

        public Builder setCustomItems(BrowserActionItem ... items) {
            return this.setCustomItems(new ArrayList<BrowserActionItem>(Arrays.asList(items)));
        }

        public Builder setOnItemSelectedAction(PendingIntent onItemSelectedPendingIntent) {
            this.mOnItemSelectedPendingIntent = onItemSelectedPendingIntent;
            return this;
        }

        private Bundle getBundleFromItem(BrowserActionItem item) {
            Bundle bundle = new Bundle();
            bundle.putString(BrowserActionsIntent.KEY_TITLE, item.getTitle());
            bundle.putParcelable(BrowserActionsIntent.KEY_ACTION, (Parcelable)item.getAction());
            if (item.getIconId() != 0) {
                bundle.putInt(BrowserActionsIntent.KEY_ICON_ID, item.getIconId());
            }
            return bundle;
        }

        public BrowserActionsIntent build() {
            this.mIntent.setData(this.mUri);
            this.mIntent.putExtra(BrowserActionsIntent.EXTRA_TYPE, this.mType);
            this.mIntent.putParcelableArrayListExtra(BrowserActionsIntent.EXTRA_MENU_ITEMS, this.mMenuItems);
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)new Intent(), (int)0);
            this.mIntent.putExtra(BrowserActionsIntent.EXTRA_APP_ID, (Parcelable)pendingIntent);
            if (this.mOnItemSelectedPendingIntent != null) {
                this.mIntent.putExtra(BrowserActionsIntent.EXTRA_SELECTED_ACTION_PENDING_INTENT, (Parcelable)this.mOnItemSelectedPendingIntent);
            }
            return new BrowserActionsIntent(this.mIntent);
        }
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static interface BrowserActionsFallDialogListener {
        public void onDialogShown();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface BrowserActionsItemId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface BrowserActionsUrlType {
    }
}

