/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.session;

import android.media.session.MediaSession;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.MediaSessionCompatApi23;
import android.util.Log;
import androidx.annotation.RequiresApi;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RequiresApi(value=24)
class MediaSessionCompatApi24 {
    private static final String TAG = "MediaSessionCompatApi24";

    public static Object createCallback(Callback callback) {
        return new CallbackProxy<Callback>(callback);
    }

    public static String getCallingPackage(Object sessionObj) {
        MediaSession session = (MediaSession)sessionObj;
        try {
            Method getCallingPackageMethod = session.getClass().getMethod("getCallingPackage", new Class[0]);
            return (String)getCallingPackageMethod.invoke((Object)session, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Log.e((String)TAG, (String)"Cannot execute MediaSession.getCallingPackage()", (Throwable)e);
            return null;
        }
    }

    private MediaSessionCompatApi24() {
    }

    static class CallbackProxy<T extends Callback>
    extends MediaSessionCompatApi23.CallbackProxy<T> {
        public CallbackProxy(T callback) {
            super(callback);
        }

        public void onPrepare() {
            ((Callback)this.mCallback).onPrepare();
        }

        public void onPrepareFromMediaId(String mediaId, Bundle extras) {
            MediaSessionCompat.ensureClassLoader(extras);
            ((Callback)this.mCallback).onPrepareFromMediaId(mediaId, extras);
        }

        public void onPrepareFromSearch(String query, Bundle extras) {
            MediaSessionCompat.ensureClassLoader(extras);
            ((Callback)this.mCallback).onPrepareFromSearch(query, extras);
        }

        public void onPrepareFromUri(Uri uri, Bundle extras) {
            MediaSessionCompat.ensureClassLoader(extras);
            ((Callback)this.mCallback).onPrepareFromUri(uri, extras);
        }
    }

    public static interface Callback
    extends MediaSessionCompatApi23.Callback {
        public void onPrepare();

        public void onPrepareFromMediaId(String var1, Bundle var2);

        public void onPrepareFromSearch(String var1, Bundle var2);

        public void onPrepareFromUri(Uri var1, Bundle var2);
    }
}

