/*
 * Decompiled with CFR 0.152.
 */
package com.android.installreferrer.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.android.installreferrer.commons.InstallReferrerCommons;
import com.google.android.finsky.externalreferrer.IGetInstallReferrerService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

class InstallReferrerClientImpl
extends InstallReferrerClient {
    private static final String TAG = "InstallReferrerClient";
    private static final int PLAY_STORE_MIN_APP_VER = 80837300;
    private static final String SERVICE_PACKAGE_NAME = "com.android.vending";
    private static final String SERVICE_NAME = "com.google.android.finsky.externalreferrer.GetInstallReferrerService";
    private static final String SERVICE_ACTION_NAME = "com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE";
    private int mClientState = 0;
    private final Context mApplicationContext;
    private IGetInstallReferrerService mService;
    private ServiceConnection mServiceConnection;

    public InstallReferrerClientImpl(@NonNull Context context) {
        this.mApplicationContext = context.getApplicationContext();
    }

    @Override
    public boolean isReady() {
        return this.mClientState == 2 && this.mService != null && this.mServiceConnection != null;
    }

    @Override
    public void startConnection(@NonNull InstallReferrerStateListener listener) {
        if (this.isReady()) {
            InstallReferrerCommons.logVerbose(TAG, "Service connection is valid. No need to re-initialize.");
            listener.onInstallReferrerSetupFinished(0);
            return;
        }
        if (this.mClientState == 1) {
            InstallReferrerCommons.logWarn(TAG, "Client is already in the process of connecting to the service.");
            listener.onInstallReferrerSetupFinished(3);
            return;
        }
        if (this.mClientState == 3) {
            InstallReferrerCommons.logWarn(TAG, "Client was already closed and can't be reused. Please create another instance.");
            listener.onInstallReferrerSetupFinished(3);
            return;
        }
        InstallReferrerCommons.logVerbose(TAG, "Starting install referrer service setup.");
        this.mServiceConnection = new InstallReferrerServiceConnection(listener);
        Intent serviceIntent = new Intent(SERVICE_ACTION_NAME);
        serviceIntent.setComponent(new ComponentName(SERVICE_PACKAGE_NAME, SERVICE_NAME));
        List intentServices = this.mApplicationContext.getPackageManager().queryIntentServices(serviceIntent, 0);
        if (intentServices != null && !intentServices.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)intentServices.get(0);
            if (resolveInfo.serviceInfo != null) {
                String packageName = resolveInfo.serviceInfo.packageName;
                String className = resolveInfo.serviceInfo.name;
                if (SERVICE_PACKAGE_NAME.equals(packageName) && className != null && this.isPlayStoreCompatible()) {
                    Intent explicitServiceIntent = new Intent(serviceIntent);
                    boolean connectionResult = this.mApplicationContext.bindService(explicitServiceIntent, this.mServiceConnection, 1);
                    if (connectionResult) {
                        InstallReferrerCommons.logVerbose(TAG, "Service was bonded successfully.");
                        return;
                    }
                    InstallReferrerCommons.logWarn(TAG, "Connection to service is blocked.");
                    this.mClientState = 0;
                    listener.onInstallReferrerSetupFinished(1);
                    return;
                }
                InstallReferrerCommons.logWarn(TAG, "Play Store missing or incompatible. Version 8.3.73 or later required.");
                this.mClientState = 0;
                listener.onInstallReferrerSetupFinished(2);
                return;
            }
        }
        this.mClientState = 0;
        InstallReferrerCommons.logVerbose(TAG, "Install Referrer service unavailable on device.");
        listener.onInstallReferrerSetupFinished(2);
    }

    @Override
    public void endConnection() {
        this.mClientState = 3;
        if (this.mServiceConnection != null) {
            InstallReferrerCommons.logVerbose(TAG, "Unbinding from service.");
            this.mApplicationContext.unbindService(this.mServiceConnection);
            this.mServiceConnection = null;
        }
        this.mService = null;
    }

    @Override
    public ReferrerDetails getInstallReferrer() throws RemoteException {
        if (!this.isReady()) {
            throw new IllegalStateException("Service not connected. Please start a connection before using the service.");
        }
        Bundle paramsBundle = new Bundle();
        paramsBundle.putString("package_name", this.mApplicationContext.getPackageName());
        try {
            ReferrerDetails referrerDetails = new ReferrerDetails(this.mService.getInstallReferrer(paramsBundle));
            return referrerDetails;
        }
        catch (RemoteException e) {
            InstallReferrerCommons.logWarn(TAG, "RemoteException getting install referrer information");
            this.mClientState = 0;
            throw e;
        }
    }

    private boolean isPlayStoreCompatible() {
        PackageManager mPm = this.mApplicationContext.getPackageManager();
        try {
            PackageInfo info = mPm.getPackageInfo(SERVICE_PACKAGE_NAME, 128);
            int versionCode = info.versionCode;
            return versionCode >= 80837300;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private final class InstallReferrerServiceConnection
    implements ServiceConnection {
        private final InstallReferrerStateListener mListener;

        private InstallReferrerServiceConnection(InstallReferrerStateListener listener) {
            if (listener == null) {
                throw new RuntimeException("Please specify a listener to know when setup is done.");
            }
            this.mListener = listener;
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InstallReferrerCommons.logVerbose(InstallReferrerClientImpl.TAG, "Install Referrer service connected.");
            InstallReferrerClientImpl.this.mService = IGetInstallReferrerService.Stub.asInterface(iBinder);
            InstallReferrerClientImpl.this.mClientState = 2;
            this.mListener.onInstallReferrerSetupFinished(0);
        }

        public void onServiceDisconnected(ComponentName componentName) {
            InstallReferrerCommons.logWarn(InstallReferrerClientImpl.TAG, "Install Referrer service disconnected.");
            InstallReferrerClientImpl.this.mService = null;
            InstallReferrerClientImpl.this.mClientState = 0;
            this.mListener.onInstallReferrerServiceDisconnected();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ClientState {
        public static final int DISCONNECTED = 0;
        public static final int CONNECTING = 1;
        public static final int CONNECTED = 2;
        public static final int CLOSED = 3;
    }
}

