/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.net.Uri;
import com.facebook.AccessToken;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.internal.FragmentWrapper;
import java.util.List;

public class FriendFinderDialog
extends FacebookDialogBase<Void, Result> {
    private static final int DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.GamingFriendFinder.toRequestCode();

    public FriendFinderDialog(Activity activity) {
        super(activity, DEFAULT_REQUEST_CODE);
    }

    public FriendFinderDialog(Fragment fragment) {
        super(new FragmentWrapper(fragment), DEFAULT_REQUEST_CODE);
    }

    public FriendFinderDialog(androidx.fragment.app.Fragment fragment) {
        super(new FragmentWrapper(fragment), DEFAULT_REQUEST_CODE);
    }

    public void show() {
        this.showImpl();
    }

    public void show(Void content) {
        this.showImpl();
    }

    protected void showImpl() {
        AccessToken currentAccessToken = AccessToken.getCurrentAccessToken();
        if (currentAccessToken == null || currentAccessToken.isExpired()) {
            throw new FacebookException("Attempted to open GamingServices FriendFinder with an invalid access token");
        }
        String app_id = currentAccessToken.getApplicationId();
        String dialog_uri = "https://fb.gg/me/friendfinder/" + app_id;
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)dialog_uri));
        this.startActivityForResult(intent, this.getRequestCode());
    }

    protected void registerCallbackImpl(CallbackManagerImpl callbackManager, final FacebookCallback callback) {
        callbackManager.registerCallback(this.getRequestCode(), new CallbackManagerImpl.Callback(){

            public boolean onActivityResult(int resultCode, Intent data) {
                if (data != null && data.hasExtra("error")) {
                    FacebookRequestError error = (FacebookRequestError)data.getParcelableExtra("error");
                    callback.onError(error.getException());
                    return true;
                }
                callback.onSuccess((Object)new Result());
                return true;
            }
        });
    }

    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        return null;
    }

    protected AppCall createBaseAppCall() {
        return null;
    }

    public static class Result {
    }
}

