/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices.internal;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.GraphRequest;
import com.facebook.HttpMethod;
import com.facebook.internal.Utility;
import java.io.File;
import java.io.FileNotFoundException;

public abstract class GamingMediaUploader {
    private static final String photoUploadEdge = "me/photos";

    public static void uploadToGamingServices(String caption, Bitmap imageBitmap, Bundle params, GraphRequest.Callback callback) {
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        GraphRequest.newUploadPhotoRequest((AccessToken)accessToken, (String)photoUploadEdge, (Bitmap)imageBitmap, (String)caption, (Bundle)params, (GraphRequest.Callback)callback).executeAsync();
    }

    public static void uploadToGamingServices(String caption, File imageFile, Bundle params, GraphRequest.Callback callback) throws FileNotFoundException {
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        GraphRequest.newUploadPhotoRequest((AccessToken)accessToken, (String)photoUploadEdge, (File)imageFile, (String)caption, (Bundle)params, (GraphRequest.Callback)callback).executeAsync();
    }

    public static void uploadToGamingServices(String caption, Uri imageUri, Bundle params, GraphRequest.Callback callback) throws FileNotFoundException {
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        if (Utility.isFileUri((Uri)imageUri) || Utility.isContentUri((Uri)imageUri)) {
            GraphRequest.newUploadPhotoRequest((AccessToken)accessToken, (String)photoUploadEdge, (Uri)imageUri, (String)caption, (Bundle)params, (GraphRequest.Callback)callback).executeAsync();
        } else {
            Bundle parameters = new Bundle();
            if (params != null) {
                parameters.putAll(params);
            }
            parameters.putString("url", imageUri.toString());
            if (caption != null && !caption.isEmpty()) {
                parameters.putString("caption", caption);
            }
            new GraphRequest(accessToken, photoUploadEdge, parameters, HttpMethod.POST, callback).executeAsync();
        }
    }
}

