/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.zaal;
import com.google.android.gms.common.api.internal.zaam;
import com.google.android.gms.common.api.internal.zaan;
import com.google.android.gms.common.api.internal.zaaq;
import com.google.android.gms.common.api.internal.zaat;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabh;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.internal.zaj;
import com.google.android.gms.signin.zad;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zaak
implements zabd {
    private final zabe zafs;
    private final Lock zaen;
    private final Context mContext;
    private final GoogleApiAvailabilityLight zaex;
    private ConnectionResult zafg;
    private int zafv;
    private int zafw = 0;
    private int zafx;
    private final Bundle zafy = new Bundle();
    private final Set<Api.AnyClientKey> zafz = new HashSet<Api.AnyClientKey>();
    private zad zaga;
    private boolean zagb;
    private boolean zagc;
    private boolean zagd;
    private IAccountAccessor zage;
    private boolean zagf;
    private boolean zagg;
    private final ClientSettings zaes;
    private final Map<Api<?>, Boolean> zaev;
    private final Api.AbstractClientBuilder<? extends zad, SignInOptions> zacd;
    private ArrayList<Future<?>> zagh = new ArrayList();

    public zaak(zabe zabe2, ClientSettings clientSettings, Map<Api<?>, Boolean> map, GoogleApiAvailabilityLight googleApiAvailabilityLight, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, Lock lock, Context context) {
        this.zafs = zabe2;
        this.zaes = clientSettings;
        this.zaev = map;
        this.zaex = googleApiAvailabilityLight;
        this.zacd = abstractClientBuilder;
        this.zaen = lock;
        this.mContext = context;
    }

    @Override
    public final void begin() {
        this.zafs.zaho.clear();
        this.zagc = false;
        this.zafg = null;
        this.zafw = 0;
        this.zagb = true;
        this.zagd = false;
        this.zagf = false;
        boolean bl = false;
        HashMap<Api.Client, zaam> hashMap = new HashMap<Api.Client, zaam>();
        for (Api<?> api : this.zaev.keySet()) {
            Api.Client client = this.zafs.zagy.get(api.getClientKey());
            bl |= api.zah().getPriority() == 1;
            boolean bl2 = this.zaev.get(api);
            if (client.requiresSignIn()) {
                this.zagc = true;
                if (bl2) {
                    this.zafz.add(api.getClientKey());
                } else {
                    this.zagb = false;
                }
            }
            hashMap.put(client, new zaam(this, api, bl2));
        }
        if (bl) {
            this.zagc = false;
        }
        if (this.zagc) {
            this.zaes.setClientSessionId(System.identityHashCode(this.zafs.zaed));
            zaat zaat2 = new zaat(this, null);
            this.zaga = this.zacd.buildClient(this.mContext, ((GoogleApiClient)this.zafs.zaed).getLooper(), this.zaes, this.zaes.getSignInOptions(), zaat2, zaat2);
        }
        this.zafx = this.zafs.zagy.size();
        this.zagh.add(zabh.zabb().submit(new zaan(this, hashMap)));
    }

    @GuardedBy(value="mLock")
    private final boolean zaao() {
        --this.zafx;
        if (this.zafx > 0) {
            return false;
        }
        if (this.zafx < 0) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.zafs.zaed.zaay());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zae(new ConnectionResult(8, null));
            return false;
        }
        if (this.zafg != null) {
            this.zafs.zahr = this.zafv;
            this.zae(this.zafg);
            return false;
        }
        return true;
    }

    @GuardedBy(value="mLock")
    private final void zaa(zaj zaj2) {
        if (!this.zac(0)) {
            return;
        }
        ConnectionResult connectionResult = zaj2.getConnectionResult();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = zaj2.zacw();
            ConnectionResult connectionResult2 = resolveAccountResponse.getConnectionResult();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zae(connectionResult2);
                return;
            }
            this.zagd = true;
            this.zage = resolveAccountResponse.getAccountAccessor();
            this.zagf = resolveAccountResponse.getSaveDefaultAccount();
            this.zagg = resolveAccountResponse.isFromCrossClientAuth();
            this.zaap();
            return;
        }
        if (this.zad(connectionResult)) {
            this.zaar();
            this.zaap();
            return;
        }
        this.zae(connectionResult);
    }

    @GuardedBy(value="mLock")
    private final void zaap() {
        if (this.zafx != 0) {
            return;
        }
        if (!this.zagc || this.zagd) {
            zaak zaak2 = this;
            ArrayList<Api.Client> arrayList = new ArrayList<Api.Client>();
            zaak2.zafw = 1;
            zaak2.zafx = zaak2.zafs.zagy.size();
            for (Api.AnyClientKey<?> anyClientKey : zaak2.zafs.zagy.keySet()) {
                if (zaak2.zafs.zaho.containsKey(anyClientKey)) {
                    if (!zaak2.zaao()) continue;
                    zaak2.zaaq();
                    continue;
                }
                arrayList.add(zaak2.zafs.zagy.get(anyClientKey));
            }
            if (!arrayList.isEmpty()) {
                zaak2.zagh.add(zabh.zabb().submit(new zaaq(zaak2, arrayList)));
            }
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void onConnected(Bundle bundle) {
        if (!this.zac(1)) {
            return;
        }
        if (bundle != null) {
            this.zafy.putAll(bundle);
        }
        if (this.zaao()) {
            this.zaaq();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (!this.zac(1)) {
            return;
        }
        this.zab(connectionResult, api, bl);
        if (this.zaao()) {
            this.zaaq();
        }
    }

    @GuardedBy(value="mLock")
    private final void zaaq() {
        this.zafs.zaba();
        zabh.zabb().execute(new zaal(this));
        if (this.zaga != null) {
            if (this.zagf) {
                this.zaga.zaa(this.zage, this.zagg);
            }
            this.zab(false);
        }
        for (Api.AnyClientKey<?> anyClientKey : this.zafs.zaho.keySet()) {
            this.zafs.zagy.get(anyClientKey).disconnect();
        }
        Bundle bundle = this.zafy.isEmpty() ? null : this.zafy;
        this.zafs.zahs.zab(bundle);
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(T t) {
        this.zafs.zaed.zafb.add(t);
        return t;
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public final void connect() {
    }

    @Override
    public final boolean disconnect() {
        this.zaas();
        this.zab(true);
        this.zafs.zaf(null);
        return true;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void onConnectionSuspended(int n) {
        this.zae(new ConnectionResult(8, null));
    }

    /*
     * Unable to fully structure code
     */
    @GuardedBy(value="mLock")
    private final void zab(ConnectionResult var1_1, Api<?> var2_2, boolean var3_3) {
        block3: {
            var4_4 = var2_2.zah().getPriority();
            var7_5 = var1_1;
            var6_6 = var3_3;
            var5_7 = this;
            if (!var6_6) break block3;
            var9_8 = var7_5;
            var8_9 = var5_7;
            if (!(var9_8.hasResolution() != false ? true : var8_9.zaex.getErrorResolutionIntent(var9_8.getErrorCode()) != null)) ** GOTO lbl-1000
        }
        if (var5_7.zafg == null || var4_4 < var5_7.zafv) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            this.zafg = var1_1;
            this.zafv = var4_4;
        }
        this.zafs.zaho.put(var2_2.getClientKey(), var1_1);
    }

    @GuardedBy(value="mLock")
    private final void zaar() {
        this.zagc = false;
        this.zafs.zaed.zagz = Collections.emptySet();
        for (Api.AnyClientKey anyClientKey : this.zafz) {
            if (this.zafs.zaho.containsKey(anyClientKey)) continue;
            this.zafs.zaho.put(anyClientKey, new ConnectionResult(17, null));
        }
    }

    @GuardedBy(value="mLock")
    private final boolean zad(ConnectionResult connectionResult) {
        return this.zagb && !connectionResult.hasResolution();
    }

    @GuardedBy(value="mLock")
    private final void zae(ConnectionResult connectionResult) {
        this.zaas();
        this.zab(!connectionResult.hasResolution());
        this.zafs.zaf(connectionResult);
        this.zafs.zahs.zac(connectionResult);
    }

    private final void zab(boolean bl) {
        if (this.zaga != null) {
            if (this.zaga.isConnected() && bl) {
                this.zaga.zacv();
            }
            this.zaga.disconnect();
            this.zage = null;
        }
    }

    private final void zaas() {
        ArrayList<Future<?>> arrayList = this.zagh;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Future<?> future = arrayList.get(i);
            future.cancel(true);
        }
        this.zagh.clear();
    }

    private final Set<Scope> zaat() {
        if (this.zaes == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zaes.getRequiredScopes());
        Map<Api<?>, ClientSettings.OptionalApiSettings> map = this.zaes.getOptionalApiSettings();
        for (Api<?> api : map.keySet()) {
            if (this.zafs.zaho.containsKey(api.getClientKey())) continue;
            hashSet.addAll(map.get(api).mScopes);
        }
        return hashSet;
    }

    @GuardedBy(value="mLock")
    private final boolean zac(int n) {
        if (this.zafw != n) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.zafs.zaed.zaay());
            String string2 = String.valueOf(this);
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Unexpected callback in ").append(string2).toString());
            int n2 = this.zafx;
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(33).append("mRemainingConnections=").append(n2).toString());
            String string3 = zaak.zad(this.zafw);
            String string4 = zaak.zad(n);
            Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("GoogleApiClient connecting is in step ").append(string3).append(" but received callback for step ").append(string4).toString(), (Throwable)new Exception());
            this.zae(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private static String zad(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ Context zaa(zaak zaak2) {
        return zaak2.mContext;
    }

    static /* synthetic */ GoogleApiAvailabilityLight zab(zaak zaak2) {
        return zaak2.zaex;
    }

    static /* synthetic */ Lock zac(zaak zaak2) {
        return zaak2.zaen;
    }

    static /* synthetic */ zabe zad(zaak zaak2) {
        return zaak2.zafs;
    }

    static /* synthetic */ void zaa(zaak zaak2, ConnectionResult connectionResult) {
        zaak2.zae(connectionResult);
    }

    static /* synthetic */ boolean zae(zaak zaak2) {
        return zaak2.zagc;
    }

    static /* synthetic */ zad zaf(zaak zaak2) {
        return zaak2.zaga;
    }

    static /* synthetic */ Set zag(zaak zaak2) {
        return zaak2.zaat();
    }

    static /* synthetic */ IAccountAccessor zah(zaak zaak2) {
        return zaak2.zage;
    }

    static /* synthetic */ boolean zab(zaak zaak2, ConnectionResult connectionResult) {
        return zaak2.zad(connectionResult);
    }

    static /* synthetic */ void zai(zaak zaak2) {
        zaak2.zaar();
    }

    static /* synthetic */ void zaj(zaak zaak2) {
        zaak2.zaap();
    }

    static /* synthetic */ boolean zaa(zaak zaak2, int n) {
        return zaak2.zac(0);
    }

    static /* synthetic */ void zaa(zaak zaak2, ConnectionResult connectionResult, Api api, boolean bl) {
        zaak2.zab(connectionResult, api, bl);
    }

    static /* synthetic */ boolean zak(zaak zaak2) {
        return zaak2.zaao();
    }

    static /* synthetic */ void zaa(zaak zaak2, zaj zaj2) {
        zaak2.zaa(zaj2);
    }
}

