/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaah;
import com.google.android.gms.common.api.internal.zaak;
import com.google.android.gms.common.api.internal.zaav;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabf;
import com.google.android.gms.common.api.internal.zabg;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zabt;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zar;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zabe
implements zabs,
zar {
    private final Lock zaen;
    private final Condition zahm;
    private final Context mContext;
    private final GoogleApiAvailabilityLight zaex;
    private final zabg zahn;
    final Map<Api.AnyClientKey<?>, Api.Client> zagy;
    final Map<Api.AnyClientKey<?>, ConnectionResult> zaho = new HashMap();
    private final ClientSettings zaes;
    private final Map<Api<?>, Boolean> zaev;
    private final Api.AbstractClientBuilder<? extends zad, SignInOptions> zacd;
    private volatile zabd zahp;
    private ConnectionResult zahq = null;
    int zahr;
    final zaaw zaed;
    final zabt zahs;

    public zabe(Context context, zaaw zaaw2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, ArrayList<zaq> arrayList, zabt zabt2) {
        this.mContext = context;
        this.zaen = lock;
        this.zaex = googleApiAvailabilityLight;
        this.zagy = map;
        this.zaes = clientSettings;
        this.zaev = map2;
        this.zacd = abstractClientBuilder;
        this.zaed = zaaw2;
        this.zahs = zabt2;
        ArrayList<zaq> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zaq zaq2 = arrayList2.get(i);
            zaq2.zaa(this);
        }
        this.zahn = new zabg(this, looper);
        this.zahm = lock.newCondition();
        this.zahp = new zaav(this);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        t.zau();
        return this.zahp.enqueue(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        t.zau();
        return this.zahp.execute(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void connect() {
        this.zahp.connect();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zahm.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zahq != null) {
            return this.zahq;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zahm.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.RESULT_SUCCESS;
        }
        if (this.zahq != null) {
            return this.zahq;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void disconnect() {
        if (this.zahp.disconnect()) {
            this.zaho.clear();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.AnyClientKey<?> anyClientKey = api.getClientKey();
        if (this.zagy.containsKey(anyClientKey)) {
            if (this.zagy.get(anyClientKey).isConnected()) {
                return ConnectionResult.RESULT_SUCCESS;
            }
            if (this.zaho.containsKey(anyClientKey)) {
                return this.zaho.get(anyClientKey);
            }
        }
        return null;
    }

    final void zaaz() {
        this.zaen.lock();
        try {
            this.zahp = new zaak(this, this.zaes, this.zaev, this.zaex, this.zacd, this.zaen, this.mContext);
            this.zahp.begin();
            this.zahm.signalAll();
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    final void zaba() {
        this.zaen.lock();
        try {
            this.zaed.zaaw();
            this.zahp = new zaah(this);
            this.zahp.begin();
            this.zahm.signalAll();
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    final void zaf(ConnectionResult connectionResult) {
        this.zaen.lock();
        try {
            this.zahq = connectionResult;
            this.zahp = new zaav(this);
            this.zahp.begin();
            this.zahm.signalAll();
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zahp instanceof zaah;
    }

    @Override
    public final boolean isConnecting() {
        return this.zahp instanceof zaak;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        return false;
    }

    @Override
    public final void maybeSignOut() {
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaw() {
        if (this.isConnected()) {
            ((zaah)this.zahp).zaam();
        }
    }

    @Override
    public final void zaa(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zaen.lock();
        try {
            this.zahp.zaa(connectionResult, api, bl);
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zaen.lock();
        try {
            this.zahp.onConnected(bundle);
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zaen.lock();
        try {
            this.zahp.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zaen.unlock();
        }
    }

    final void zaa(zabf zabf2) {
        Message message = this.zahn.obtainMessage(1, zabf2);
        this.zahn.sendMessage(message);
    }

    final void zab(RuntimeException runtimeException) {
        Message message = this.zahn.obtainMessage(2, runtimeException);
        this.zahn.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zahp);
        for (Api<?> api : this.zaev.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zagy.get(api.getClientKey()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zaa(zabe zabe2) {
        return zabe2.zaen;
    }

    static /* synthetic */ zabd zab(zabe zabe2) {
        return zabe2.zahp;
    }
}

