/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import androidx.collection.LruCache;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.internal.base.zak;
import com.google.android.gms.internal.base.zal;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object zamg = new Object();
    private static HashSet<Uri> zamh = new HashSet();
    private static ImageManager zami;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService zamj;
    private final zaa zamk;
    private final zak zaml;
    private final Map<com.google.android.gms.common.images.zaa, ImageReceiver> zamm;
    private final Map<Uri, ImageReceiver> zamn;
    private final Map<Uri, Long> zamo;

    public static ImageManager create(Context context) {
        Context context2 = context;
        if (zami == null) {
            zami = new ImageManager(context2, false);
        }
        return zami;
    }

    private ImageManager(Context context, boolean bl) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new zal(Looper.getMainLooper());
        this.zamj = Executors.newFixedThreadPool(4);
        this.zamk = null;
        this.zaml = new zak();
        this.zamm = new HashMap<com.google.android.gms.common.images.zaa, ImageReceiver>();
        this.zamn = new HashMap<Uri, ImageReceiver>();
        this.zamo = new HashMap<Uri, Long>();
    }

    public final void loadImage(ImageView imageView, Uri uri) {
        com.google.android.gms.common.images.zac zac2 = new com.google.android.gms.common.images.zac(imageView, uri);
        this.zaa(zac2);
    }

    public final void loadImage(ImageView imageView, int n) {
        com.google.android.gms.common.images.zac zac2 = new com.google.android.gms.common.images.zac(imageView, n);
        this.zaa(zac2);
    }

    public final void loadImage(ImageView imageView, Uri uri, int n) {
        com.google.android.gms.common.images.zac zac2 = new com.google.android.gms.common.images.zac(imageView, uri);
        new com.google.android.gms.common.images.zac(imageView, uri).zamw = n;
        this.zaa(zac2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri) {
        com.google.android.gms.common.images.zad zad2 = new com.google.android.gms.common.images.zad(onImageLoadedListener, uri);
        this.zaa(zad2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri, int n) {
        com.google.android.gms.common.images.zad zad2 = new com.google.android.gms.common.images.zad(onImageLoadedListener, uri);
        new com.google.android.gms.common.images.zad(onImageLoadedListener, uri).zamw = n;
        this.zaa(zad2);
    }

    private final void zaa(com.google.android.gms.common.images.zaa zaa2) {
        Asserts.checkMainThread((String)"ImageManager.loadImage() must be called in the main thread");
        new zac(zaa2).run();
    }

    private final Bitmap zaa(com.google.android.gms.common.images.zab zab2) {
        if (this.zamk == null) {
            return null;
        }
        return (Bitmap)this.zamk.get(zab2);
    }

    private static final class zaa
    extends LruCache<com.google.android.gms.common.images.zab, Bitmap> {
        protected final /* synthetic */ int sizeOf(Object object, Object object2) {
            Bitmap bitmap = (Bitmap)object2;
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected final /* synthetic */ void entryRemoved(boolean bl, Object object, Object object2, Object object3) {
            Bitmap bitmap = (Bitmap)object3;
            Bitmap bitmap2 = (Bitmap)object2;
            com.google.android.gms.common.images.zab zab2 = (com.google.android.gms.common.images.zab)object;
            super.entryRemoved(bl, (Object)zab2, (Object)bitmap2, (Object)bitmap);
        }
    }

    private final class zad
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch zadq;
        private boolean zamt;

        public zad(Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.zamt = bl;
            this.zadq = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            Asserts.checkMainThread((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (ImageManager.this.zamk != null) {
                if (this.zamt) {
                    ImageManager.this.zamk.evictAll();
                    System.gc();
                    this.zamt = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    ImageManager.this.zamk.put(new com.google.android.gms.common.images.zab(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.zamn.remove(this.mUri))) != null) {
                boolean bl3 = bl;
                ImageReceiver imageReceiver2 = imageReceiver;
                zad zad2 = this;
                ArrayList arrayList = imageReceiver2.zamp;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.images.zaa zaa2 = (com.google.android.gms.common.images.zaa)arrayList.get(i);
                    if (bl3) {
                        zaa2.zaa(zad2.ImageManager.this.mContext, zad2.mBitmap, false);
                    } else {
                        zad2.ImageManager.this.zamo.put(zad2.mUri, SystemClock.elapsedRealtime());
                        zaa2.zaa(zad2.ImageManager.this.mContext, zad2.ImageManager.this.zaml, false);
                    }
                    if (zaa2 instanceof com.google.android.gms.common.images.zad) continue;
                    zad2.ImageManager.this.zamm.remove(zaa2);
                }
            }
            this.zadq.countDown();
            Object object = zamg;
            synchronized (object) {
                zamh.remove(this.mUri);
                return;
            }
        }
    }

    private final class zab
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor zamr;

        public zab(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.zamr = parcelFileDescriptor;
        }

        @Override
        public final void run() {
            Asserts.checkNotMainThread((String)"LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zamr != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zamr.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string2 = String.valueOf(this.mUri);
                    Log.e((String)"ImageManager", (String)new StringBuilder(34 + String.valueOf(string2).length()).append("OOM while loading bitmap for uri: ").append(string2).toString(), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zamr.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new zad(this.mUri, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                String string3 = String.valueOf(this.mUri);
                Log.w((String)"ImageManager", (String)new StringBuilder(32 + String.valueOf(string3).length()).append("Latch interrupted while posting ").append(string3).toString());
                return;
            }
        }
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.zaa> zamp;

        ImageReceiver(Uri uri) {
            super((Handler)new zal(Looper.getMainLooper()));
            this.mUri = uri;
            this.zamp = new ArrayList();
        }

        public final void zab(com.google.android.gms.common.images.zaa zaa2) {
            Asserts.checkMainThread((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zamp.add(zaa2);
        }

        public final void zac(com.google.android.gms.common.images.zaa zaa2) {
            Asserts.checkMainThread((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zamp.remove(zaa2);
        }

        public final void zace() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public final void onReceiveResult(int n, Bundle bundle) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)bundle.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.zamj.execute(new zab(this.mUri, parcelFileDescriptor));
        }
    }

    private final class zac
    implements Runnable {
        private final com.google.android.gms.common.images.zaa zams;

        public zac(com.google.android.gms.common.images.zaa zaa2) {
            this.zams = zaa2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Asserts.checkMainThread((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.zamm.get(this.zams));
            if (imageReceiver != null) {
                ImageManager.this.zamm.remove(this.zams);
                imageReceiver.zac(this.zams);
            }
            com.google.android.gms.common.images.zab zab2 = this.zams.zamu;
            if (zab2.uri == null) {
                this.zams.zaa(ImageManager.this.mContext, ImageManager.this.zaml, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zaa(zab2);
            if (bitmap != null) {
                this.zams.zaa(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.zamo.get(zab2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zams.zaa(ImageManager.this.mContext, ImageManager.this.zaml, true);
                    return;
                }
                ImageManager.this.zamo.remove(zab2.uri);
            }
            this.zams.zaa(ImageManager.this.mContext, ImageManager.this.zaml);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.zamn.get(zab2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zab2.uri);
                ImageManager.this.zamn.put(zab2.uri, imageReceiver);
            }
            imageReceiver.zab(this.zams);
            if (!(this.zams instanceof com.google.android.gms.common.images.zad)) {
                ImageManager.this.zamm.put(this.zams, imageReceiver);
            }
            Object object = zamg;
            synchronized (object) {
                if (!zamh.contains(zab2.uri)) {
                    zamh.add(zab2.uri);
                    imageReceiver.zace();
                }
                return;
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

