/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

@KeepForSdk
public class LibraryVersion {
    private static final GmsLogger zzel = new GmsLogger("LibraryVersion", "");
    private static LibraryVersion zzem = new LibraryVersion();
    private ConcurrentHashMap<String, String> zzen = new ConcurrentHashMap();

    @KeepForSdk
    public static LibraryVersion getInstance() {
        return zzem;
    }

    @VisibleForTesting
    protected LibraryVersion() {
    }

    @KeepForSdk
    public String getVersion(@NonNull String string2) {
        Preconditions.checkNotEmpty(string2, "Please provide a valid libraryName");
        if (this.zzen.containsKey(string2)) {
            return this.zzen.get(string2);
        }
        String string3 = null;
        Properties properties = new Properties();
        try {
            String string4 = String.format("/%s.properties", string2);
            InputStream inputStream = LibraryVersion.class.getResourceAsStream(string4);
            if (inputStream != null) {
                properties.load(inputStream);
                String string5 = string3 = properties.getProperty("version", null);
                zzel.v("LibraryVersion", new StringBuilder(12 + String.valueOf(string2).length() + String.valueOf(string5).length()).append(string2).append(" version is ").append(string5).toString());
            } else {
                String string6 = String.valueOf(string2);
                zzel.e("LibraryVersion", string6.length() != 0 ? "Failed to get app version for libraryName: ".concat(string6) : new String("Failed to get app version for libraryName: "));
            }
        }
        catch (IOException iOException) {
            String string7 = String.valueOf(string2);
            zzel.e("LibraryVersion", string7.length() != 0 ? "Failed to get app version for libraryName: ".concat(string7) : new String("Failed to get app version for libraryName: "), iOException);
        }
        if (string3 == null) {
            string3 = "UNKNOWN";
            zzel.d("LibraryVersion", ".properties file is dropped during release process. Failure to read app version isexpected druing Google internal testing where locally-built libraries are used");
        }
        this.zzen.put(string2, string3);
        return string3;
    }
}

