/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzan;
import com.google.firebase.iid.zzav;
import com.google.firebase.iid.zzax;
import com.google.firebase.iid.zzaz;
import com.google.firebase.iid.zzba;
import java.io.IOException;

final class zzay
implements Runnable {
    private final long zzdj;
    private final PowerManager.WakeLock zzdk;
    private final FirebaseInstanceId zzdl;
    private final zzba zzas;

    @VisibleForTesting
    zzay(FirebaseInstanceId firebaseInstanceId, zzan zzan2, zzba zzba2, long l) {
        this.zzdl = firebaseInstanceId;
        this.zzas = zzba2;
        this.zzdj = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.zzdk = powerManager.newWakeLock(1, "fiid-sync");
        this.zzdk.setReferenceCounted(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SuppressLint(value={"Wakelock"})
    public final void run() {
        block8: {
            block7: {
                try {
                    if (zzav.zzai().zzd(this.getContext())) {
                        this.zzdk.acquire();
                    }
                    this.zzdl.zza(true);
                    if (this.zzdl.zzo()) break block7;
                    this.zzdl.zza(false);
                    if (!zzav.zzai().zzd(this.getContext())) return;
                }
                catch (Throwable throwable) {
                    if (!zzav.zzai().zzd(this.getContext())) throw throwable;
                    this.zzdk.release();
                    throw throwable;
                }
                this.zzdk.release();
                return;
            }
            if (!zzav.zzai().zze(this.getContext()) || this.zzan()) break block8;
            new zzaz(this).zzao();
            if (!zzav.zzai().zzd(this.getContext())) return;
            this.zzdk.release();
            return;
        }
        if (this.zzam() && this.zzas.zzc(this.zzdl)) {
            this.zzdl.zza(false);
        } else {
            this.zzdl.zza(this.zzdj);
        }
        if (!zzav.zzai().zzd(this.getContext())) return;
        this.zzdk.release();
    }

    @VisibleForTesting
    private final boolean zzam() {
        zzax zzax2 = this.zzdl.zzk();
        if (!this.zzdl.zzr() && !this.zzdl.zza(zzax2)) {
            return true;
        }
        try {
            String string = this.zzdl.zzl();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzax2 == null || zzax2 != null && !string.equals(zzax2.zzbr)) {
                String string2;
                String string3 = string2 = string;
                Context context = this.getContext();
                Intent intent = new Intent("com.google.firebase.messaging.NEW_TOKEN");
                intent.putExtra("token", string3);
                zzav.zzc(context, intent);
                Intent intent2 = new Intent("com.google.firebase.iid.TOKEN_REFRESH");
                zzav.zzb(context, intent2);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    final Context getContext() {
        return this.zzdl.zzi().getApplicationContext();
    }

    final boolean zzan() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

