/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.core.data.storages;

import android.content.Context;
import com.devtodev.core.utils.IOUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class IStorage {
    private Context context;
    private HashMap<String, Object> map = new HashMap();

    abstract String getName();

    public IStorage(Context context) {
        this.context = context;
    }

    public void load() {
        String storageFileName = this.getName();
        if (!IOUtils.isStorageExist(this.context, storageFileName)) {
            return;
        }
        String jsonString = IOUtils.loadString(this.context, storageFileName);
        if (jsonString == null || jsonString.isEmpty()) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            this.fromJSON(jsonObject);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
    }

    public void save() {
        String storageFileName = this.getName();
        JSONObject jsonObject = this.toJSON();
        IOUtils.saveString(this.context, storageFileName, jsonObject.toString());
    }

    protected Boolean getBoolean(String key) {
        Object value = this.map.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    protected void setBoolean(String key, Boolean value) {
        this.map.put(key, value);
    }

    private JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            try {
                jsonObject.put(entry.getKey(), entry.getValue());
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
        return jsonObject;
    }

    private void fromJSON(JSONObject jsonObject) {
        this.map = new HashMap();
        Iterator it = jsonObject.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            try {
                this.map.put(key, jsonObject.get(key));
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
    }
}

