/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.core.utils;

import android.content.Context;
import android.os.Build;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.unity3d.player.UnityPlayer;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DeviceHelper {
    public static String getLocale() {
        Locale locale = UnityPlayer.currentActivity.getResources().getConfiguration().locale;
        if (locale == null) {
            return "";
        }
        return locale.toString();
    }

    public static int getTimeZoneOffset() {
        TimeZone tz = TimeZone.getDefault();
        Date now = new Date();
        return tz.getOffset(now.getTime()) / 1000;
    }

    public static String getDeviceModel() {
        String model = Build.MODEL;
        if (model != null) {
            return model;
        }
        return "";
    }

    public static String getDeviceManufacturer() {
        String manufacturer = Build.MANUFACTURER;
        if (manufacturer != null) {
            return manufacturer;
        }
        return "";
    }

    public static String getDeviceOSVersion() {
        String osVersion = Build.VERSION.RELEASE;
        if (osVersion == null) {
            return "";
        }
        return osVersion;
    }

    public static String getAdvertisingId() {
        try {
            Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
            try {
                AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)UnityPlayer.currentActivity);
                String adId = adInfo.getId();
                if (adId != null) {
                    return adId;
                }
                return "";
            }
            catch (Exception e2) {
                return "";
            }
            catch (Error e3) {
                return "";
            }
        }
        catch (ClassNotFoundException e4) {
            e4.printStackTrace();
            return "";
        }
    }

    public static boolean isLimitAdTrackingEnabled() {
        try {
            Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
            try {
                AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)UnityPlayer.currentActivity);
                return adInfo.isLimitAdTrackingEnabled();
            }
            catch (Exception e2) {
                return true;
            }
            catch (Error e3) {
                return true;
            }
        }
        catch (ClassNotFoundException e4) {
            e4.printStackTrace();
            return true;
        }
    }
}

