/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.core.utils;

import android.content.Context;
import com.devtodev.core.utils.CoreAsyncTask;
import com.devtodev.core.utils.IOUtils;
import com.devtodev.core.utils.Logger;
import com.unity3d.player.UnityPlayer;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONObject;

public class SessionInformation {
    private static final String SESSION_DATA_FILE_NAME = "sessionData";
    private static final String SESSION_FILE_NAME = "session";
    private JSONArray savedData = null;
    private String sessionFilePath;
    private String sessionDataFilePath;

    public SessionInformation(String projectId, String userId) {
        this.sessionFilePath = projectId + "_" + SESSION_FILE_NAME;
        this.sessionDataFilePath = projectId + "_" + SESSION_DATA_FILE_NAME;
        this.loadSessionData();
        this.sendStoredRequests(userId);
    }

    private synchronized void loadSessionData() {
        String jsonString = IOUtils.loadStorage((Context)UnityPlayer.currentActivity, String.class, this.sessionDataFilePath);
        this.savedData = new JSONArray();
        try {
            if (jsonString != null && jsonString.length() > 0) {
                this.savedData = new JSONArray(jsonString);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveSessionData() {
        JSONArray jSONArray = this.savedData;
        synchronized (jSONArray) {
            IOUtils.saveStorage((Context)UnityPlayer.currentActivity, this.savedData.toString(), this.sessionDataFilePath);
        }
    }

    public void sendRequest(String userId, String url, String postData) {
        this.saveRequest(userId, url, postData);
        this.sendStoredRequests(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRequest(String userId, String url, String postData) {
        try {
            JSONArray jSONArray = this.savedData;
            synchronized (jSONArray) {
                JSONObject data = new JSONObject();
                data.put("userId", (Object)userId);
                data.put("url", (Object)url);
                data.put("post", (Object)postData);
                this.savedData.put((Object)data);
                this.saveSessionData();
            }
            this.removeLostSessionNative();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void sendStoredRequests(String userId) {
        try {
            JSONObject requestObject;
            int i;
            JSONArray copyArray = new JSONArray();
            for (i = 0; i < this.savedData.length(); ++i) {
                requestObject = this.savedData.getJSONObject(i);
                String requestUserId = requestObject.optString("userId");
                if (requestUserId.equals(userId)) {
                    copyArray.put((Object)requestObject);
                    continue;
                }
                Logger.d("Request related to user(id)='" + requestUserId + "' skipped, because current user(id)='" + userId + "'.\nURL=" + requestObject.optString("url") + "\nBODY=" + requestObject.optString("post"));
            }
            this.savedData = new JSONArray();
            this.saveSessionData();
            for (i = 0; i < copyArray.length(); ++i) {
                requestObject = copyArray.getJSONObject(i);
                this.makeRequest(requestObject);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void makeRequest(final JSONObject requestObject) {
        CoreAsyncTask task = new CoreAsyncTask(new CoreAsyncTask.OnRequestSend(){

            @Override
            public void OnSend(boolean response) {
                Logger.d("Response: " + response);
                if (response) {
                    SessionInformation.this.removeLostSessionNative();
                } else {
                    SessionInformation.this.addToSavedRequests(requestObject);
                    SessionInformation.this.saveSessionData();
                }
            }
        });
        String url = requestObject.optString("url");
        String post = requestObject.optString("post");
        if (url != null && post != null) {
            CoreAsyncTask.Request request = new CoreAsyncTask.Request(url, post);
            task.execute(new CoreAsyncTask.Request[]{request});
        } else {
            this.addToSavedRequests(requestObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSavedRequests(JSONObject requestObject) {
        try {
            JSONArray jSONArray = this.savedData;
            synchronized (jSONArray) {
                this.savedData.put((Object)requestObject);
                this.saveSessionData();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void writeLostSessionNative() {
        if (UnityPlayer.currentActivity == null) {
            return;
        }
        IOUtils.saveStorage((Context)UnityPlayer.currentActivity, String.valueOf(System.currentTimeMillis() / 1000L), this.sessionFilePath);
    }

    public String readLostSessionNative() {
        if (UnityPlayer.currentActivity == null) {
            return "[]";
        }
        String str = IOUtils.loadStorage((Context)UnityPlayer.currentActivity, String.class, this.sessionFilePath);
        if (str != null && str.length() > 0) {
            this.removeLostSessionNative();
            return str;
        }
        return "[]";
    }

    public void removeLostSessionNative() {
        if (UnityPlayer.currentActivity == null) {
            return;
        }
        File file = new File(UnityPlayer.currentActivity.getFilesDir().getAbsolutePath() + File.separator + this.sessionFilePath + "1");
        if (file.exists()) {
            file.delete();
        }
    }
}

