/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.push;

import android.content.Context;
import android.content.Intent;
import com.devtodev.core.utils.IOUtils;
import com.devtodev.push.PushClient;
import com.devtodev.push.PushListener;
import com.devtodev.push.data.PushMessage;
import com.devtodev.push.logic.PushStorage;
import com.devtodev.push.logic.notification.ActionButton;
import com.devtodev.push.utils.MetricsSender;
import com.unity3d.player.UnityPlayer;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class DevToDevPushManager
implements PushListener {
    private static final String LISTENER_NAME = "[devtodev_AsyncOperationDispatcher]";
    private static DevToDevPushManager Instance;
    private PushClient client;
    private boolean isInitialized = false;

    public static DevToDevPushManager getInstance() {
        if (Instance == null) {
            Instance = new DevToDevPushManager();
        }
        return Instance;
    }

    public static DevToDevPushManager getInstance(Context context) {
        if (Instance == null) {
            Instance = new DevToDevPushManager(context);
        }
        return Instance;
    }

    private DevToDevPushManager(Context context) {
        if (this.client == null) {
            this.client = new PushClient(context);
        }
    }

    private DevToDevPushManager() {
        this.client = new PushClient((Context)UnityPlayer.currentActivity);
    }

    public void init(String config) {
        if (this.isInitialized) {
            return;
        }
        this.client.initialize(config);
        this.client.setPushListener(this);
        this.client.setIntent((Context)UnityPlayer.currentActivity, UnityPlayer.currentActivity.getIntent());
        this.isInitialized = true;
    }

    public boolean getNotificationsEnabled() {
        return this.client.getNotificationsEnabled();
    }

    public void setNotificationsEnabled(boolean value) {
        this.client.setNotificationsEnabled(value);
    }

    public void setIntent(Intent pIntent) {
        this.client.setIntent((Context)UnityPlayer.currentActivity, pIntent);
    }

    public String getPushData() {
        try {
            return MetricsSender.getPushDataToSend((Context)UnityPlayer.currentActivity);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
            return "{}";
        }
    }

    public void setCustomSmallIcon(String iconId) {
        PushStorage pushStorage = IOUtils.loadStorage((Context)UnityPlayer.currentActivity, PushStorage.class, PushStorage.NAME);
        pushStorage.setSmallIcon(iconId);
        IOUtils.saveStorage((Context)UnityPlayer.currentActivity, pushStorage, PushStorage.NAME);
    }

    public void setCustomLargeIcon(String iconId) {
        PushStorage pushStorage = IOUtils.loadStorage((Context)UnityPlayer.currentActivity, PushStorage.class, PushStorage.NAME);
        pushStorage.setLargeIcon(iconId);
        IOUtils.saveStorage((Context)UnityPlayer.currentActivity, pushStorage, PushStorage.NAME);
    }

    public PushListener getListener() {
        return this;
    }

    @Override
    public void onRegisteredForPushNotifications(String deviceId) {
        try {
            UnityPlayer.UnitySendMessage((String)LISTENER_NAME, (String)"onRegisteredForPushNotifications", (String)deviceId);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void onFailedToRegisteredForPushNotifications(String error) {
        try {
            UnityPlayer.UnitySendMessage((String)LISTENER_NAME, (String)"onFailedToRegisteredForPushNotifications", (String)error);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void onPushNotificationsReceived(Map<String, String> message) {
        JSONObject js = null;
        try {
            js = new JSONObject();
            for (Map.Entry<String, String> entry : message.entrySet()) {
                js.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            UnityPlayer.UnitySendMessage((String)LISTENER_NAME, (String)"onPushNotificationsReceived", (String)(js != null ? js.toString() : ""));
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    @Override
    public void onPushNotificationOpened(PushMessage pushMessage, ActionButton actionButton) {
        try {
            JSONObject jsMessage = pushMessage.ToJSON();
            JSONObject jsButton = null;
            if (actionButton != null) {
                jsButton = actionButton.ToJSON();
            }
            JSONObject fullMessage = new JSONObject();
            fullMessage.put("message", (Object)jsMessage);
            if (actionButton != null) {
                fullMessage.put("action", (Object)jsButton);
            }
            UnityPlayer.UnitySendMessage((String)LISTENER_NAME, (String)"onPushNotificationOpened", (String)fullMessage.toString());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void onPushReceived(Context context, PushMessage message) {
        this.client.onPushReceived(context, message);
    }

    public void onPushClicked(Context context, PushMessage message, String buttonId) {
        this.client.onPushClicked(context, message, buttonId);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }
}

