/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.push.firebase;

import android.content.Context;
import android.util.Log;
import com.devtodev.push.DevToDevPushManager;
import com.devtodev.push.data.metrics.TokenSend;
import com.devtodev.push.utils.MetricsSender;
import com.devtodev.push.utils.NotificationMaker;
import com.devtodev.push.utils.PushStorageUtils;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Map;

public class DTDFcmMessagingService
extends FirebaseMessagingService {
    private static final String DTDFlag = "_k";

    public void onMessageReceived(RemoteMessage remoteMessage) {
        Log.d((String)"DTDFcmMessagingService", (String)remoteMessage.toString());
        Map messageData = remoteMessage.getData();
        if (messageData.containsKey(DTDFlag)) {
            this.sendNotification(messageData);
        } else {
            super.onMessageReceived(remoteMessage);
        }
    }

    public void onNewToken(String token) {
        this.sendRegistrationToListener(token);
        this.sendRegistrationToServer(token);
    }

    private void sendRegistrationToListener(String token) {
        DevToDevPushManager.getInstance((Context)this).getListener().onRegisteredForPushNotifications(token);
    }

    private void sendRegistrationToServer(String token) {
        PushStorageUtils.storeRegistrationId((Context)this, token);
        MetricsSender.saveMetricToStorage((Context)this, new TokenSend(token));
    }

    private void sendNotification(Map<String, String> bundle) {
        new NotificationMaker().execute(new Object[]{this, bundle});
    }
}

