/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.push.logic;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import androidx.core.app.NotificationManagerCompat;
import com.devtodev.push.DevToDevPushManager;
import com.devtodev.push.data.PushMessage;
import com.devtodev.push.data.metrics.PushOpen;
import com.devtodev.push.logic.notification.ActionButton;
import com.devtodev.push.logic.notification.ActionType;
import com.devtodev.push.utils.MetricsSender;
import java.io.Serializable;

public class PushClickReceiver
extends BroadcastReceiver {
    public static final String TAG = "ActionButtonService";
    public static final String ACTION_CLICK = "com.devtodev.android.push.CLICKED";

    public void onReceive(Context context, Intent intent) {
        PushMessage pushMessage = (PushMessage)intent.getSerializableExtra("com.devtodev.android.MESSAGE_BUNDLE");
        if (pushMessage != null) {
            int _k = pushMessage.getSystemId();
            String buttonId = intent.getStringExtra("com.devtodev.android.BUTTON_ID");
            ActionButton button = this.getClickedButton(pushMessage, buttonId);
            if (button != null) {
                if (button.isBackground()) {
                    MetricsSender.saveMetricToStorage(context, new PushOpen(_k, buttonId));
                } else {
                    this.startMainActivity(context, pushMessage, button);
                }
            } else {
                this.startMainActivity(context, pushMessage, button);
            }
            DevToDevPushManager.getInstance(context).onPushClicked(context, pushMessage, buttonId);
            NotificationManagerCompat.from((Context)context).cancel(_k);
            context.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
        }
    }

    private void startMainActivity(Context context, PushMessage pushMessage, ActionButton button) {
        PackageManager packageManager = context.getPackageManager();
        Intent launchIntent = packageManager.getLaunchIntentForPackage(context.getPackageName());
        if (launchIntent != null) {
            String deepLink;
            launchIntent.addFlags(0x24000000);
            launchIntent.putExtra("com.devtodev.android.MESSAGE_BUNDLE", (Serializable)pushMessage);
            if (button != null) {
                launchIntent.putExtra("com.devtodev.android.BUTTON_ID", button.getId());
            }
            if ((deepLink = this.getDeepLink(pushMessage, button)) != null) {
                launchIntent.setData(Uri.parse((String)deepLink));
            }
            context.startActivity(launchIntent);
        }
    }

    private String getDeepLink(PushMessage pushMessage, ActionButton button) {
        if (button != null) {
            if (button.getActionType() == ActionType.DEEPLINK) {
                return button.getActionString();
            }
        } else if (pushMessage.getActionType() == ActionType.DEEPLINK) {
            return pushMessage.getActionString();
        }
        return null;
    }

    private ActionButton getClickedButton(PushMessage pushMessage, String id) {
        if (id == null) {
            return null;
        }
        for (ActionButton button : pushMessage.getActions()) {
            if (!button.getId().equals(id)) continue;
            return button;
        }
        return null;
    }
}

