/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.push.logic;

import android.os.Bundle;
import com.devtodev.core.utils.Logger;
import com.devtodev.push.data.PushMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class PushStorage
implements Serializable {
    public static String NAME = "PS";
    private static final long serialVersionUID = 1L;
    public String savedBundle;
    private ArrayList<Integer> clickedPushes = new ArrayList();
    private String smallIcon;
    private String largeIcon;
    private PushMessage savedMessage;
    private LinkedList<PushMessage> savedMessages = new LinkedList();
    private LinkedList<String> savedActions = new LinkedList();

    public boolean contains(PushMessage message) {
        this.createSavedMessageArray();
        LinkedList<PushMessage> copiedList = this.savedMessages;
        for (PushMessage pushMessage : copiedList) {
            if (pushMessage.getSystemId() != message.getSystemId()) continue;
            return true;
        }
        return false;
    }

    public void pushMessage(PushMessage push) {
        this.createSavedMessageArray();
        this.savedMessages.addFirst(push);
    }

    public void pushActionId(String actionId) {
        this.createSavedActionsArray();
        if (actionId != null) {
            this.savedActions.addFirst(actionId);
        } else {
            this.savedActions.addFirst("");
        }
    }

    public PushMessage popMesage() {
        this.createSavedMessageArray();
        return this.savedMessages.removeLast();
    }

    public String popActionId() {
        this.createSavedActionsArray();
        return this.savedActions.removeLast();
    }

    public boolean hasStoredNotifications() {
        this.createSavedMessageArray();
        return this.savedMessages.size() > 0;
    }

    private void createSavedMessageArray() {
        if (this.savedMessages == null) {
            this.savedMessages = new LinkedList();
        }
    }

    private void createSavedActionsArray() {
        if (this.savedActions == null) {
            this.savedActions = new LinkedList();
        }
    }

    public void setSavedBundle(Bundle bundle) {
        if (bundle != null) {
            JSONObject jsonObject = new JSONObject();
            try {
                Set keySet = bundle.keySet();
                Iterator it = keySet.iterator();
                String key = null;
                Object value = null;
                while (it.hasNext()) {
                    key = (String)it.next();
                    value = bundle.get(key);
                    if (key == null || value == null) continue;
                    jsonObject.put(key, value);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            this.savedBundle = jsonObject.toString();
        }
    }

    public Bundle getSavedBundle() {
        if (this.savedBundle == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        try {
            JSONObject jsonObject = new JSONObject(this.savedBundle);
            Iterator iter = jsonObject.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    Object value = jsonObject.get(key);
                    bundle.putString(key, value.toString());
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (JSONException e3) {
            e3.printStackTrace();
        }
        return bundle;
    }

    public void clearSavedBundle() {
        this.savedBundle = null;
    }

    public boolean isPushIdExist(Integer pushId) {
        if (this.clickedPushes == null) {
            this.clickedPushes = new ArrayList();
        }
        Logger.d("pushId: " + pushId);
        Logger.d("clickedPushes: " + this.clickedPushes.toString());
        return this.clickedPushes.contains(pushId);
    }

    public void addPushId(Integer pushId) {
        this.clickedPushes.add(pushId);
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }
}

