/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.push.logic.notification;

import androidx.annotation.Nullable;
import com.devtodev.push.logic.notification.ActionType;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionButton {
    public static final String ID = "id";
    public static final String ICON = "icon";
    public static final String TEXT = "text";
    public static final String MODE = "activationMode";
    private String id;
    private String icon;
    private String text;
    private ActionType actionType;
    private String actionString;
    private String activationMode;

    public ActionButton(JSONObject buttonObject) {
        try {
            this.id = buttonObject.optString(ID);
            this.icon = buttonObject.optString(ICON);
            this.text = buttonObject.optString(TEXT);
            this.activationMode = buttonObject.optString(MODE);
            if (buttonObject.has(ActionType.URL.getKey())) {
                this.actionType = ActionType.URL;
            } else if (buttonObject.has(ActionType.SHARE.getKey())) {
                this.actionType = ActionType.SHARE;
            } else if (buttonObject.has(ActionType.DEEPLINK.getKey())) {
                this.actionType = ActionType.DEEPLINK;
            }
            if (this.actionType != null) {
                this.actionString = buttonObject.getString(this.actionType.getKey());
            }
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getText() {
        return this.text;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getActionString() {
        return this.actionString;
    }

    public boolean isBackground() {
        return this.activationMode.equalsIgnoreCase("background");
    }

    public String toString() {
        return "ActionButton{id='" + this.id + '\'' + ", icon='" + this.icon + '\'' + ", text='" + this.text + '\'' + ", actionType=" + (Object)((Object)this.actionType) + ", actionString='" + this.actionString + '\'' + ", activationMode=" + this.activationMode + '}';
    }

    @Nullable
    public JSONObject ToJSON() {
        try {
            JSONObject jso = new JSONObject();
            jso.put("actionType", (this.actionType == null ? -1 : this.actionType.ordinal()) + 1);
            jso.put("actionString", (Object)this.actionString);
            jso.put(ID, (Object)this.id);
            jso.put(TEXT, (Object)this.text);
            return jso;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }
}

