/*
 * Decompiled with CFR 0.152.
 */
package com.devtodev.push.utils;

import android.content.Context;
import com.devtodev.core.data.metrics.Metric;
import com.devtodev.core.utils.IOUtils;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MetricsSender {
    private static final String TAG = "MetricsSender";

    public static String getPushDataToSend(Context context) throws JSONException {
        ArrayList savedMetrics = IOUtils.loadStorage(context, ArrayList.class, TAG);
        if (savedMetrics.size() > 0) {
            JSONObject object = new JSONObject();
            object.put("po", (Object)new JSONArray());
            object.put("pr", (Object)new JSONArray());
            object.put("pt", (Object)new JSONArray());
            for (Object metric : savedMetrics) {
                String code = ((Metric)metric).getMetricCode();
                if (code.equals("po")) {
                    object.optJSONArray("po").put((Object)((Metric)metric).toJSON());
                }
                if (code.equals("pr")) {
                    object.optJSONArray("pr").put((Object)((Metric)metric).toJSON());
                }
                if (!code.equals("pt")) continue;
                object.optJSONArray("pt").put((Object)((Metric)metric).toJSON());
            }
            savedMetrics.clear();
            IOUtils.saveStorage(context, savedMetrics, TAG);
            return object.toString();
        }
        return "{}";
    }

    public static synchronized void saveMetricToStorage(Context context, Metric metric) {
        ArrayList savedMetrics = IOUtils.loadStorage(context, ArrayList.class, TAG);
        savedMetrics.add(metric);
        IOUtils.saveStorage(context, savedMetrics, TAG);
    }
}

