/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk;

import android.content.Context;
import android.content.pm.PackageManager;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.internal.Utils;
import com.unity.udp.sdk.provider.ChannelProvider;
import com.unity.udp.sdk.provider.ChannelProviderActivityLifecycle;
import com.unity3d.player.UnityPlayer;

public class ActivityExtension {
    private static ChannelProviderActivityLifecycle lifecycle = ActivityExtension.selectProviderLifecycle();

    public static void onCreate() {
        lifecycle.onCreate();
    }

    public static void onStart() {
        lifecycle.onStart();
    }

    public static void onRestart() {
        lifecycle.onRestart();
    }

    public static void onPause() {
        lifecycle.onPause();
    }

    public static void onResume() {
        lifecycle.onResume();
    }

    public static void onStop() {
        lifecycle.onStop();
    }

    public static void onDestroy() {
        lifecycle.onDestroy();
    }

    public static void setLifecycle(ChannelProviderActivityLifecycle providerLifecycle) {
        lifecycle = providerLifecycle;
    }

    private static ChannelProviderActivityLifecycle selectProviderLifecycle() {
        String serviceName;
        try {
            serviceName = Utils.getAndroidMetadata((Context)UnityPlayer.currentActivity, "CHANNEL_NAME");
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.logError((String)"Cannot select provider");
            return new ChannelProviderActivityLifecycle(){};
        }
        if (Utils.isEmptyString(serviceName)) {
            Logger.logError((String)"Cannot select provider");
        }
        return ChannelProvider.getChannelProviderLifeCycle(serviceName);
    }
}

