/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.internal.Utils;
import com.unity.udp.sdk.provider.ChannelProvider;
import com.unity.udp.sdk.provider.ChannelProviderApplicationExtension;

public class ApplicationExtensionSelector {
    static ChannelProviderApplicationExtension applicationExtension;

    public static void onCreate(Application application) {
        if (applicationExtension == null) {
            applicationExtension = ApplicationExtensionSelector.selectApplicationExtension(application.getApplicationContext());
        }
        applicationExtension.onCreate(application);
    }

    private static ChannelProviderApplicationExtension selectApplicationExtension(Context context) {
        String serviceName;
        try {
            serviceName = Utils.getAndroidMetadata(context, "CHANNEL_NAME");
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.logError((String)"Cannot select provider");
            return new ChannelProviderApplicationExtension(){};
        }
        if (Utils.isEmptyString(serviceName)) {
            Logger.logError((String)"Cannot select provider");
        }
        return ChannelProvider.getApplicationExtension(serviceName);
    }
}

