/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk;

import com.unity.udp.sdk.common.ItemType;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.common.rest.BaseModel;
import org.json.JSONException;
import org.json.JSONObject;

public class PurchaseInfo
extends BaseModel {
    private String itemType = ItemType.inapp.name();
    private String productId;
    private String gameOrderId;
    private String orderQueryToken;
    private String developerPayload;
    private String storePurchaseJsonString;
    private String store;

    public PurchaseInfo(Builder builder) {
        this.productId = builder.productId;
        this.gameOrderId = builder.gameOrderId;
        this.developerPayload = builder.developerPayload;
        this.itemType = builder.itemType;
        this.storePurchaseJsonString = builder.storePurchaseJsonString;
        this.orderQueryToken = builder.orderQueryToken;
        this.store = builder.store;
    }

    @Deprecated
    public PurchaseInfo() {
    }

    public String getProductId() {
        return this.productId;
    }

    public PurchaseInfo setProductId(String productId) {
        this.productId = productId;
        return this;
    }

    public String getGameOrderId() {
        return this.gameOrderId;
    }

    public PurchaseInfo setGameOrderId(String gameOrderId) {
        this.gameOrderId = gameOrderId;
        return this;
    }

    public String getOrderQueryToken() {
        return this.orderQueryToken;
    }

    public PurchaseInfo setOrderQueryToken(String orderQueryToken) {
        this.orderQueryToken = orderQueryToken;
        return this;
    }

    public String getDeveloperPayload() {
        return this.developerPayload;
    }

    public PurchaseInfo setDeveloperPayload(String developerPayload) {
        this.developerPayload = developerPayload;
        return this;
    }

    public String getStorePurchaseJsonString() {
        return this.storePurchaseJsonString;
    }

    public PurchaseInfo setStorePurchaseJsonString(String storePurchaseJsonString) {
        this.storePurchaseJsonString = storePurchaseJsonString;
        return this;
    }

    public String getStore() {
        return this.store;
    }

    public PurchaseInfo setStore(String store) {
        this.store = store;
        return this;
    }

    public String getItemType() {
        return this.itemType;
    }

    public PurchaseInfo setItemType(String itemType) throws IllegalArgumentException {
        this.itemType = ItemType.checkArgument((String)itemType);
        return this;
    }

    public String toJsonString() {
        JSONObject object = new JSONObject();
        try {
            object.put("itemType", (Object)this.itemType);
            object.put("productId", (Object)this.productId);
            object.put("gameOrderId", (Object)this.gameOrderId);
            object.put("orderQueryToken", (Object)this.orderQueryToken);
            object.put("developerPayload", (Object)this.developerPayload);
            object.put("store", (Object)this.store);
        }
        catch (JSONException ex) {
            Logger.logError((String)("Assemble purchaseInfo JSON error: " + ex.getMessage()));
        }
        return object.toString();
    }

    public static class Builder {
        private String productId;
        private String gameOrderId;
        private String orderQueryToken;
        private String developerPayload;
        private String storePurchaseJsonString;
        private String store;
        private String itemType = ItemType.inapp.name();

        public Builder(String productId, String gameOrderId) {
            this.gameOrderId = gameOrderId;
            this.productId = productId;
        }

        public Builder orderQueryToken(String orderQueryToken) {
            this.orderQueryToken = orderQueryToken;
            return this;
        }

        public Builder developerPayload(String developerPayload) {
            this.developerPayload = developerPayload;
            return this;
        }

        public Builder storePurchaseJsonString(String storePurchaseJsonString) {
            this.storePurchaseJsonString = storePurchaseJsonString;
            return this;
        }

        public Builder store(String store) {
            this.store = store;
            return this;
        }

        public Builder itemType(String itemType) {
            if (!itemType.equalsIgnoreCase(ItemType.inapp.name()) && !itemType.equalsIgnoreCase(ItemType.subs.name())) {
                throw new IllegalArgumentException("ItemType must be either inapp or subs");
            }
            this.itemType = itemType;
            return this;
        }

        public PurchaseInfo build() {
            return new PurchaseInfo(this);
        }
    }
}

