/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk.internal;

import android.net.Uri;

public class UdpPayloadHelper {
    private static final String SCHEME = "unity";
    private static final String AUTHORITY = "unity3d.com";
    private static final String PAYLOAD_PARAMETER = "payload";
    private static final String CPORDERID_PARAMETER = "cpOrderId";

    public static String buildIntentPayload(String developerPayload, String cpOrderId) {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(SCHEME).authority(AUTHORITY).appendQueryParameter(CPORDERID_PARAMETER, cpOrderId);
        if (developerPayload != null) {
            builder.appendQueryParameter(PAYLOAD_PARAMETER, developerPayload);
        }
        return builder.toString();
    }

    public static String getCpOrderId(String uriString) {
        Uri uri = Uri.parse((String)uriString);
        if (uri.getScheme().equalsIgnoreCase(SCHEME)) {
            return uri.getQueryParameter(CPORDERID_PARAMETER);
        }
        return null;
    }

    public static String getPayload(String uriString) {
        Uri uri = Uri.parse((String)uriString);
        if (uri.getScheme().equalsIgnoreCase(SCHEME)) {
            return uri.getQueryParameter(PAYLOAD_PARAMETER);
        }
        return null;
    }
}

