/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk.provider.udp;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import com.unity.udp.sdk.AppInfo;
import com.unity.udp.sdk.InitCallback;
import com.unity.udp.sdk.LicenseCheckCallback;
import com.unity.udp.sdk.PurchaseCallback;
import com.unity.udp.sdk.PurchaseInfo;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.internal.ChannelHandler;
import com.unity.udp.sdk.provider.ChannelProviderHelper;
import com.unity.udp.sdk.provider.ChannelProviderService;
import com.unity.udp.sdk.provider.udp.UdpHelper;
import com.unity.udp.sdk.provider.udp.UdpPurchaseCallback;
import com.unity.udp.udpsandbox.Purchase;
import com.unity.udp.udpsandbox.UDPPurchasing;
import java.util.ArrayList;
import java.util.List;

public class UdpProviderService
extends ChannelProviderService {
    static final String CHANNEL = "UDP";
    private static final String DISPLAY_NAME = "UdpSandbox";
    private UDPPurchasing udpPurchasing = UDPPurchasing.getInstance();
    private UdpHelper helper = UdpHelper.getInstance();
    private ChannelHandler handler;

    public String getProviderName() {
        return CHANNEL;
    }

    public String getProviderDisplayName() {
        return DISPLAY_NAME;
    }

    public void init(Activity activity, AppInfo appInfo, ChannelHandler handler, InitCallback initCallback) {
        com.unity.udp.udpsandbox.AppInfo udpAppInfo = new com.unity.udp.udpsandbox.AppInfo();
        udpAppInfo.setClientId(appInfo.getClientId());
        udpAppInfo.setClientSecret(appInfo.getClientSecret());
        udpAppInfo.setAppSlug(appInfo.getAppSlug());
        this.handler = handler;
        UdpPurchaseCallback callback = new UdpPurchaseCallback(handler, initCallback);
        this.udpPurchasing.init((Context)activity, udpAppInfo, callback);
    }

    public void handlePremiseValidationError(Activity activity, int errorCode) {
    }

    public void licenseCheck(Activity activity, Handler handler, LicenseCheckCallback callback) {
    }

    public void purchase(Activity activity, PurchaseInfo purchaseInfo, PurchaseCallback purchaseCallback) {
        this.udpPurchasing.purchase(purchaseInfo.getProductId(), purchaseInfo.getGameOrderId(), purchaseInfo.getDeveloperPayload(), new UdpPurchaseCallback(this.handler, purchaseCallback));
    }

    public void queryInventory(String[] productIds, PurchaseCallback purchaseCallback) {
        this.udpPurchasing.getProducts(productIds, new UdpPurchaseCallback(this.handler, purchaseCallback));
    }

    public void consumePurchase(PurchaseInfo purchaseInfo, PurchaseCallback purchaseCallback) {
        Purchase udpPurchase = this.helper.purchaseInfo2Purchase(purchaseInfo);
        this.udpPurchasing.consumePurchase(udpPurchase, new UdpPurchaseCallback(this.handler, purchaseCallback));
    }

    public void consumePurchases(List<PurchaseInfo> purchaseInfos, PurchaseCallback purchaseCallback) {
        ArrayList<Purchase> purchases = new ArrayList<Purchase>();
        for (PurchaseInfo pi : purchaseInfos) {
            purchases.add(this.helper.purchaseInfo2Purchase(pi));
        }
        this.udpPurchasing.consumePurchases(purchases, new UdpPurchaseCallback(this.handler, purchaseCallback));
    }

    public void enableDebugLogging(boolean isEnable) {
        Logger.enableDebugLog((boolean)isEnable);
    }

    public void enableDebugLogging(boolean isEnable, String tag) {
        Logger.enableDebugLog((boolean)isEnable, (String)tag);
    }

    public ChannelProviderHelper getHelper() {
        return this.helper;
    }

    public boolean needRsaPublicKey() {
        return false;
    }
}

