/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk.provider.udp;

import android.os.Handler;
import com.unity.udp.sdk.InitCallback;
import com.unity.udp.sdk.InventoryInfo;
import com.unity.udp.sdk.PurchaseCallback;
import com.unity.udp.sdk.ResultCode;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.internal.ChannelHandler;
import com.unity.udp.sdk.internal.Utils;
import com.unity.udp.sdk.provider.udp.UdpHelper;
import com.unity.udp.udpsandbox.IUDPPurchaseCallback;
import com.unity.udp.udpsandbox.Product;
import com.unity.udp.udpsandbox.Purchase;
import com.unity.udp.udpsandbox.UDPPurchasing;
import java.util.List;

public class UdpPurchaseCallback
implements IUDPPurchaseCallback {
    private static String CHANNEL_NAME = "UDP";
    UDPPurchasing udpPurchasing = UDPPurchasing.getInstance();
    ChannelHandler handler;
    InventoryInfo inventoryInfo;
    UdpHelper helper = UdpHelper.getInstance();
    private PurchaseCallback purchaseCallback;
    private InitCallback initCallback;

    public UdpPurchaseCallback(ChannelHandler handler, PurchaseCallback purchaseCallback) {
        this.handler = handler;
        this.purchaseCallback = purchaseCallback;
    }

    public UdpPurchaseCallback(ChannelHandler handler, InitCallback initCallback) {
        this.handler = handler;
        this.initCallback = initCallback;
    }

    @Override
    public void onInitSucceeded(String userId) {
        Logger.logInfo((String)"[UDP] onInitSucceeded");
        Utils.sendInitMessage((Handler)this.handler, (String)CHANNEL_NAME, (Integer)ResultCode.SDK_INIT_SUCCESS, (String)"", (String)userId, (String)"", (InitCallback)this.initCallback);
    }

    @Override
    public void onInitFailed(String message) {
        Logger.logInfo((String)("[UDP] Initialization failed: " + message));
        Utils.sendInitMessage((Handler)this.handler, (String)CHANNEL_NAME, (Integer)ResultCode.SDK_INIT_ERROR, (String)message, (String)"", (String)"", (InitCallback)this.initCallback);
    }

    @Override
    public void onPurchaseSucceeded(Purchase purchase) {
        Logger.logInfo((String)"[UDP] onPurchaseSucceeded");
        Utils.sendPurchaseMessage((Handler)this.handler, (String)CHANNEL_NAME, (Integer)ResultCode.SDK_PURCHASE_SUCCESS, (String)this.helper.purchase2JsonString(purchase), (String)"", (PurchaseCallback)this.purchaseCallback);
    }

    @Override
    public void onPurchaseFailed(String message, Purchase purchase) {
        Logger.logInfo((String)"[UDP] onPurchaseFailed");
        Utils.sendPurchaseMessage((Handler)this.handler, (String)CHANNEL_NAME, (Integer)ResultCode.SDK_PURCHASE_FAILED, (String)this.helper.purchase2JsonString(purchase), (String)message, (PurchaseCallback)this.purchaseCallback);
    }

    @Override
    public void onConsumeSucceeded(Purchase purchase) {
        Logger.logInfo((String)"[UDP] onConsumeSucceeded");
        Utils.sendConsumeMessage((Handler)this.handler, (String)CHANNEL_NAME, (Integer)ResultCode.SDK_CONSUME_PURCHASE_SUCCESS, (String)this.helper.purchase2JsonString(purchase), (String)"", (PurchaseCallback)this.purchaseCallback);
    }

    @Override
    public void onConsumeFailed(String message, Purchase purchase) {
        Logger.logInfo((String)"[UDP] onConsumeFailed");
        Utils.sendConsumeMessage((Handler)this.handler, (String)CHANNEL_NAME, (Integer)ResultCode.SDK_CONSUME_PURCHASE_FAILED, (String)this.helper.purchase2JsonString(purchase), (String)message, (PurchaseCallback)this.purchaseCallback);
    }

    @Override
    public void onGetProductsSucceeded(List<Product> products) {
        Logger.logInfo((String)"[UDP] onGetProductsSucceeded");
        this.inventoryInfo = new InventoryInfo();
        for (Product product : products) {
            this.inventoryInfo.addProductInfo(this.helper.product2ProductInfo(this.handler, product));
        }
        this.udpPurchasing.getPurchases(this);
    }

    @Override
    public void onGetProductsFailed(String message) {
        Logger.logInfo((String)"[UDP] onGetProductsFailed");
        Utils.sendQueryInventoryMessage((ChannelHandler)this.handler, (String)CHANNEL_NAME, (Integer)ResultCode.SDK_QUERY_INVENTORY_FAILED, null, (String)message, (PurchaseCallback)this.purchaseCallback);
    }

    @Override
    public void onGetPurchaseSucceeded(List<Purchase> purchases) {
        Logger.logInfo((String)"[UDP] onGetPurchaseSucceeded");
        for (Purchase purchase : purchases) {
            this.inventoryInfo.addPurchaseInfo(this.helper.purchase2PurchaseInfo(this.handler, purchase));
        }
        Utils.sendQueryInventoryMessage((ChannelHandler)this.handler, (String)CHANNEL_NAME, (Integer)ResultCode.SDK_QUERY_INVENTORY_SUCCESS, (InventoryInfo)this.inventoryInfo, (String)"", (PurchaseCallback)this.purchaseCallback);
    }

    @Override
    public void onGetPurchaseFailed(String message) {
        Logger.logInfo((String)"[UDP] onGetPurchaseFailed");
        Utils.sendPurchaseMessage((Handler)this.handler, (String)CHANNEL_NAME, (Integer)ResultCode.SDK_QUERY_INVENTORY_FAILED, null, (String)message, (PurchaseCallback)this.purchaseCallback);
    }
}

