/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.udpsandbox;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.udpsandbox.R;
import com.unity.udp.udpsandbox.rest.UdpSandboxRestClient;
import com.unity.udp.udpsandbox.rest.model.PostTokenRequest;
import com.unity.udp.udpsandbox.rest.model.PostTokenResponse;

public class LoginActivity
extends Activity {
    private static final String TITLE_SIGN = "UDP Login";
    boolean logingIn = false;
    Context context;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.udp_login_activity);
        View someView = this.findViewById(R.id.emailText);
        View root = someView.getRootView();
        root.setBackgroundColor(this.getResources().getColor(17170443));
        this.setTitle(TITLE_SIGN);
        this.context = this;
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public void sendLoginInfo(View view) {
        if (this.logingIn) {
            Toast.makeText((Context)this, (CharSequence)"Login is being requested, please wait", (int)1).show();
            return;
        }
        this.logingIn = true;
        final Intent resultIntent = new Intent();
        final EditText emailTextField = (EditText)this.findViewById(R.id.emailText);
        final EditText passwordTextField = (EditText)this.findViewById(R.id.passwordText);
        Logger.logInfo((String)String.format("Email: %s, Password: ******", emailTextField.getText().toString()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                PostTokenRequest request = new PostTokenRequest();
                request.setClient_id(LoginActivity.this.getIntent().getStringExtra("client_id"));
                request.setClient_secret(LoginActivity.this.getIntent().getStringExtra("client_secret"));
                request.setExternal_id(emailTextField.getText().toString());
                request.setExternal_token(passwordTextField.getText().toString());
                try {
                    PostTokenResponse resposne = UdpSandboxRestClient.getInstance().postToken(request);
                    resultIntent.putExtra("access_token", resposne.getAccess_token());
                    resultIntent.putExtra("refresh_token", resposne.getRefresh_token());
                    resultIntent.putExtra("user_id", resposne.getUser());
                    LoginActivity.this.setResult(-1, resultIntent);
                    LoginActivity.this.logingIn = false;
                    LoginActivity.this.finish();
                }
                catch (RuntimeException e) {
                    LoginActivity.this.logingIn = false;
                    LoginActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)LoginActivity.this.context, (CharSequence)("Login Failed: " + e.getMessage()), (int)1).show();
                            Logger.logDebug((String)("Login Failed: " + e.getMessage()));
                        }
                    });
                }
            }
        }).start();
    }
}

