/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.udpsandbox;

import com.unity.udp.udpsandbox.Product;
import com.unity.udp.udpsandbox.Purchase;
import com.unity.udp.udpsandbox.rest.model.GetAllProductsResponse;
import com.unity.udp.udpsandbox.rest.model.GetPurchaseResponse;
import com.unity.udp.udpsandbox.rest.model.Item;
import com.unity.udp.udpsandbox.rest.model.PurchaseResponse;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    public static final String TAG = "Unity";
    static final String USER_ID_STRING = "user_id";
    static final String CLIENT_ID_STRING = "client_id";
    static final String CLIENT_SECRET_STRING = "client_secret";
    static final String EXTERNAL_ID_STRING = "external_id";
    static final String EXTERNAL_TOKEN_STRING = "external_token";
    static final String ACCESS_TOKEN_STRING = "access_token";
    static final String REFRESH_TOKEN_STRING = "refresh_token";
    public static final String EXTERNAL_TYPE = "SINGLE_EMAIL_PLAYER";
    public static final String GRANT_TYPE = "CLIENT_CREDENTIALS_PLAYER";
    public static final String SCOPE = "player offline";
    public static final String TOKEN_STRING = "token";

    static Purchase purchaseResponse2Purchase(PurchaseResponse purchaseResponse) {
        Purchase purchase = new Purchase();
        purchase.setCpOrderId(purchaseResponse.getCpOrderId());
        purchase.setProductId(purchaseResponse.getItem()[0].getItemSlug());
        purchase.setOrderId(purchaseResponse.getItem()[0].getOrderId());
        purchase.setTotalAmount(Double.parseDouble(purchaseResponse.getTotalAmount()));
        purchase.setCurrency(purchaseResponse.getCurrency());
        purchase.setPrice(purchaseResponse.getTotalAmount() + purchaseResponse.getCurrency());
        purchase.setDeveloperPayload(purchaseResponse.getDeveloperPayload());
        purchase.setPayload("");
        purchase.setPurchaseToken("");
        purchase.setSignature("");
        return purchase;
    }

    static List<Purchase> getPurchaseResponse2Purchases(GetPurchaseResponse getPurchaseResponse) {
        LinkedList<Purchase> purchases = new LinkedList<Purchase>();
        for (int i = 0; i < getPurchaseResponse.getTotal(); ++i) {
            GetPurchaseResponse.Result result = getPurchaseResponse.getResults()[i];
            Purchase purchase = new Purchase();
            purchase.setOrderId(result.getOrderId());
            purchase.setCpOrderId(result.getCpOrderId());
            purchase.setProductId(result.getItemSlug());
            purchase.setTotalAmount(result.getAmount());
            purchase.setCurrency(result.getCurrency());
            purchase.setPrice(result.getAmount() + result.getCurrency());
            purchase.setSignature("");
            purchase.setPurchaseToken("");
            purchase.setPayload("");
            purchases.add(purchase);
        }
        return purchases;
    }

    static List<Product> getProductsResponse2Products(GetAllProductsResponse getAllProductsResponse) {
        LinkedList<Product> products = new LinkedList<Product>();
        for (int i = 0; i < getAllProductsResponse.getTotal(); ++i) {
            Product product = Utils.item2Product(getAllProductsResponse.getResults()[i]);
            products.add(product);
        }
        return products;
    }

    static Product item2Product(Item item) {
        String currencyPatternString;
        Product product = new Product();
        product.setProductId(item.getSlug());
        product.setType(item.getType());
        product.setId(item.getId());
        product.setTitle(item.getName());
        product.setDescription(item.getProperties().getDescription());
        String priceSet = item.getPriceSets();
        String pricePatternStr = "(?:\"price\" ?: ?\")([0-9.]+)(?:\")";
        Pattern pattern = Pattern.compile(pricePatternStr);
        Matcher matcher = pattern.matcher(priceSet);
        if (matcher.find()) {
            String price = matcher.group(1);
            product.setPriceAmountMicros((long)(Double.parseDouble(price) * 1000000.0));
        }
        if ((matcher = (pattern = Pattern.compile(currencyPatternString = "(?:\"currency\" ?: ?\")(\\w+)(?:\")")).matcher(priceSet)).find()) {
            product.setCurrency(matcher.group(1));
        }
        if (product.getCurrency() != null) {
            product.setPrice((double)product.getPriceAmountMicros() / 1000000.0 + product.getCurrency());
        }
        product.setConsumable(item.isConsumable());
        return product;
    }

    public static String parsingException(Exception e) {
        String exceptionMessage = e.getMessage();
        try {
            JSONObject jsonObject = new JSONObject(exceptionMessage);
            return jsonObject.getString("message");
        }
        catch (JSONException e1) {
            return e.getMessage();
        }
    }
}

