/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk.common.rest;

import com.unity.udp.sdk.common.rest.BaseModel;
import com.unity.udp.sdk.common.rest.HttpMethod;
import com.unity.udp.sdk.common.rest.RestResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class RestClient {
    protected static final String JSON_TYPE = "application/json; charset=UTF-8";
    protected static final String FORM_TYPE = "application/x-www-form-urlencoded; charset=UTF-8";
    protected static final char SEPARATOR = '/';
    protected static final String CONTENT_TYPE_HEADER = "Content-Type";
    protected String baseUrl;
    protected static RestClient instance;

    protected RestResponse<BaseModel> execute(HttpMethod method, String url, BaseModel requestEntity, Map<String, String> headers, Map<String, String> queryParams, Class responseEntityType, String contentType) {
        HttpURLConnection connection = null;
        try {
            Object content;
            URL fullUrl = new URL(this.buildUrl(url, queryParams));
            connection = (HttpURLConnection)fullUrl.openConnection();
            this.appendHeader(connection, headers, contentType);
            connection.setRequestMethod(method.getName());
            connection.setDoOutput(method.getHasRequestBody());
            connection.setDoInput(true);
            if (requestEntity != null) {
                switch (contentType) {
                    case "application/x-www-form-urlencoded; charset=UTF-8": {
                        content = requestEntity.toFormString();
                        break;
                    }
                    default: {
                        content = requestEntity.toJsonObject().toString();
                    }
                }
                BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());
                ((OutputStream)out).write(((String)content).getBytes());
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            }
            connection.connect();
            content = this.processResponse(connection, connection.getInputStream(), responseEntityType);
            return content;
        }
        catch (Exception e) {
            block18: {
                try {
                    if (connection == null || connection.getResponseCode() < 400) break block18;
                    RestResponse<BaseModel> content = this.processResponse(connection, connection.getErrorStream(), responseEntityType);
                    return content;
                }
                catch (Exception e1) {
                    throw new RuntimeException("DATA_COMMUNICATION_ERROR:" + e1.getMessage(), e1);
                }
            }
            throw new RuntimeException("DATA_COMMUNICATION_ERROR:" + e.getMessage(), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected String buildUrl(String url, Map<String, String> queryParams) {
        String resultUrl = url.startsWith("http") ? url : RestClient.combinePaths(this.baseUrl, url);
        String queryString = this.encodeParameters(queryParams);
        if (queryString != null && !queryString.isEmpty()) {
            resultUrl = resultUrl + "?" + queryString;
        }
        return resultUrl;
    }

    private void appendHeader(HttpURLConnection connection, Map<String, String> headers, String contentType) {
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        connection.setRequestProperty(CONTENT_TYPE_HEADER, contentType);
    }

    private RestResponse<BaseModel> processResponse(HttpURLConnection connection, InputStream resultStream, Class responseEntity) throws IOException {
        RestResponse<BaseModel> restResponse = new RestResponse<BaseModel>();
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            for (String value : entry.getValue()) {
                restResponse.putHeader(entry.getKey(), value);
            }
        }
        restResponse.setStatusCode(connection.getResponseCode());
        if (connection.getResponseCode() != 204) {
            int len;
            BufferedInputStream bis = new BufferedInputStream(resultStream);
            byte[] read = new byte[4096];
            String str = "";
            while ((len = bis.read(read)) != -1) {
                str = str + new String(read, 0, len);
            }
            restResponse.setRawData(str);
            if (restResponse.getStatusCode() / 100 == 2) {
                JSONObject object = null;
                try {
                    object = new JSONObject(str);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                if (object != null && responseEntity != null) {
                    restResponse.setEntity(BaseModel.fromJsonObject(responseEntity, object));
                }
            }
        }
        return restResponse;
    }

    protected String encodeParameters(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey()));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue()));
        }
        return result.toString();
    }

    protected void checkErrorAndThrow(RestResponse restResponse) {
        if (restResponse.getStatusCode() / 100 != 2) {
            String message;
            try {
                JSONObject jsonObject = new JSONObject(restResponse.getRawData());
                message = jsonObject.getString("message");
            }
            catch (JSONException e) {
                message = restResponse.getRawData();
            }
            throw new RuntimeException(message);
        }
    }

    protected static String combinePaths(String first, String ... paths) {
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        int len = first.length();
        char[] charArray = first.toCharArray();
        while (charArray[len - 1] == '/') {
            --len;
        }
        sb.append(first.toCharArray(), offset, len);
        for (int i = 0; i < paths.length; ++i) {
            offset = 0;
            len = paths[i].length();
            charArray = paths[i].toCharArray();
            while (charArray[offset] == '/') {
                ++offset;
                --len;
            }
            while (charArray[len - 1] == '/') {
                --len;
            }
            sb.append('/');
            sb.append(paths[i].toCharArray(), offset, len);
        }
        return sb.toString();
    }
}

