/*
 * Decompiled with CFR 0.152.
 */
package com.cm.androidforunity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.webkit.HttpAuthHandler;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.cm.androidforunity.PaymentActivity;
import com.cm.androidforunity.R;
import com.cm.androidforunity.SdkHttpListener;
import com.cm.androidforunity.SdkHttpTask;
import com.unity3d.player.UnityPlayer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.json.JSONException;
import org.json.JSONObject;

public class WebActivity
extends Activity {
    private String pollingUrl = "https://api.cloudmoolah.com/CMPayment/api/polling.ashx?";
    private WebView webview;
    private String url;
    private String authGlobal;
    private String transactionId;
    private String hashKey;
    private static final String PAY_FAILED = "PAY_FAILED";
    private static final String PAY_CONFIRM = "PAY_CONFIRM";
    private static final String ORDER_SUCCEED = "ORDER_SUCCEED";
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            WebActivity.this.polling();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.act_webview);
        this.init();
        this.setview();
        this.polling();
    }

    void polling() {
        SdkHttpTask task = new SdkHttpTask((Context)this);
        task.doGet(new SdkHttpListener(){

            @Override
            public void onResponse(String response) {
                if (response == null || response.isEmpty()) {
                    Toast.makeText((Context)WebActivity.this, (CharSequence)"Network Error", (int)1).show();
                    return;
                }
                try {
                    JSONObject result = new JSONObject(response);
                    int code = result.getInt("code");
                    if (code == 1) {
                        String values = result.getString("values");
                        JSONObject V = new JSONObject(values);
                        String state = V.getString("state");
                        if (state.equals(WebActivity.PAY_CONFIRM) || state.equals(WebActivity.PAY_FAILED) || state.equals(WebActivity.ORDER_SUCCEED)) {
                            Toast.makeText((Context)WebActivity.this, (CharSequence)"Polling Complete", (int)1).show();
                            PaymentActivity.sendMessage(response);
                        } else {
                            WebActivity.this.handler.sendEmptyMessageDelayed(1, 3000L);
                        }
                    } else {
                        WebActivity.this.handler.sendEmptyMessageDelayed(1, 3000L);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Toast.makeText((Context)WebActivity.this, (CharSequence)"Server Error", (int)1).show();
                }
            }

            @Override
            public void onCancelled() {
            }
        }, this.pollingUrl);
    }

    void init() {
        this.url = this.getIntent().getStringExtra("url");
        this.authGlobal = this.getIntent().getStringExtra("authGlobal");
        this.transactionId = this.getIntent().getStringExtra("transactionId");
        this.hashKey = this.getIntent().getStringExtra("hashKey");
        this.pollingUrl = this.pollingUrl + "authCode=" + this.authGlobal + "&orderSuccess=0" + "&tradeSeq=" + this.transactionId + "&sign=" + this.md5(this.authGlobal + 0 + this.transactionId + this.hashKey);
        Log.d((String)"CloudMoolah pollingUrl: ", (String)this.pollingUrl);
        this.webview = (WebView)this.findViewById(R.id.webview);
        this.webview.setScrollBarStyle(0);
    }

    void setview() {
        WebSettings webSettings = this.webview.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setAllowFileAccess(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setDefaultTextEncodingName("gb2312");
        webSettings.supportMultipleWindows();
        this.webview.loadUrl(this.url);
        this.webview.addJavascriptInterface((Object)new PayJavaScriptInterface(), "js");
        this.webview.requestFocus();
        this.webview.setWebViewClient(new WebViewClient(){

            public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)WebActivity.this);
                builder.setMessage((CharSequence)"This page has an invalid security certificate, please be careful.");
                builder.setPositiveButton((CharSequence)"continue", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        handler.proceed();
                    }
                });
                builder.setNegativeButton((CharSequence)"cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        handler.cancel();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.show();
            }

            public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
                return super.shouldOverrideKeyEvent(view, event);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                String summary = "<html><body>Could not connect. Please check your network connection and retry.</body></html>";
                WebActivity.this.webview.loadData(summary, "text/html", null);
                Log.i((String)"CloudMoolah.WebActivity", (String)("errorCode:" + errorCode + ",description:" + description + " , failingUrl" + failingUrl));
            }

            public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
                super.onReceivedHttpAuthRequest(view, handler, host, realm);
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                Log.i((String)"CloudMoolah.WebActivity", (String)("onPageStarted: " + url));
                super.onPageStarted(view, url, favicon);
            }

            public void onPageFinished(WebView view, String url) {
                Log.i((String)"CloudMoolah.WebActivity", (String)("onPageFinished : " + url));
                super.onPageFinished(view, url);
            }
        });
        this.webview.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
            }
        });
    }

    String md5(String data) {
        byte[] bytes = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data.getBytes());
            bytes = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (bytes == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            if ((b & 0xFF) < 16) {
                builder.append("0");
            }
            builder.append(Integer.toHexString(b & 0xFF));
        }
        return builder.toString();
    }

    protected void onDestroy() {
        this.handler.removeMessages(1);
        UnityPlayer.UnitySendMessage((String)"IAPUtil", (String)"ClosePayWebView", (String)"finish");
        super.onDestroy();
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    private class PayJavaScriptInterface {
        private PayJavaScriptInterface() {
        }

        @JavascriptInterface
        public void closeActivity() {
            WebActivity.this.finish();
        }
    }
}

