/*
 * Decompiled with CFR 0.152.
 */
package com.unity.purchasing.googleplay;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Base64;
import android.util.Log;
import com.android.vending.billing.IInAppBillingService;
import com.google.vr.ndk.base.DaydreamApi;
import com.unity.purchasing.common.IStoreCallback;
import com.unity.purchasing.common.IUnityCallback;
import com.unity.purchasing.common.InitializationFailureReason;
import com.unity.purchasing.common.ProductDefinition;
import com.unity.purchasing.common.ProductDescription;
import com.unity.purchasing.common.ProductMetadata;
import com.unity.purchasing.common.ProductType;
import com.unity.purchasing.common.PurchaseFailureDescription;
import com.unity.purchasing.common.PurchaseFailureReason;
import com.unity.purchasing.common.StoreDeserializer;
import com.unity.purchasing.common.UnityPurchasing;
import com.unity.purchasing.googleplay.ActivityLauncher;
import com.unity.purchasing.googleplay.BillingServiceManager;
import com.unity.purchasing.googleplay.BillingServiceProcessor;
import com.unity.purchasing.googleplay.GooglePlayBillingUnAvailableException;
import com.unity.purchasing.googleplay.IActivityLauncher;
import com.unity.purchasing.googleplay.IBillingServiceManager;
import com.unity.purchasing.googleplay.IGooglePlayStoreCallback;
import com.unity.purchasing.googleplay.IabHelper;
import com.unity.purchasing.googleplay.IabResult;
import com.unity.purchasing.googleplay.Inventory;
import com.unity.purchasing.googleplay.Purchase;
import com.unity.purchasing.googleplay.PurchaseActivity;
import com.unity.purchasing.googleplay.SkuDetails;
import com.unity.purchasing.googleplay.VRPurchaseActivity;
import com.unity3d.player.UnityPlayer;
import com.unity3d.player.UnityPlayerActivity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class GooglePlayPurchasing
extends StoreDeserializer {
    protected static final String TAG = "UnityIAP";
    public static final int ACTIVITY_REQUEST_CODE = 999;
    public IabHelper helper;
    public boolean activityPending;
    private Inventory inventory;
    private ProductDefinition productUnderPurchase;
    private HashSet<String> suspectFailedConsumableSkus = new HashSet();
    public String productJSON;
    public Class<? extends Activity> aVRPurchaseActivity = VRPurchaseActivity.class;
    public Class<? extends Activity> aPurchaseActivity = PurchaseActivity.class;
    private static final boolean isDaydreamApiAvailable;
    private boolean isUnityVrEnabled;
    Features features = new Features();
    private static GooglePlayPurchasing instance;
    private IStoreCallback unityPurchasing;
    private IBillingServiceManager manager;
    private Context context;
    private IActivityLauncher launcher;
    public IabHelper.OnIabPurchaseFinishedListener PurchaseListener = new IabHelper.OnIabPurchaseFinishedListener(){

        @Override
        public void onIabPurchaseFinished(IabResult result, Purchase info) {
            if (!GooglePlayPurchasing.this.purchaseInProgress) {
                return;
            }
            GooglePlayPurchasing.log("onIabPurchaseFinished: %s", Boolean.toString(result.isSuccess()));
            GooglePlayPurchasing.log(result.mMessage);
            GooglePlayPurchasing.this.purchaseInProgress = false;
            if (result.isSuccess()) {
                GooglePlayPurchasing.log("Product purchased successfully!");
                GooglePlayPurchasing.this.NotifyUnityOfPurchase(info);
            } else {
                int responseCode = result.getResponse();
                GooglePlayPurchasing.log("Purchase response code:%s", Integer.toString(responseCode));
                PurchaseFailureReason reason = PurchaseFailureReason.Unknown;
                GooglePlayPurchasing.this.suspectFailedConsumableSkus.add(((GooglePlayPurchasing)GooglePlayPurchasing.this).productUnderPurchase.storeSpecificId);
                switch (responseCode) {
                    case -1005: 
                    case 1: {
                        reason = PurchaseFailureReason.UserCancelled;
                        break;
                    }
                    case 4: {
                        reason = PurchaseFailureReason.ItemUnavailable;
                        break;
                    }
                    case 2: 
                    case 3: {
                        reason = PurchaseFailureReason.BillingUnavailable;
                        break;
                    }
                    case 7: {
                        if (!GooglePlayPurchasing.this.features.supportsPurchaseFailureReasonDuplicateTransaction) break;
                        reason = PurchaseFailureReason.DuplicateTransaction;
                    }
                }
                PurchaseFailureDescription description = new PurchaseFailureDescription(((GooglePlayPurchasing)GooglePlayPurchasing.this).productUnderPurchase.storeSpecificId, reason, "GOOGLEPLAY_" + result.mMessage, IabHelper.billingResponseCodeNames.get(responseCode));
                if (result.getResponse() == -1002) {
                    GooglePlayPurchasing.log("Received bad response, polling for successful purchases to investigate failure more deeply");
                    GooglePlayPurchasing.this.reconcileFailedPurchaseWithInventory(description);
                } else {
                    GooglePlayPurchasing.this.unityPurchasing.OnPurchaseFailed(description);
                }
            }
        }
    };
    private BroadcastReceiver purchasesUpdatedReceiver = null;
    private int offlineBackOffTime = 5000;
    private volatile boolean purchaseInProgress = false;
    private volatile boolean subscriptionUpdateInProgress = false;

    public static GooglePlayPurchasing instance(IUnityCallback bridge) {
        if (instance == null) {
            BillingServiceManager serviceManager = new BillingServiceManager((Context)UnityPlayer.currentActivity);
            instance = new GooglePlayPurchasing((IStoreCallback)new UnityPurchasing(bridge), new IabHelper((Context)UnityPlayer.currentActivity, serviceManager, new ActivityLauncher()), serviceManager, (Context)UnityPlayer.currentActivity, new ActivityLauncher(), PurchaseActivity.class, VRPurchaseActivity.class);
        }
        return instance;
    }

    public static boolean ContinuePurchase(Activity activity, String productID, String developerPayload) {
        if (instance != null) {
            instance.StartPurchase(activity, productID, developerPayload);
            return true;
        }
        return false;
    }

    public static boolean ContinueSubscriptionUpdate(Activity activity, String oldSkuMetadata, String newSku) {
        if (instance != null) {
            instance.StartSubscriptionUpdate(activity, oldSkuMetadata, newSku);
            return true;
        }
        return false;
    }

    public static void ProcessActivityResult(int requestCode, int resultCode, Intent data) {
        if (instance != null) {
            instance.onActivityResult(requestCode, resultCode, data);
        }
    }

    public GooglePlayPurchasing(IStoreCallback callback, IabHelper helper, IBillingServiceManager manager, Context context, IActivityLauncher launcher, Class<? extends Activity> purchaseActivityClass, Class<? extends Activity> vrPurchaseActivityClass) {
        this.unityPurchasing = callback;
        this.helper = helper;
        this.helper.enableDaydreamApi(isDaydreamApiAvailable);
        this.manager = manager;
        this.context = context;
        this.launcher = launcher;
        this.aPurchaseActivity = purchaseActivityClass;
        this.aVRPurchaseActivity = vrPurchaseActivityClass;
        instance = this;
        this.registerPurchasesUpdatedReceiver();
    }

    public void SetUnityVrEnabled(boolean vrEnabled) {
        this.isUnityVrEnabled = vrEnabled;
        GooglePlayPurchasing.log("isUnityVrEnabled = %s", String.valueOf(this.isUnityVrEnabled));
    }

    public void RestoreTransactions(final IGooglePlayStoreCallback callback) {
        IabHelper.QueryInventoryFinishedListener listener = new IabHelper.QueryInventoryFinishedListener(){

            @Override
            public void onQueryInventoryFinished(IabResult result, Inventory inv) throws Exception {
                GooglePlayPurchasing.log("RestoreInventoryFinished: %s", Boolean.toString(result.isSuccess()));
                GooglePlayPurchasing.log(result.mMessage);
                if (result.isFailure()) {
                    GooglePlayPurchasing.log("Failed to Restore inventory. UnityIAP will automatically retry in " + GooglePlayPurchasing.this.offlineBackOffTime + "ms");
                    callback.OnTransactionsRestored(false);
                    return;
                }
                GooglePlayPurchasing.this.inventory = inv;
                GooglePlayPurchasing.this.NotifyUnityOfProducts(inv);
                callback.OnTransactionsRestored(true);
            }
        };
        this.helper.queryInventoryAsync(true, new ArrayList<String>(), listener, 0L);
    }

    public void UpgradeDowngradeSubscription(String oldSkuMetadata, String newSku) {
        if (this.subscriptionUpdateInProgress) {
            GooglePlayPurchasing.log("Subscription update is in progress");
            return;
        }
        if (!this.helper.subscriptionUpgradeDowngradeSupported()) {
            GooglePlayPurchasing.log("UpgradeDowngradeSubscription is not supported, this service needs v5 and higher android in app billing api");
            return;
        }
        if (oldSkuMetadata == null || oldSkuMetadata.length() == 0 || newSku == null || newSku.length() == 0) {
            GooglePlayPurchasing.log("Cannot update subscription. Subscription product identifiers(SKUs) must not be empty");
            return;
        }
        boolean useVRIntent = this.context instanceof UnityPlayerActivity && this.isUnityVrEnabled && isDaydreamApiAvailable;
        final Intent subscriptionUpdateIntent = this.createPurchaseIntent(useVRIntent);
        subscriptionUpdateIntent.putExtra("oldSkuMetadata", oldSkuMetadata);
        subscriptionUpdateIntent.putExtra("newSku", newSku);
        subscriptionUpdateIntent.putExtra("type", "subscription_update");
        this.subscriptionUpdateInProgress = true;
        this.purchaseInProgress = true;
        this.activityPending = true;
        if (useVRIntent) {
            new Handler(this.context.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    subscriptionUpdateIntent.putExtra("vr", true);
                    DaydreamApi api = DaydreamApi.create((Context)GooglePlayPurchasing.this.context);
                    api.launchInVr(subscriptionUpdateIntent);
                    api.close();
                }
            });
        } else {
            this.launcher.startActivity(this.context, subscriptionUpdateIntent);
        }
    }

    public void StartSubscriptionUpdate(Activity activity, String oldSkuMetadata, String newSku) {
        String oldSku = null;
        try {
            JSONObject metadata = new JSONObject(oldSkuMetadata);
            oldSku = metadata.has("productId") ? metadata.getString("productId") : null;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (oldSku == null) {
            GooglePlayPurchasing.log("Error: the product that is going to be updated does not have a valid product id");
            return;
        }
        if (!this.inventory.hasDetails(oldSku)) {
            GooglePlayPurchasing.log("Error: the product that is going to be updated is not in the current inventory");
            return;
        }
        if (!this.inventory.hasPurchase(oldSku)) {
            GooglePlayPurchasing.log("Error: the product that is going to be updated has not been purchased yet.");
            return;
        }
        if (!this.inventory.hasDetails(newSku)) {
            GooglePlayPurchasing.log("Error: the product that is going to be updated to is not in the current inventory");
            return;
        }
        this.productUnderPurchase = new ProductDefinition(newSku, newSku, ProductType.Subscription);
        ArrayList<String> oldSkus = new ArrayList<String>();
        oldSkus.add(oldSku);
        String developerPayload = this.addFreeTrialAndIntroPriceFlagToDeveloperPayload(null, newSku, oldSkuMetadata);
        this.helper.launchSubscriptionUpdateFlow(activity, newSku, oldSkus, 999, this.PurchaseListener, developerPayload);
    }

    public void StartPurchase(Activity activity, String productId, String developerPayload) {
        this.helper.enableUnityVr(this.isUnityVrEnabled);
        developerPayload = this.addFreeTrialAndIntroPriceFlagToDeveloperPayload(developerPayload, productId, null);
        if (this.inventory.getSkuDetails((String)productId).mItemType == "inapp") {
            this.helper.launchPurchaseFlow(activity, productId, 999, this.PurchaseListener, developerPayload);
        } else {
            this.helper.launchSubscriptionPurchaseFlow(activity, productId, 999, this.PurchaseListener, developerPayload);
        }
    }

    private String addFreeTrialAndIntroPriceFlagToDeveloperPayload(String developerPayload, String newSku, String oldSkuMetadata) {
        SkuDetails newSkuDetails = this.inventory.hasDetails(newSku) ? this.inventory.getSkuDetails(newSku) : null;
        JSONObject json = new JSONObject();
        String accountId = new String();
        if (developerPayload == null) {
            developerPayload = "";
        } else {
            try {
                JSONObject payload = new JSONObject(developerPayload);
                accountId = payload.getString("accountId");
            }
            catch (JSONException payload) {
                // empty catch block
            }
        }
        String developerPayloadBase64 = Base64.encodeToString((byte[])developerPayload.getBytes(), (int)0);
        if (newSkuDetails == null) {
            try {
                json.put("developerPayload", (Object)developerPayloadBase64);
                json.put("is_free_trial", false);
                json.put("has_introductory_price_trial", false);
                json.put("is_updated", false);
                json.put("update_subscription_metadata", null);
                json.put("accountId", (Object)accountId);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return json.toString();
        }
        boolean is_updated = false;
        String updateMetadata = null;
        if (oldSkuMetadata != null) {
            GooglePlayPurchasing.log("oldSkuMetadata is NOT null");
            is_updated = true;
            updateMetadata = this.getUpdateMetadata(oldSkuMetadata, newSkuDetails);
        } else {
            GooglePlayPurchasing.log("oldSkuMetadata is null");
        }
        boolean has_used_free_trial = false;
        String type = newSkuDetails.getType();
        String introductory_price_period = newSkuDetails.getIntroductoryPricePeriod();
        String free_trial_period = newSkuDetails.getFreeTrialPeriod();
        boolean has_purchase_history = this.inventory.hasPurchaseHistory(newSku);
        for (String sku : this.inventory.getAllSkus("subs")) {
            if (this.inventory.getSkuDetails(sku).getFreeTrialPeriod().isEmpty() || !this.inventory.hasPurchaseHistory(sku)) continue;
            has_used_free_trial = true;
            break;
        }
        boolean is_free_trial = true;
        boolean has_introductory_price_trial = true;
        if (type.equals("inapp") || free_trial_period.isEmpty() || has_purchase_history || has_used_free_trial) {
            is_free_trial = false;
        }
        if (type.equals("inapp") || introductory_price_period.isEmpty() || has_purchase_history) {
            has_introductory_price_trial = false;
        }
        try {
            json.put("developerPayload", (Object)developerPayloadBase64);
            json.put("is_free_trial", is_free_trial);
            json.put("has_introductory_price_trial", has_introductory_price_trial);
            json.put("is_updated", is_updated);
            json.put("update_subscription_metadata", (Object)updateMetadata);
            json.put("accountId", (Object)accountId);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json.toString();
    }

    private String getUpdateMetadata(String oldSkuMetadata, SkuDetails newSkuDetails) {
        String old_sku_product_id = null;
        boolean old_sku_is_free_trial = false;
        boolean old_sku_is_introductory_price = false;
        long old_sku_price_in_micros = 0L;
        long new_sku_price_in_micros = newSkuDetails.getPriceInMicros();
        long old_sku_remaining_seconds = 0L;
        String old_sku_period_string = null;
        try {
            JSONObject metadata = new JSONObject(oldSkuMetadata);
            old_sku_product_id = metadata.getString("productId");
            old_sku_is_free_trial = metadata.getBoolean("is_free_trial");
            old_sku_is_introductory_price = metadata.getBoolean("is_introductory_price_period");
            old_sku_remaining_seconds = (long)metadata.getDouble("remaining_time_in_seconds");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (old_sku_product_id == null || !this.inventory.hasDetails(old_sku_product_id)) {
            return null;
        }
        SkuDetails oldSkuDetails = this.inventory.getSkuDetails(old_sku_product_id);
        if (old_sku_is_free_trial) {
            old_sku_remaining_seconds = 0L;
        }
        if (old_sku_is_introductory_price && newSkuDetails.getPriceInMicros() != 0L) {
            old_sku_price_in_micros = oldSkuDetails.getIntroductoryPriceInMicros();
            old_sku_period_string = oldSkuDetails.getIntroductoryPricePeriod();
        } else {
            old_sku_price_in_micros = oldSkuDetails.getPriceInMicros();
            old_sku_period_string = oldSkuDetails.getSubscriptionPeriod();
        }
        JSONObject json = new JSONObject();
        try {
            json.put("old_sku_remaining_seconds", old_sku_remaining_seconds);
            json.put("old_sku_price_in_micros", old_sku_price_in_micros);
            json.put("old_sku_period_string", (Object)old_sku_period_string);
            json.put("new_sku_price_in_micros", new_sku_price_in_micros);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString();
    }

    private void pollForNewPurchases() {
        this.reconcileFailedPurchaseWithInventory(null);
    }

    private void reconcileFailedPurchaseWithInventory(final PurchaseFailureDescription suspectBadPurchase) {
        this.manager.workWith(new BillingServiceProcessor(){

            @Override
            public void workWith(IInAppBillingService service) {
                block8: {
                    boolean notified = false;
                    try {
                        boolean hasPurchase;
                        boolean hadPurchase = suspectBadPurchase != null ? GooglePlayPurchasing.this.inventory.hasPurchase(suspectBadPurchase.productId) : false;
                        int response = GooglePlayPurchasing.this.helper.queryPurchases(GooglePlayPurchasing.this.inventory, "inapp", service);
                        if (response != 0) {
                            GooglePlayPurchasing.log("Received bad response from queryPurchases");
                        }
                        boolean bl = hasPurchase = suspectBadPurchase != null ? GooglePlayPurchasing.this.inventory.hasPurchase(suspectBadPurchase.productId) : false;
                        if (suspectBadPurchase != null) {
                            if (!hadPurchase && !hasPurchase || hadPurchase && hasPurchase) {
                                GooglePlayPurchasing.this.unityPurchasing.OnPurchaseFailed(suspectBadPurchase);
                                notified = true;
                            } else if (!hadPurchase && hasPurchase) {
                                Purchase purchase = GooglePlayPurchasing.this.inventory.getPurchase(suspectBadPurchase.productId);
                                SkuDetails skuDetails = GooglePlayPurchasing.this.inventory.getSkuDetails(suspectBadPurchase.productId);
                                GooglePlayPurchasing.this.unityPurchasing.OnPurchaseSucceeded(purchase.getSku(), GooglePlayPurchasing.this.encodeReceipt(purchase, skuDetails), purchase.getOrderIdOrPurchaseToken());
                                notified = true;
                            }
                        }
                        if (!notified) {
                            GooglePlayPurchasing.this.NotifyUnityOfProducts(GooglePlayPurchasing.this.inventory);
                        }
                    }
                    catch (RemoteException | JSONException e) {
                        Log.e((String)GooglePlayPurchasing.TAG, (String)"exception", (Throwable)e);
                        if (suspectBadPurchase == null || notified) break block8;
                        GooglePlayPurchasing.this.unityPurchasing.OnPurchaseFailed(suspectBadPurchase);
                    }
                }
            }
        });
    }

    private void registerPurchasesUpdatedReceiver() {
        if (null == this.purchasesUpdatedReceiver) {
            this.purchasesUpdatedReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    GooglePlayPurchasing.this.pollForNewPurchases();
                }
            };
            this.context.registerReceiver(this.purchasesUpdatedReceiver, new IntentFilter("com.android.vending.billing.PURCHASES_UPDATED"));
        }
    }

    private void QueryInventory(final List<String> skus, long delay) {
        GooglePlayPurchasing.log("QueryInventory: %s", Integer.toString(skus.size()));
        IabHelper.QueryInventoryFinishedListener listener = new IabHelper.QueryInventoryFinishedListener(){

            @Override
            public void onQueryInventoryFinished(IabResult result, Inventory inv) throws Exception {
                GooglePlayPurchasing.log("onQueryInventoryFinished: %s", Boolean.toString(result.isSuccess()));
                GooglePlayPurchasing.log(result.mMessage);
                if (result.isFailure()) {
                    if (result.getResponse() == 6) {
                        GooglePlayPurchasing.log("Retrieved fatal API response code: " + result.getMessage() + " . Initiating failed setup callback. Check your google account.");
                        GooglePlayPurchasing.this.unityPurchasing.OnSetupFailed(InitializationFailureReason.AppNotKnown);
                    } else {
                        GooglePlayPurchasing.log("Failed to Query inventory. UnityIAP will automatically retry in " + GooglePlayPurchasing.this.offlineBackOffTime + "ms");
                        GooglePlayPurchasing.this.QueryInventory(skus, GooglePlayPurchasing.this.offlineBackOffTime);
                        GooglePlayPurchasing.this.offlineBackOffTime = Math.min(300000, GooglePlayPurchasing.this.offlineBackOffTime * 2);
                    }
                    return;
                }
                GooglePlayPurchasing.this.inventory = inv;
                for (String sku : skus) {
                    if (!GooglePlayPurchasing.this.inventory.hasConsumablePurchaseHistory(sku) || GooglePlayPurchasing.this.inventory.hasPurchase(sku)) continue;
                    Purchase purchase = GooglePlayPurchasing.this.inventory.getHistoryPurchase(sku);
                    GooglePlayPurchasing.this.helper.consumeAsync(purchase, null, true);
                }
                GooglePlayPurchasing.this.NotifyUnityOfProducts(inv);
            }
        };
        this.helper.queryInventoryAsync(true, skus, listener, delay);
    }

    private void NotifyUnityOfProducts(Inventory inv) {
        ArrayList<ProductDescription> products = new ArrayList<ProductDescription>();
        JSONObject products_json = new JSONObject();
        for (Map.Entry<String, SkuDetails> entry : inv.mSkuMap.entrySet()) {
            SkuDetails details = entry.getValue();
            try {
                products_json.put(entry.getKey(), (Object)details.getOriginalJSON());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            BigDecimal b = new BigDecimal(details.getPriceInMicros()).divide(new BigDecimal(1000000));
            ProductMetadata metadata = new ProductMetadata(details.getPrice(), details.getTitle(), details.getDescription(), details.getISOCurrencyCode(), b);
            String receipt = null;
            String transactionId = null;
            String key = entry.getKey();
            if (inv.hasPurchase(key)) {
                Purchase purchase = inv.getPurchase(key);
                SkuDetails skuDetails = inv.getSkuDetails(key);
                receipt = this.encodeReceipt(purchase, skuDetails);
                transactionId = purchase.getOrderIdOrPurchaseToken();
            }
            ProductDescription description = new ProductDescription(key, metadata, receipt, transactionId);
            products.add(description);
        }
        this.productJSON = products_json.toString();
        this.unityPurchasing.OnProductsRetrieved(products);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (null != this.helper) {
            GooglePlayPurchasing.log("onActivityResult");
            this.helper.handleActivityResult(requestCode, resultCode, data);
            this.purchaseInProgress = false;
            this.subscriptionUpdateInProgress = false;
        }
    }

    private Purchase findPurchaseByOrderId(String orderId) {
        for (Purchase p : this.inventory.getAllPurchases()) {
            if (!p.getOrderIdOrPurchaseToken().equals(orderId)) continue;
            return p;
        }
        GooglePlayPurchasing.log("No consumable with order %s", orderId);
        return null;
    }

    private void NotifyUnityOfPurchase(Purchase purchase) {
        GooglePlayPurchasing.log("NotifyUnityOfPurchase");
        this.inventory.addPurchase(purchase);
        SkuDetails skuDetails = this.inventory.getSkuDetails(purchase.getSku());
        if (purchase.getItemType().equals("subs")) {
            this.inventory.addPurchaseToSubscriptionPurchaseHistory(purchase.getSku());
        }
        this.unityPurchasing.OnPurchaseSucceeded(purchase.getSku(), this.encodeReceipt(purchase, skuDetails), purchase.getOrderIdOrPurchaseToken());
    }

    private String encodeReceipt(Purchase purchase, SkuDetails skuDetails) {
        JSONObject signature = new JSONObject();
        try {
            signature.put("json", (Object)purchase.getOriginalJson());
            signature.put("signature", (Object)purchase.getSignature());
            signature.put("skuDetails", (Object)skuDetails.getOriginalJSON());
            signature.put("isPurchaseHistorySupported", this.helper.subscriptionPurchaseHistorySupported());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return signature.toString();
    }

    private static void log(String message) {
        Log.i((String)TAG, (String)message);
    }

    private static void log(String message, String arg) {
        GooglePlayPurchasing.log(String.format(message, arg));
    }

    public void RetrieveProducts(List<ProductDefinition> products) {
        final ArrayList<String> skus = new ArrayList<String>();
        for (ProductDefinition product : products) {
            skus.add(product.storeSpecificId);
        }
        IabHelper.OnIabSetupFinishedListener listener = new IabHelper.OnIabSetupFinishedListener(){

            @Override
            public void onIabSetupFinished(IabResult result) {
                GooglePlayPurchasing.log("onIabSetupFinished: %s", Integer.toString(result.mResponse));
                if (result.isFailure()) {
                    GooglePlayPurchasing.log("Failed to setup IAB. Notifying Unity...");
                    GooglePlayPurchasing.this.unityPurchasing.OnSetupFailed(InitializationFailureReason.PurchasingUnavailable);
                    return;
                }
                GooglePlayPurchasing.log("Requesting %s products", Integer.toString(skus.size()));
                GooglePlayPurchasing.this.QueryInventory(skus, 0L);
            }
        };
        if (!this.helper.mSetupDone) {
            try {
                this.manager.initialise();
                this.helper.startSetup(listener);
            }
            catch (GooglePlayBillingUnAvailableException g) {
                this.unityPurchasing.OnSetupFailed(InitializationFailureReason.PurchasingUnavailable);
            }
        } else {
            GooglePlayPurchasing.log("Requesting %s products", Integer.toString(skus.size()));
            this.QueryInventory(skus, 0L);
        }
    }

    private void consumeSuspectFailedPurchase(ProductDefinition product, String developerPayload) {
        final String sku = product.storeSpecificId;
        final ProductDefinition p = product;
        final String payload = developerPayload;
        this.suspectFailedConsumableSkus.remove(sku);
        IabHelper.QueryInventoryFinishedListener listener = new IabHelper.QueryInventoryFinishedListener(){

            @Override
            public void onQueryInventoryFinished(IabResult result, Inventory inv) throws Exception {
                if (result.isFailure()) {
                    if (result.getResponse() == 6) {
                        GooglePlayPurchasing.log("Retrieved fatal API response code: " + result.getMessage() + " .Initiating failed setup callback. Check your google account.");
                        GooglePlayPurchasing.this.unityPurchasing.OnSetupFailed(InitializationFailureReason.AppNotKnown);
                    } else {
                        GooglePlayPurchasing.log("Failed to Query inventory. UnityIAP will automatically retry in " + GooglePlayPurchasing.this.offlineBackOffTime + "ms");
                        GooglePlayPurchasing.this.QueryInventory(GooglePlayPurchasing.this.inventory.getAllSkus("inapp"), GooglePlayPurchasing.this.offlineBackOffTime);
                        GooglePlayPurchasing.this.offlineBackOffTime = Math.min(300000, GooglePlayPurchasing.this.offlineBackOffTime * 2);
                    }
                    return;
                }
                GooglePlayPurchasing.this.inventory = inv;
                if (GooglePlayPurchasing.this.inventory.hasConsumablePurchaseHistory(sku)) {
                    Purchase purchase = GooglePlayPurchasing.this.inventory.getHistoryPurchase(sku);
                    GooglePlayPurchasing.this.helper.consumeAsync(purchase, new IabHelper.OnConsumeFinishedListener(){

                        @Override
                        public void onConsumeFinished(Purchase purchase, IabResult result) throws JSONException {
                            GooglePlayPurchasing.this.Purchase(p, payload);
                        }
                    }, true);
                } else {
                    GooglePlayPurchasing.this.Purchase(p, payload);
                }
            }
        };
        this.helper.queryInventoryAsync(false, this.inventory.getAllSkus("inapp"), listener, 0L);
    }

    public void Purchase(ProductDefinition product) {
        this.Purchase(product, null);
    }

    public void Purchase(ProductDefinition product, String developerPayload) {
        if (this.purchaseInProgress) {
            PurchaseFailureDescription description = new PurchaseFailureDescription(product.storeSpecificId, PurchaseFailureReason.ExistingPurchasePending);
            this.unityPurchasing.OnPurchaseFailed(description);
            return;
        }
        String productId = product.storeSpecificId;
        this.productUnderPurchase = product;
        GooglePlayPurchasing.log("onPurchaseProduct: %s", productId);
        SkuDetails details = this.inventory.getSkuDetails(productId);
        GooglePlayPurchasing.log("ITEM TYPE:%s", details.getType());
        boolean useVRIntent = this.context instanceof UnityPlayerActivity && this.isUnityVrEnabled && isDaydreamApiAvailable;
        final Intent purchaseIntent = this.createPurchaseIntent(useVRIntent);
        purchaseIntent.putExtra("productId", productId);
        purchaseIntent.putExtra("itemType", details.getType());
        purchaseIntent.putExtra("developerPayload", developerPayload);
        this.purchaseInProgress = true;
        this.activityPending = true;
        if (useVRIntent) {
            new Handler(this.context.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    purchaseIntent.putExtra("vr", true);
                    DaydreamApi api = DaydreamApi.create((Context)GooglePlayPurchasing.this.context);
                    api.launchInVr(purchaseIntent);
                    api.close();
                }
            });
        } else {
            this.launcher.startActivity(this.context, purchaseIntent);
        }
    }

    protected Intent createPurchaseIntent(boolean useVRIntent) {
        Class<? extends Activity> clazz = useVRIntent ? this.aVRPurchaseActivity : this.aPurchaseActivity;
        return new Intent(this.context, clazz);
    }

    public void FinishTransaction(ProductDefinition product, String transactionId) {
        Purchase purchase;
        GooglePlayPurchasing.log("Finish transaction:%s", transactionId);
        if (null == product) {
            GooglePlayPurchasing.log("Received FinishTransaction for unknown product with transaction %s. Not consuming.", transactionId);
            return;
        }
        if (product.type == ProductType.Consumable && null != (purchase = this.findPurchaseByOrderId(transactionId))) {
            GooglePlayPurchasing.log("Consuming %s", purchase.getSku());
            this.inventory.erasePurchase(purchase.getSku());
            this.helper.consumeAsync(purchase, new IabHelper.OnConsumeFinishedListener(){

                @Override
                public void onConsumeFinished(Purchase purchase, IabResult result) throws JSONException {
                    GooglePlayPurchasing.log("onConsumeFinished:%s", Boolean.toString(result.isSuccess()));
                    GooglePlayPurchasing.log(result.mMessage);
                    GooglePlayPurchasing.log(String.valueOf(result.getResponse()));
                }
            }, false);
        }
    }

    public void FinishAdditionalTransaction(String product, String transactionId) {
        GooglePlayPurchasing.log("Finish transaction:%s", transactionId);
        Purchase purchase = this.findPurchaseByOrderId(transactionId);
        if (null != purchase) {
            GooglePlayPurchasing.log("Consuming %s", purchase.getSku());
            this.inventory.erasePurchase(purchase.getSku());
            this.helper.consumeAsync(purchase, new IabHelper.OnConsumeFinishedListener(){

                @Override
                public void onConsumeFinished(Purchase purchase, IabResult result) throws JSONException {
                    GooglePlayPurchasing.log("onConsumeFinished:%s", Boolean.toString(result.isSuccess()));
                    GooglePlayPurchasing.log(result.mMessage);
                    GooglePlayPurchasing.log(String.valueOf(result.getResponse()));
                }
            }, false);
        }
    }

    public void SetFeatures(String featuresCSV) {
        String[] parts;
        for (String part : parts = featuresCSV.split(",")) {
            if (!part.equals("supportsPurchaseFailureReasonDuplicateTransaction")) continue;
            this.features.supportsPurchaseFailureReasonDuplicateTransaction = true;
        }
    }

    static {
        boolean result = true;
        try {
            Class.forName("com.google.vr.ndk.base.DaydreamApi");
        }
        catch (Throwable e) {
            result = false;
        }
        isDaydreamApiAvailable = result;
    }

    class Features {
        public boolean supportsPurchaseFailureReasonDuplicateTransaction;

        Features() {
        }
    }
}

