/*
 * Decompiled with CFR 0.152.
 */
package com.unity.purchasing.googleplay;

import com.unity.purchasing.googleplay.Purchase;
import com.unity.purchasing.googleplay.SkuDetails;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Inventory {
    public Map<String, SkuDetails> mSkuMap = new HashMap<String, SkuDetails>();
    Map<String, Purchase> mPurchaseMap = new HashMap<String, Purchase>();
    Map<String, Purchase> mConsumablePurchaseHistoryMap = new HashMap<String, Purchase>();
    Set<String> mPurchaseHistoryOfSub = new HashSet<String>();

    Inventory() {
    }

    public boolean hasPurchaseHistory(String productId) {
        return this.mPurchaseHistoryOfSub.contains(productId);
    }

    public List<String> getSubscriptionsWithHistory() {
        return new ArrayList<String>(this.mPurchaseHistoryOfSub);
    }

    public SkuDetails getSkuDetails(String sku) {
        return this.mSkuMap.get(sku);
    }

    public Purchase getPurchase(String sku) {
        return this.mPurchaseMap.get(sku);
    }

    public Purchase getHistoryPurchase(String sku) {
        return this.mConsumablePurchaseHistoryMap.get(sku);
    }

    public boolean hasPurchase(String sku) {
        return this.mPurchaseMap.containsKey(sku);
    }

    public boolean hasConsumablePurchaseHistory(String sku) {
        return this.mConsumablePurchaseHistoryMap.containsKey(sku);
    }

    public boolean hasDetails(String sku) {
        return this.mSkuMap.containsKey(sku);
    }

    public void erasePurchase(String sku) {
        if (this.mPurchaseMap.containsKey(sku)) {
            this.mPurchaseMap.remove(sku);
        }
    }

    List<String> getAllOwnedSkus() {
        return new ArrayList<String>(this.mPurchaseMap.keySet());
    }

    List<String> getAllSkus(String itemType) {
        ArrayList<String> result = new ArrayList<String>();
        for (SkuDetails sku : this.mSkuMap.values()) {
            if (!sku.getType().equals(itemType)) continue;
            result.add(sku.getSku());
        }
        return result;
    }

    List<String> getAllOwnedSkus(String itemType) {
        ArrayList<String> result = new ArrayList<String>();
        for (Purchase p : this.mPurchaseMap.values()) {
            if (!p.getItemType().equals(itemType)) continue;
            result.add(p.getSku());
        }
        return result;
    }

    List<Purchase> getAllPurchases() {
        return new ArrayList<Purchase>(this.mPurchaseMap.values());
    }

    void addSkuDetails(SkuDetails d) {
        this.mSkuMap.put(d.getSku(), d);
    }

    void addPurchase(Purchase p) {
        this.mPurchaseMap.put(p.getSku(), p);
    }

    void addPurchaseToSubscriptionPurchaseHistory(String sku) {
        this.mPurchaseHistoryOfSub.add(sku);
    }

    void addPurchaseToConsumablePurchaseHistory(String sku, Purchase p) {
        this.mConsumablePurchaseHistoryMap.put(sku, p);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("skuDetails = ");
        builder.append("[");
        for (String key : this.mSkuMap.keySet()) {
            builder.append(key);
            builder.append(" = ");
            builder.append(this.getSkuDetails(key));
            builder.append(", ");
        }
        builder.append("]");
        builder.append(", purchases = ");
        builder.append("[");
        for (String key : this.mPurchaseMap.keySet()) {
            builder.append(key);
            builder.append(" = ");
            builder.append(this.getSkuDetails(key));
            builder.append(", ");
        }
        builder.append("]");
        return "{Inventory: " + builder.toString() + "}";
    }
}

