/*
 * Decompiled with CFR 0.152.
 */
package com.unity.purchasing.googleplay;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import com.unity.purchasing.googleplay.GooglePlayPurchasing;
import com.unity.purchasing.googleplay.IPurchaseActivity;

public class PurchaseActivity
extends Activity
implements IPurchaseActivity {
    protected static final String TAG = "UnityIAP";
    private boolean receivedResult;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i((String)TAG, (String)"Creating purchase activity");
        Bundle extras = this.getIntent().getExtras();
        if (extras != null && extras.getBoolean("vr", false)) {
            View decorView = this.getWindow().getDecorView();
            int uiOptions = 6;
            if (Build.VERSION.SDK_INT >= 11) {
                decorView.setSystemUiVisibility(uiOptions);
            }
        }
        String productId = this.getIntent().getExtras().getString("productId");
        String developerPayload = this.getIntent().getExtras().getString("developerPayload");
        String purchaseType = this.getIntent().getExtras().getString("type");
        String oldSkuMetadata = this.getIntent().getExtras().getString("oldSkuMetadata");
        String newSku = this.getIntent().getExtras().getString("newSku");
        if (purchaseType != null && purchaseType.equals("subscription_update")) {
            if (!GooglePlayPurchasing.ContinueSubscriptionUpdate(this, oldSkuMetadata, newSku)) {
                this.setResult(0);
                this.finish();
            }
        } else if (!GooglePlayPurchasing.ContinuePurchase(this, productId, developerPayload)) {
            this.setResult(0);
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.processActivityResult(requestCode, resultCode, data);
        this.receivedResult = true;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (!this.receivedResult) {
            this.processActivityResult(999, 0, null);
        }
    }

    @Override
    public void processActivityResult(int requestCode, int resultCode, Intent data) {
        GooglePlayPurchasing.ProcessActivityResult(requestCode, resultCode, data);
        this.finish();
    }
}

