/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.iap.lib.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Toast;
import com.samsung.android.sdk.iap.lib.activity.BaseActivity;
import com.unity.purchasing.samsung.R;

public class InboxActivity
extends BaseActivity {
    private static final String TAG = InboxActivity.class.getSimpleName();
    private int mInboxApiType = 0;
    private int mStartNum = 0;
    private int mEndNum = 0;
    private String mStartDate = "";
    private String mEndDate = "";
    private String mItemIds = "";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent != null && intent.getExtras() != null) {
            Bundle extras = intent.getExtras();
            this.mInboxApiType = extras.getInt("OpenApiType", -1);
            if (this.mInboxApiType == 1) {
                if (extras.containsKey("ItemIds")) {
                    this.mItemIds = extras.getString("ItemIds");
                    this.mShowErrorDialog = extras.getBoolean("ShowErrorDialog", true);
                } else {
                    this.showWrongParamMsgAndFinish();
                }
            } else if (this.mInboxApiType == 0) {
                if (extras.containsKey("StartNum") && extras.containsKey("EndNum") && extras.containsKey("StartDate") && extras.containsKey("EndDate")) {
                    this.mStartNum = extras.getInt("StartNum");
                    this.mEndNum = extras.getInt("EndNum");
                    this.mStartDate = extras.getString("StartDate");
                    this.mEndDate = extras.getString("EndDate");
                    this.mShowErrorDialog = extras.getBoolean("ShowErrorDialog", true);
                } else {
                    this.showWrongParamMsgAndFinish();
                }
            } else {
                this.showWrongParamMsgAndFinish();
            }
        } else {
            this.showWrongParamMsgAndFinish();
        }
        if (this.checkIapPackage()) {
            this.mSamsungIapHelper.startAccountActivity(this);
        }
    }

    private void showWrongParamMsgAndFinish() {
        Toast.makeText((Context)this, (int)R.string.IDS_SAPPS_POP_AN_INVALID_VALUE_HAS_BEEN_PROVIDED_FOR_SAMSUNG_IN_APP_PURCHASE, (int)1).show();
        this.mErrorVo.setError(-1002, this.getString(R.string.IDS_SAPPS_POP_AN_INVALID_VALUE_HAS_BEEN_PROVIDED_FOR_SAMSUNG_IN_APP_PURCHASE));
        this.finish();
    }

    protected void onActivityResult(int _requestCode, int _resultCode, Intent _intent) {
        switch (_requestCode) {
            case 2: {
                if (-1 == _resultCode) {
                    this.bindIapService();
                    break;
                }
                this.mErrorVo.setError(1, this.getString(R.string.IDS_SAPPS_POP_PAYMENT_CANCELLED));
                this.mSamsungIapHelper.showIapDialogIfNeeded(this, this.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.getString(R.string.IDS_SAPPS_POP_PAYMENT_CANCELLED), true, null, this.mShowErrorDialog);
            }
        }
    }

    @Override
    protected void succeedBind() {
        if (this.mInboxApiType == 1) {
            this.mSamsungIapHelper.safeGetItemInboxTask(this, this.mItemIds, this.mShowErrorDialog);
        } else {
            this.mSamsungIapHelper.safeGetItemInboxTask(this, this.mStartNum, this.mEndNum, this.mStartDate, this.mEndDate, this.mShowErrorDialog);
        }
    }
}

