/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.android.sdk.iap.lib.helper;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.samsung.android.sdk.iap.lib.activity.BaseActivity;
import com.samsung.android.sdk.iap.lib.activity.InboxActivity;
import com.samsung.android.sdk.iap.lib.activity.PaymentActivity;
import com.samsung.android.sdk.iap.lib.helper.UnityIapHelper;
import com.samsung.android.sdk.iap.lib.listener.OnGetInboxListener;
import com.samsung.android.sdk.iap.lib.listener.OnGetItemListener;
import com.samsung.android.sdk.iap.lib.listener.OnIapBindListener;
import com.samsung.android.sdk.iap.lib.listener.OnInitIapListener;
import com.samsung.android.sdk.iap.lib.listener.OnPaymentListener;
import com.samsung.android.sdk.iap.lib.vo.ErrorVo;
import com.samsung.android.sdk.iap.lib.vo.InboxVo;
import com.samsung.android.sdk.iap.lib.vo.ItemVo;
import com.samsung.android.sdk.iap.lib.vo.PurchaseVo;
import com.samsung.android.sdk.iap.lib.vo.VerificationVo;
import com.sec.android.app.billing.iap.IAPConnector;
import com.unity.purchasing.samsung.R;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class SamsungIapHelper {
    protected static final boolean UNITY_MODE = true;
    private static final String TAG = SamsungIapHelper.class.getSimpleName();
    private static final int HONEYCOMB_MR1 = 12;
    public static final int INBOX_TYPE_ALL_ITEMS = 0;
    public static final int INBOX_TYPE_SELECTED_ITEMS = 1;
    public static final int INBOX_TYPE_NONE = -1;
    public static final int IAP_SIGNATURE_HASHCODE = 2055122763;
    public static final String IAP_PACKAGE_NAME = "com.sec.android.iap";
    public static final String BILLING_IAP_PACKAGE_NAME = "com.sec.android.app.billing";
    public static final String IAP_SERVICE_NAME = "com.sec.android.iap.service.iapService";
    public static final int IAP_RESPONSE_RESULT_OK = 0;
    public static final int IAP_RESPONSE_RESULT_UNAVAILABLE = 2;
    public static final String KEY_NAME_THIRD_PARTY_NAME = "THIRD_PARTY_NAME";
    public static final String KEY_NAME_STATUS_CODE = "STATUS_CODE";
    public static final String KEY_NAME_ERROR_STRING = "ERROR_STRING";
    public static final String KEY_NAME_IAP_UPGRADE_URL = "IAP_UPGRADE_URL";
    public static final String KEY_NAME_ITEM_GROUP_ID = "ITEM_GROUP_ID";
    public static final String KEY_NAME_ITEM_ID = "ITEM_ID";
    public static final String KEY_NAME_RESULT_LIST = "RESULT_LIST";
    public static final String KEY_NAME_RESULT_OBJECT = "RESULT_OBJECT";
    public static final String ITEM_TYPE_CONSUMABLE = "00";
    public static final String ITEM_TYPE_NON_CONSUMABLE = "01";
    public static final String ITEM_TYPE_SUBSCRIPTION = "02";
    public static final String ITEM_TYPE_AUTO_RECURRING_SUBSCRIPTIONS = "03";
    public static final String ITEM_TYPE_ALL = "10";
    public static final int REQUEST_CODE_IS_IAP_PAYMENT = 1;
    public static final int REQUEST_CODE_IS_ACCOUNT_CERTIFICATION = 2;
    public static final int IAP_ERROR_NONE = 0;
    public static final int IAP_PAYMENT_IS_CANCELED = 1;
    public static final int IAP_ERROR_INITIALIZATION = -1000;
    public static final int IAP_ERROR_NEED_APP_UPGRADE = -1001;
    public static final int IAP_ERROR_COMMON = -1002;
    public static final int IAP_ERROR_ALREADY_PURCHASED = -1003;
    public static final int IAP_ERROR_WHILE_RUNNING = -1004;
    public static final int IAP_ERROR_PRODUCT_DOES_NOT_EXIST = -1005;
    public static final int IAP_ERROR_CONFIRM_INBOX = -1006;
    public static final int IAP_ERROR_ITEM_GROUP_DOES_NOT_EXIST = -1007;
    public static final int IAP_ERROR_NETWORK_NOT_AVAILABLE = -1008;
    public static final int IAP_ERROR_IOEXCEPTION_ERROR = -1009;
    public static final int IAP_ERROR_SOCKET_TIMEOUT = -1010;
    public static final int IAP_ERROR_CONNECT_TIMEOUT = -1011;
    public static final int IAP_ERROR_NOT_EXIST_LOCAL_PRICE = -1012;
    public static final int IAP_ERROR_NOT_AVAILABLE_SHOP = -1013;
    public static final int IAP_MODE_TEST_SUCCESS = 1;
    public static final int IAP_MODE_TEST_FAIL = -1;
    public static final int IAP_MODE_COMMERCIAL = 0;
    private int mMode = 1;
    private Context mContext = null;
    private IAPConnector mIapConnector = null;
    private ServiceConnection mServiceConn = null;
    private InitIapTask mInitIapTask = null;
    private OnInitIapListener mOnInitIapListener = null;
    private GetItemListTask mGetItemListTask = null;
    private UnityHelperGetItemListTask mUnityHelperGetItemListTask = null;
    private OnGetItemListener mOnGetItemListener = null;
    private GetInboxListTask mGetInboxListTask = null;
    private OnGetInboxListener mOnGetInboxListener = null;
    private static final String VERIFY_URL = "https://iap.samsungapps.com/iap/appsItemVerifyIAPReceipt.as?protocolVersion=2.0";
    private VerifyClientToServer mVerifyClientToServer = null;
    private OnPaymentListener mOnPaymentListener = null;
    private static SamsungIapHelper mInstance = null;
    private int mState = 0;
    private static final int STATE_TERM = 0;
    private static final int STATE_BINDING = 1;
    private static final int STATE_READY = 2;

    private SamsungIapHelper(Context _context, int _mode) {
        this._setContextAndMode(_context, _mode);
    }

    public static SamsungIapHelper getInstance(Context _context, int _mode) {
        if (null == mInstance) {
            mInstance = new SamsungIapHelper(_context, _mode);
        } else {
            mInstance._setContextAndMode(_context, _mode);
        }
        return mInstance;
    }

    private void _setContextAndMode(Context _context, int _mode) {
        this.mContext = _context.getApplicationContext();
        this.mMode = _mode;
    }

    public void startAccountActivity(Activity _activity) {
        ComponentName com = new ComponentName(BILLING_IAP_PACKAGE_NAME, "com.sec.android.app.billing.iap.activity.AccountActivity");
        Intent intent = new Intent();
        intent.setComponent(com);
        if (intent.resolveActivity(this.mContext.getPackageManager()) != null) {
            _activity.startActivityForResult(intent, 2);
        }
    }

    public void bindIapService(final OnIapBindListener _listener) {
        if (this.mState >= 1) {
            if (_listener != null) {
                _listener.onBindIapFinished(0);
            }
            return;
        }
        this.mServiceConn = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName _name) {
                Log.d((String)TAG, (String)"IAP Service Disconnected...");
                SamsungIapHelper.this.mState = 0;
                SamsungIapHelper.this.mIapConnector = null;
                SamsungIapHelper.this.mServiceConn = null;
            }

            public void onServiceConnected(ComponentName _name, IBinder _service) {
                SamsungIapHelper.this.mIapConnector = IAPConnector.Stub.asInterface(_service);
                if (_listener != null) {
                    if (SamsungIapHelper.this.mIapConnector != null) {
                        SamsungIapHelper.this.mState = 1;
                        _listener.onBindIapFinished(0);
                    } else {
                        SamsungIapHelper.this.mState = 0;
                        _listener.onBindIapFinished(2);
                    }
                }
            }
        };
        Intent serviceIntent = new Intent();
        serviceIntent.setComponent(new ComponentName(BILLING_IAP_PACKAGE_NAME, "com.sec.android.app.billing.iap.service.IAPService"));
        this.mContext.bindService(serviceIntent, this.mServiceConn, 1);
    }

    public void safeInitIap(BaseActivity _activity, boolean _showErrorDialog) {
        try {
            if (this.mInitIapTask != null && this.mInitIapTask.getStatus() != AsyncTask.Status.FINISHED) {
                this.mInitIapTask.cancel(true);
            }
            this.mInitIapTask = new InitIapTask(_activity, _showErrorDialog);
            this.mInitIapTask.execute(new String[0]);
        }
        catch (Exception e) {
            if (null != _activity) {
                _activity.finish();
            }
            e.printStackTrace();
        }
    }

    public void setOnInitIapListener(OnInitIapListener _onInitIapListener) {
        this.mOnInitIapListener = _onInitIapListener;
    }

    public void init(ErrorVo _errorVo) {
        try {
            Bundle bundle = this.mIapConnector.init(this.mMode);
            if (null != bundle) {
                _errorVo.setError(bundle.getInt(KEY_NAME_STATUS_CODE), bundle.getString(KEY_NAME_ERROR_STRING));
                _errorVo.setExtraString(bundle.getString(KEY_NAME_IAP_UPGRADE_URL));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void getItemList(String _itemGroupId, int _startNum, int _endNum, String _itemType, int _mode, OnGetItemListener _onGetItemListener) {
        this.getItemList(_startNum, _endNum, _itemType, _mode, _onGetItemListener, true);
    }

    public void getItemList(int _startNum, int _endNum, String _itemType, int _mode, OnGetItemListener _onGetItemListener) {
        this.getItemList(_startNum, _endNum, _itemType, _mode, _onGetItemListener, true);
    }

    public void getItemList(int _startNum, int _endNum, String _itemType, int _mode, OnGetItemListener _onGetItemListener, boolean _showErrorDialog) {
        try {
            if (null == _onGetItemListener) {
                throw new Exception("OnGetItemListener is null");
            }
            this.setOnGetItemListener(_onGetItemListener);
            this.unityHelperGetItemList(_startNum, _endNum, _itemType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void safeGetItemList(BaseActivity _activity, int _startNum, int _endNum, String _itemType, boolean _showErrorDialog) {
        try {
            if (this.mGetItemListTask != null && this.mGetItemListTask.getStatus() != AsyncTask.Status.FINISHED) {
                this.mGetItemListTask.cancel(true);
            }
            this.mGetItemListTask = new GetItemListTask(_activity, _startNum, _endNum, _itemType, _showErrorDialog);
            this.mGetItemListTask.execute(new String[0]);
        }
        catch (Exception e) {
            if (null != _activity) {
                _activity.finish();
            }
            e.printStackTrace();
        }
    }

    public void unityHelperGetItemList(int _startNum, int _endNum, String _itemType) {
        try {
            if (this.mUnityHelperGetItemListTask != null && this.mUnityHelperGetItemListTask.getStatus() != AsyncTask.Status.FINISHED) {
                this.mUnityHelperGetItemListTask.cancel(true);
            }
            this.mUnityHelperGetItemListTask = new UnityHelperGetItemListTask(new UnityIapHelper(this.mContext, this), _startNum, _endNum, _itemType);
            this.mUnityHelperGetItemListTask.execute(new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnGetItemListener(OnGetItemListener _onGetItemListener) {
        this.mOnGetItemListener = _onGetItemListener;
    }

    public OnGetItemListener getOnGetItemListener() {
        return this.mOnGetItemListener;
    }

    public void startPayment(String _itemGroupId, String _itemId, boolean _showSuccessDialog, OnPaymentListener _onPaymentListener) {
        this.startPayment(_itemId, _showSuccessDialog, true, _onPaymentListener);
    }

    public void startPayment(String _itemId, boolean _showSuccessDialog, OnPaymentListener _onPaymentListener) {
        this.startPayment(_itemId, _showSuccessDialog, true, _onPaymentListener);
    }

    public void startPayment(String _itemId, boolean _showSuccessDialog, boolean _showErrorDialog, OnPaymentListener _onPaymentListener) {
        try {
            if (null == _onPaymentListener) {
                throw new Exception("OnPaymentListener is null");
            }
            this.setOnPaymentListener(_onPaymentListener);
            Intent intent = new Intent(this.mContext, PaymentActivity.class);
            intent.putExtra("ItemId", _itemId);
            intent.putExtra("ShowSuccessDialog", _showSuccessDialog);
            intent.putExtra("ShowErrorDialog", _showErrorDialog);
            intent.putExtra("IapMode", this.mMode);
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startPaymentActivity(Activity _activity, int _requestCode, String _itemId) {
        try {
            Bundle bundle = new Bundle();
            bundle.putString(KEY_NAME_THIRD_PARTY_NAME, this.mContext.getPackageName());
            bundle.putString(KEY_NAME_ITEM_ID, _itemId);
            ComponentName com = new ComponentName(BILLING_IAP_PACKAGE_NAME, "com.sec.android.app.billing.iap.activity.PaymentMethodListActivity");
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.LAUNCHER");
            intent.setComponent(com);
            intent.putExtras(bundle);
            if (intent.resolveActivity(this.mContext.getPackageManager()) != null) {
                _activity.startActivityForResult(intent, _requestCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnPaymentListener(OnPaymentListener _onPaymentListener) {
        this.mOnPaymentListener = _onPaymentListener;
    }

    public OnPaymentListener getOnPaymentListener() {
        return this.mOnPaymentListener;
    }

    public void getItemInboxList(String _itemGroupId, int _startNum, int _endNum, String _startDate, String _endDate, OnGetInboxListener _onGetInboxListener) {
        this.getItemInboxList(_startNum, _endNum, _startDate, _endDate, _onGetInboxListener, true);
    }

    public void getItemInboxList(int _startNum, int _endNum, String _startDate, String _endDate, OnGetInboxListener _onGetInboxListener) {
        this.getItemInboxList(_startNum, _endNum, _startDate, _endDate, _onGetInboxListener, true);
    }

    public void getItemInboxList(int _startNum, int _endNum, String _startDate, String _endDate, OnGetInboxListener _onGetInboxListener, boolean _showErrorDialog) {
        try {
            if (null == _onGetInboxListener) {
                throw new Exception("OnGetInboxListener is null");
            }
            this.setOnGetInboxListener(_onGetInboxListener);
            Intent intent = new Intent(this.mContext, InboxActivity.class);
            intent.putExtra("OpenApiType", 0);
            intent.putExtra("IapMode", this.mMode);
            intent.putExtra("StartNum", _startNum);
            intent.putExtra("EndNum", _endNum);
            intent.putExtra("StartDate", _startDate);
            intent.putExtra("EndDate", _endDate);
            intent.putExtra("ShowErrorDialog", _showErrorDialog);
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getItemInboxList(String _itemGroupId, String _itemIds, OnGetInboxListener _onGetInboxListener) {
        this.getItemInboxList(_itemIds, _onGetInboxListener, true);
    }

    public void getItemInboxList(String _itemIds, OnGetInboxListener _onGetInboxListener) {
        this.getItemInboxList(_itemIds, _onGetInboxListener, true);
    }

    public void getItemInboxList(String _itemIds, OnGetInboxListener _onGetInboxListener, boolean _showErrorDialog) {
        try {
            if (null == _onGetInboxListener) {
                throw new Exception("OnGetInboxListener is null");
            }
            this.setOnGetInboxListener(_onGetInboxListener);
            Intent intent = new Intent(this.mContext, InboxActivity.class);
            intent.putExtra("OpenApiType", 1);
            intent.putExtra("ItemIds", _itemIds);
            intent.putExtra("IapMode", this.mMode);
            intent.putExtra("ShowErrorDialog", _showErrorDialog);
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void safeGetItemInboxTask(BaseActivity _activity, int _startNum, int _endNum, String _startDate, String _endDate, boolean _showErrorDialog) {
        try {
            if (this.mGetInboxListTask != null && this.mGetInboxListTask.getStatus() != AsyncTask.Status.FINISHED) {
                this.mGetInboxListTask.cancel(true);
            }
            this.mGetInboxListTask = new GetInboxListTask(_activity, _startNum, _endNum, _startDate, _endDate, _showErrorDialog);
            this.mGetInboxListTask.execute(new String[0]);
        }
        catch (Exception e) {
            if (null != _activity) {
                _activity.finish();
            }
            e.printStackTrace();
        }
    }

    public void safeGetItemInboxTask(BaseActivity _activity, String _itemIds, boolean _showErrorDialog) {
        try {
            if (this.mGetInboxListTask != null && this.mGetInboxListTask.getStatus() != AsyncTask.Status.FINISHED) {
                this.mGetInboxListTask.cancel(true);
            }
            this.mGetInboxListTask = new GetInboxListTask(_activity, _itemIds, _showErrorDialog);
            this.mGetInboxListTask.execute(new String[0]);
        }
        catch (Exception e) {
            if (null != _activity) {
                _activity.finish();
            }
            e.printStackTrace();
        }
    }

    public void setOnGetInboxListener(OnGetInboxListener _onGetInboxListener) {
        this.mOnGetInboxListener = _onGetInboxListener;
    }

    public OnGetInboxListener getOnGetInboxListener() {
        return this.mOnGetInboxListener;
    }

    public void verifyPurchaseResult(BaseActivity _activity, PurchaseVo _purchaseVO, boolean _showSuccessDialog, boolean _showErrorDialog) {
        try {
            if (this.mVerifyClientToServer != null && this.mVerifyClientToServer.getStatus() != AsyncTask.Status.FINISHED) {
                this.mVerifyClientToServer.cancel(true);
            }
            this.mVerifyClientToServer = new VerifyClientToServer(_activity, _purchaseVO, _showSuccessDialog, _showErrorDialog);
            this.mVerifyClientToServer.execute(new Void[0]);
        }
        catch (Exception e) {
            if (null != _activity) {
                _activity.finish();
            }
            e.printStackTrace();
        }
    }

    private void stopTasksIfNotFinished() {
        if (this.mInitIapTask != null && this.mInitIapTask.getStatus() != AsyncTask.Status.FINISHED) {
            this.mInitIapTask.cancel(true);
        }
        if (this.mGetItemListTask != null && this.mGetItemListTask.getStatus() != AsyncTask.Status.FINISHED) {
            this.mGetItemListTask.cancel(true);
        }
        if (this.mGetInboxListTask != null && this.mGetInboxListTask.getStatus() != AsyncTask.Status.FINISHED) {
            this.mGetInboxListTask.cancel(true);
        }
        if (this.mVerifyClientToServer != null && this.mVerifyClientToServer.getStatus() != AsyncTask.Status.FINISHED) {
            this.mVerifyClientToServer.cancel(true);
        }
    }

    public void removeAllListener() {
        this.mOnGetInboxListener = null;
        this.mOnGetItemListener = null;
        this.mOnPaymentListener = null;
    }

    public void dispose() {
        this.stopTasksIfNotFinished();
        if (this.mContext != null && this.mServiceConn != null) {
            this.mContext.unbindService(this.mServiceConn);
        }
        this.mState = 0;
        this.mServiceConn = null;
        this.mIapConnector = null;
    }

    public void installIapPackage(BaseActivity _activity) {
        Runnable OkBtnRunnable = new Runnable(){

            @Override
            public void run() {
                Uri iapDeepLink = Uri.parse((String)"samsungapps://ProductDetail/com.sec.android.app.billing");
                Intent intent = new Intent();
                intent.setData(iapDeepLink);
                if (Build.VERSION.SDK_INT >= 12) {
                    intent.addFlags(335544352);
                } else {
                    intent.addFlags(0x14000000);
                }
                if (intent.resolveActivity(SamsungIapHelper.this.mContext.getPackageManager()) != null) {
                    SamsungIapHelper.this.mContext.startActivity(intent);
                }
            }
        };
        ErrorVo errorVo = new ErrorVo();
        _activity.setErrorVo(errorVo);
        errorVo.setError(1, _activity.getString(R.string.IDS_SAPPS_POP_PAYMENT_CANCELLED));
        this.showIapDialogIfNeeded(_activity, _activity.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), _activity.getString(R.string.IDS_SAPPS_POP_TO_PURCHASE_ITEMS_YOU_NEED_TO_INSTALL_SAMSUNG_IN_APP_PURCHASE_INSTALL_Q), true, OkBtnRunnable, true);
    }

    public boolean isInstalledIapPackage(Context _context) {
        PackageManager pm = _context.getPackageManager();
        try {
            pm.getApplicationInfo(BILLING_IAP_PACKAGE_NAME, 128);
            PackageInfo packageInfo = pm.getPackageInfo(BILLING_IAP_PACKAGE_NAME, 128);
            return packageInfo.versionCode >= 400000000;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isValidIapPackage(Context _context) {
        boolean result = true;
        boolean isTest = true;
        if (isTest) {
            return true;
        }
        try {
            Signature[] sigs = _context.getPackageManager().getPackageInfo((String)BILLING_IAP_PACKAGE_NAME, (int)64).signatures;
            if (sigs[0].hashCode() != 2055122763) {
                result = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public void showIapDialogIfNeeded(final Activity _activity, String _title, String _message, final boolean _finishActivity, final Runnable _onClickRunable, boolean _showDialog) {
        if (!_showDialog) {
            if (_finishActivity) {
                try {
                    _activity.finish();
                }
                catch (Exception _e) {
                    _e.printStackTrace();
                }
            }
            return;
        }
        AlertDialog.Builder alert = new AlertDialog.Builder((Context)_activity);
        alert.setTitle((CharSequence)_title);
        alert.setMessage((CharSequence)_message);
        alert.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface _dialog, int _which) {
                if (null != _onClickRunable) {
                    _onClickRunable.run();
                }
                _dialog.dismiss();
                if (_finishActivity) {
                    _activity.finish();
                }
            }
        });
        if (_finishActivity) {
            alert.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    _activity.finish();
                }
            });
        }
        try {
            alert.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class VerifyClientToServer
    extends AsyncTask<Void, Void, Boolean> {
        private PurchaseVo mPurchaseVO = null;
        private ErrorVo mErrorVo = null;
        private VerificationVo mVerificationVO = null;
        private BaseActivity mActivity = null;
        private boolean mShowSuccessDialog = true;
        private boolean mShowErrorDialog = true;

        public VerifyClientToServer(BaseActivity _activity, PurchaseVo _purchaseVO, boolean _showSuccessDialog, boolean _showErrorDialog) {
            this.mActivity = _activity;
            this.mPurchaseVO = _purchaseVO;
            this.mShowSuccessDialog = _showSuccessDialog;
            this.mShowErrorDialog = _showErrorDialog;
            this.mErrorVo = new ErrorVo();
            this.mActivity.setErrorVo(this.mErrorVo);
            this.mActivity.setPurchaseVo(this.mPurchaseVO);
        }

        protected Boolean doInBackground(Void ... params) {
            if (null == this.mPurchaseVO || null == this.mActivity) {
                return false;
            }
            try {
                StringBuffer strUrl = new StringBuffer();
                strUrl.append(SamsungIapHelper.VERIFY_URL);
                strUrl.append("&purchaseID=" + this.mPurchaseVO.getPurchaseId());
                int retryCount = 0;
                String strResponse = null;
                do {
                    strResponse = this.getHttpGetData(strUrl.toString(), 10000, 10000);
                } while (++retryCount < 3 && (strResponse == null || TextUtils.isEmpty((CharSequence)strResponse)));
                if (strResponse != null && !TextUtils.isEmpty((CharSequence)strResponse)) {
                    this.mVerificationVO = new VerificationVo(strResponse);
                    if (!"true".equals(this.mVerificationVO.getStatus())) {
                        return false;
                    }
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }

        protected void onPostExecute(Boolean result) {
            if (result.booleanValue()) {
                this.mErrorVo.setError(0, this.mActivity.getString(R.string.dlg_msg_payment_success));
                SamsungIapHelper.this.showIapDialogIfNeeded(this.mActivity, this.mActivity.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.mErrorVo.getErrorString(), true, null, this.mShowSuccessDialog);
            } else {
                this.mErrorVo.setError(-1002, this.mActivity.getString(R.string.IDS_SAPPS_POP_YOUR_PURCHASE_VIA_SAMSUNG_IN_APP_PURCHASE_IS_INVALID_A_FAKE_APPLICATION_HAS_BEEN_DETECTED_CHECK_THE_APP_MSG));
                SamsungIapHelper.this.showIapDialogIfNeeded(this.mActivity, this.mActivity.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.mErrorVo.getErrorString(), true, null, this.mShowErrorDialog);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHttpGetData(String _strUrl, int _connTimeout, int _readTimeout) {
            String strResult = null;
            URLConnection con = null;
            HttpURLConnection httpConnection = null;
            BufferedInputStream bis = null;
            ByteArrayOutputStream buffer = null;
            try {
                URL url = new URL(_strUrl);
                con = url.openConnection();
                con.setConnectTimeout(10000);
                con.setReadTimeout(10000);
                httpConnection = (HttpURLConnection)con;
                httpConnection.setRequestMethod("GET");
                httpConnection.connect();
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == 200) {
                    int nRead;
                    bis = new BufferedInputStream(httpConnection.getInputStream(), 4096);
                    buffer = new ByteArrayOutputStream(4096);
                    byte[] bData = new byte[4096];
                    while ((nRead = bis.read(bData, 0, 4096)) != -1) {
                        buffer.write(bData, 0, nRead);
                    }
                    buffer.flush();
                    strResult = buffer.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {}
                }
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException iOException) {}
                }
                con = null;
                httpConnection = null;
            }
            return strResult;
        }
    }

    private class GetInboxListTask
    extends AsyncTask<String, Object, Boolean> {
        private BaseActivity mActivity = null;
        private int mInboxApiType = 0;
        private int mStartNum = 0;
        private int mEndNum = 0;
        private String mStartDate = "";
        private String mEndDate = "";
        private String mItemIds = "";
        private ErrorVo mErrorVo = new ErrorVo();
        private ArrayList<InboxVo> mInbox = new ArrayList();
        private boolean mShowErrorDialog = true;

        public GetInboxListTask(BaseActivity _activity, int _startNum, int _endNum, String _startDate, String _endDate, boolean _showErrorDialog) {
            this.mInboxApiType = 0;
            this.mActivity = _activity;
            this.mStartNum = _startNum;
            this.mEndNum = _endNum;
            this.mStartDate = _startDate;
            this.mEndDate = _endDate;
            this.mShowErrorDialog = _showErrorDialog;
            this.mActivity.setErrorVo(this.mErrorVo);
            this.mActivity.setInbox(this.mInbox);
        }

        public GetInboxListTask(BaseActivity _activity, String _itemIds, boolean _showErrorDialog) {
            this.mInboxApiType = 1;
            this.mActivity = _activity;
            this.mItemIds = _itemIds;
            this.mShowErrorDialog = _showErrorDialog;
            this.mActivity.setErrorVo(this.mErrorVo);
            this.mActivity.setInbox(this.mInbox);
        }

        protected Boolean doInBackground(String ... params) {
            try {
                Bundle bundle = null;
                bundle = 1 == this.mInboxApiType ? SamsungIapHelper.this.mIapConnector.getItemsInbox2(this.mActivity.getPackageName(), this.mItemIds) : SamsungIapHelper.this.mIapConnector.getItemsInbox(this.mActivity.getPackageName(), null, this.mStartNum, this.mEndNum, this.mStartDate, this.mEndDate);
                if (bundle != null) {
                    this.mErrorVo.setError(bundle.getInt(SamsungIapHelper.KEY_NAME_STATUS_CODE), bundle.getString(SamsungIapHelper.KEY_NAME_ERROR_STRING));
                } else {
                    this.mErrorVo.setError(-1002, this.mActivity.getString(R.string.IDS_SAPPS_POP_UNKNOWN_ERROR_OCCURRED));
                }
                if (0 == this.mErrorVo.getErrorCode()) {
                    ArrayList purchaseItemStringList = bundle.getStringArrayList(SamsungIapHelper.KEY_NAME_RESULT_LIST);
                    if (purchaseItemStringList != null) {
                        for (String itemString : purchaseItemStringList) {
                            InboxVo inboxVo = new InboxVo(itemString);
                            this.mInbox.add(inboxVo);
                        }
                    } else {
                        Log.d((String)TAG, (String)"Bundle Value 'RESULT_LIST' is null.");
                    }
                } else {
                    Log.d((String)TAG, (String)this.mErrorVo.getErrorString());
                }
            }
            catch (Exception e) {
                this.mErrorVo.setError(-1002, this.mActivity.getString(R.string.IDS_SAPPS_POP_UNKNOWN_ERROR_OCCURRED));
                e.printStackTrace();
                return false;
            }
            return true;
        }

        protected void onPostExecute(Boolean _result) {
            if (_result.booleanValue()) {
                if (this.mErrorVo.getErrorCode() == 0) {
                    if (null != this.mActivity) {
                        this.mActivity.finish();
                    }
                } else {
                    SamsungIapHelper.this.showIapDialogIfNeeded(this.mActivity, this.mActivity.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.mErrorVo.getErrorString(), true, null, this.mShowErrorDialog);
                }
            } else {
                SamsungIapHelper.this.showIapDialogIfNeeded(this.mActivity, this.mActivity.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.mActivity.getString(R.string.IDS_SAPPS_POP_UNKNOWN_ERROR_OCCURRED) + "[Lib_InboxList]", true, null, this.mShowErrorDialog);
            }
        }
    }

    private class UnityHelperGetItemListTask
    extends AsyncTask<String, Object, Boolean> {
        private int mStartNum = 1;
        private int mEndNum = 15;
        private String mItemType = "";
        private UnityIapHelper mUnityIapHelper = null;
        ErrorVo mErrorVo = new ErrorVo();
        ArrayList<ItemVo> mItemList = new ArrayList();

        public UnityHelperGetItemListTask(UnityIapHelper _unityIapHelper, int _startNum, int _endNum, String _itemType) {
            this.mUnityIapHelper = _unityIapHelper;
            this.mStartNum = _startNum;
            this.mEndNum = _endNum;
            this.mItemType = _itemType;
            this.mUnityIapHelper.setErrorVo(this.mErrorVo);
            this.mUnityIapHelper.setItemList(this.mItemList);
        }

        protected Boolean doInBackground(String ... params) {
            try {
                Bundle bundle = SamsungIapHelper.this.mIapConnector.getItemList(SamsungIapHelper.this.mMode, this.mUnityIapHelper.getContext().getPackageName(), null, this.mStartNum, this.mEndNum, this.mItemType);
                if (bundle != null) {
                    this.mErrorVo.setError(bundle.getInt(SamsungIapHelper.KEY_NAME_STATUS_CODE), bundle.getString(SamsungIapHelper.KEY_NAME_ERROR_STRING));
                    this.mErrorVo.setExtraString(bundle.getString(SamsungIapHelper.KEY_NAME_IAP_UPGRADE_URL));
                } else {
                    this.mErrorVo.setError(-1002, "unknown - null IAP bundle");
                }
                if (this.mErrorVo.getErrorCode() == 0 && bundle != null) {
                    ArrayList itemStringList = bundle.getStringArrayList(SamsungIapHelper.KEY_NAME_RESULT_LIST);
                    if (itemStringList != null) {
                        for (String itemString : itemStringList) {
                            this.mItemList.add(new ItemVo(itemString));
                        }
                    } else {
                        Log.d((String)TAG, (String)"Bundle Value 'RESULT_LIST' is null.");
                    }
                } else {
                    Log.d((String)TAG, (String)this.mErrorVo.getErrorString());
                }
            }
            catch (Exception e) {
                this.mErrorVo.setError(-1002, "unknown - getItemList");
                e.printStackTrace();
                return false;
            }
            return true;
        }

        protected void onPostExecute(Boolean _result) {
            switch (this.mErrorVo.getErrorCode()) {
                case 0: {
                    this.notifySuccess();
                    break;
                }
                case -1001: {
                    this.mUnityIapHelper.setUpgradeUrl(this.mErrorVo.getExtraString());
                }
                default: {
                    Log.e((String)TAG, (String)this.mErrorVo.getErrorString());
                }
            }
        }

        protected void notifySuccess() {
            OnGetItemListener onItemListener = this.mUnityIapHelper.getSamsungIapHelper().getOnGetItemListener();
            if (null != onItemListener) {
                onItemListener.onGetItem(this.mErrorVo, this.mItemList);
            }
            this.mUnityIapHelper.getSamsungIapHelper().removeAllListener();
            this.mUnityIapHelper.getSamsungIapHelper().dispose();
            this.mUnityIapHelper.setSamsungIapHelper(null);
        }
    }

    private class GetItemListTask
    extends AsyncTask<String, Object, Boolean> {
        private int mStartNum = 1;
        private int mEndNum = 15;
        private String mItemType = "";
        private boolean mShowErrorDialog = true;
        private BaseActivity mActivity = null;
        ErrorVo mErrorVo = new ErrorVo();
        ArrayList<ItemVo> mItemList = new ArrayList();

        public GetItemListTask(BaseActivity _activity, int _startNum, int _endNum, String _itemType, boolean _showErrorDialog) {
            this.mActivity = _activity;
            this.mStartNum = _startNum;
            this.mEndNum = _endNum;
            this.mItemType = _itemType;
            this.mShowErrorDialog = _showErrorDialog;
            this.mActivity.setErrorVo(this.mErrorVo);
            this.mActivity.setItemList(this.mItemList);
        }

        protected Boolean doInBackground(String ... params) {
            try {
                Bundle bundle = SamsungIapHelper.this.mIapConnector.getItemList(SamsungIapHelper.this.mMode, this.mActivity.getPackageName(), null, this.mStartNum, this.mEndNum, this.mItemType);
                if (bundle != null) {
                    this.mErrorVo.setError(bundle.getInt(SamsungIapHelper.KEY_NAME_STATUS_CODE), bundle.getString(SamsungIapHelper.KEY_NAME_ERROR_STRING));
                    this.mErrorVo.setExtraString(bundle.getString(SamsungIapHelper.KEY_NAME_IAP_UPGRADE_URL));
                } else {
                    this.mErrorVo.setError(-1002, this.mActivity.getString(R.string.IDS_SAPPS_POP_UNKNOWN_ERROR_OCCURRED));
                }
                if (this.mErrorVo.getErrorCode() == 0) {
                    ArrayList itemStringList = bundle.getStringArrayList(SamsungIapHelper.KEY_NAME_RESULT_LIST);
                    if (itemStringList != null) {
                        for (String itemString : itemStringList) {
                            ItemVo itemVo = new ItemVo(itemString);
                            this.mItemList.add(itemVo);
                        }
                    } else {
                        Log.d((String)TAG, (String)"Bundle Value 'RESULT_LIST' is null.");
                    }
                } else {
                    Log.d((String)TAG, (String)this.mErrorVo.getErrorString());
                }
            }
            catch (Exception e) {
                this.mErrorVo.setError(-1002, this.mActivity.getString(R.string.IDS_SAPPS_POP_UNKNOWN_ERROR_OCCURRED));
                e.printStackTrace();
                return false;
            }
            return true;
        }

        protected void onPostExecute(Boolean _result) {
            if (_result.booleanValue()) {
                if (this.mErrorVo.getErrorCode() == 0) {
                    if (this.mActivity != null) {
                        this.mActivity.finish();
                    }
                } else if (this.mErrorVo.getErrorCode() == -1001) {
                    Runnable OkBtnRunnable = new Runnable(){

                        @Override
                        public void run() {
                            if (TextUtils.isEmpty((CharSequence)GetItemListTask.this.mErrorVo.getExtraString())) {
                                return;
                            }
                            Intent intent = new Intent("android.intent.action.VIEW");
                            intent.setData(Uri.parse((String)GetItemListTask.this.mErrorVo.getExtraString()));
                            intent.addFlags(0x10000000);
                            try {
                                GetItemListTask.this.mActivity.startActivity(intent);
                            }
                            catch (ActivityNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    SamsungIapHelper.this.showIapDialogIfNeeded(this.mActivity, this.mActivity.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.mErrorVo.getErrorString(), true, OkBtnRunnable, true);
                    Log.e((String)TAG, (String)this.mErrorVo.getErrorString());
                } else {
                    SamsungIapHelper.this.showIapDialogIfNeeded(this.mActivity, this.mActivity.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.mErrorVo.getErrorString(), true, null, this.mShowErrorDialog);
                    Log.e((String)TAG, (String)this.mErrorVo.getErrorString());
                }
            } else {
                SamsungIapHelper.this.showIapDialogIfNeeded(this.mActivity, this.mActivity.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.mActivity.getString(R.string.IDS_SAPPS_POP_UNKNOWN_ERROR_OCCURRED) + "[Lib_ItemList]", true, null, this.mShowErrorDialog);
            }
        }
    }

    private class InitIapTask
    extends AsyncTask<String, Object, Boolean> {
        private BaseActivity mActivity = null;
        private ErrorVo mErrorVo = new ErrorVo();
        private boolean mShowErrorDialog = true;

        public InitIapTask(BaseActivity _activity, boolean _showErrorDialog) {
            this.mActivity = _activity;
            this.mShowErrorDialog = _showErrorDialog;
            this.mActivity.setErrorVo(this.mErrorVo);
        }

        protected Boolean doInBackground(String ... params) {
            try {
                if (SamsungIapHelper.this.mState == 2) {
                    this.mErrorVo.setError(0, "");
                } else {
                    Log.i((String)TAG, (String)"start Init... ");
                    SamsungIapHelper.this.init(this.mErrorVo);
                    Log.i((String)TAG, (String)"end Init... ");
                }
                return true;
            }
            catch (Exception e) {
                this.mErrorVo.setError(-1000, this.mActivity.getString(R.string.IDS_SAPPS_POP_UNKNOWN_ERROR_OCCURRED));
                e.printStackTrace();
                return false;
            }
        }

        protected void onPostExecute(Boolean result) {
            if (result.booleanValue()) {
                if (this.mErrorVo.getErrorCode() == 0) {
                    if (null != SamsungIapHelper.this.mOnInitIapListener) {
                        SamsungIapHelper.this.mState = 2;
                        SamsungIapHelper.this.mOnInitIapListener.onSucceedInitIap();
                    }
                } else if (this.mErrorVo.getErrorCode() == -1001) {
                    Runnable OkBtnRunnable = new Runnable(){

                        @Override
                        public void run() {
                            if (TextUtils.isEmpty((CharSequence)InitIapTask.this.mErrorVo.getExtraString())) {
                                return;
                            }
                            Intent intent = new Intent("android.intent.action.VIEW");
                            intent.setData(Uri.parse((String)InitIapTask.this.mErrorVo.getExtraString()));
                            intent.addFlags(0x10000000);
                            try {
                                InitIapTask.this.mActivity.startActivity(intent);
                            }
                            catch (ActivityNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    SamsungIapHelper.this.showIapDialogIfNeeded(this.mActivity, this.mActivity.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.mErrorVo.getErrorString(), true, OkBtnRunnable, true);
                } else {
                    SamsungIapHelper.this.showIapDialogIfNeeded(this.mActivity, this.mActivity.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.mErrorVo.getErrorString(), true, null, this.mShowErrorDialog);
                }
            } else {
                SamsungIapHelper.this.showIapDialogIfNeeded(this.mActivity, this.mActivity.getString(R.string.IDS_SAPPS_POP_SAMSUNG_IN_APP_PURCHASE), this.mActivity.getString(R.string.IDS_SAPPS_POP_UNKNOWN_ERROR_OCCURRED) + "[Lib_Init]", true, null, this.mShowErrorDialog);
            }
        }
    }
}

