/*
 * Decompiled with CFR 0.152.
 */
package com.unity.purchasing.common;

import com.unity.purchasing.common.INativeStore;
import com.unity.purchasing.common.IStore;
import com.unity.purchasing.common.ProductDefinition;
import com.unity.purchasing.common.ProductType;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class StoreDeserializer
implements INativeStore,
IStore {
    @Override
    public void RetrieveProducts(String json) {
        this.RetrieveProducts(StoreDeserializer.DeserializeProducts(json));
    }

    @Override
    public void Purchase(String productJSON, String developerPayload) {
        this.Purchase(StoreDeserializer.GetProductDefinition(productJSON), developerPayload);
    }

    @Override
    public void FinishTransaction(String productJSON, String transactionID) {
        this.FinishTransaction(StoreDeserializer.GetProductDefinition(productJSON), transactionID);
    }

    public static List<ProductDefinition> DeserializeProducts(String json) {
        try {
            JSONArray array = new JSONArray(json);
            ArrayList<ProductDefinition> result = new ArrayList<ProductDefinition>();
            for (int t = 0; t < array.length(); ++t) {
                JSONObject o = array.getJSONObject(t);
                result.add(StoreDeserializer.GetProductDefinition(o));
            }
            return result;
        }
        catch (JSONException j) {
            throw new RuntimeException(j);
        }
    }

    public static ProductDefinition GetProductDefinition(String json) {
        if (null == json) {
            return null;
        }
        try {
            JSONObject j = new JSONObject(json);
            return StoreDeserializer.GetProductDefinition(j);
        }
        catch (JSONException r) {
            throw new RuntimeException(r);
        }
    }

    private static ProductDefinition GetProductDefinition(JSONObject j) {
        try {
            return new ProductDefinition(j.getString("id"), j.getString("storeSpecificId"), ProductType.valueOf(j.getString("type")));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

