/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.unity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.LoginStatusCallback;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.internal.ActivityLifecycleTracker;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.applinks.AppLinkData;
import com.facebook.gamingservices.GamingImageUploader;
import com.facebook.gamingservices.GamingVideoUploader;
import com.facebook.internal.BundleJSONConverter;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.Utility;
import com.facebook.login.LoginManager;
import com.facebook.share.widget.ShareDialog;
import com.facebook.unity.FBLogin;
import com.facebook.unity.FBUnityCreateGameGroupActivity;
import com.facebook.unity.FBUnityDialogsActivity;
import com.facebook.unity.FBUnityGameRequestActivity;
import com.facebook.unity.FBUnityGamingServicesFriendFinderActivity;
import com.facebook.unity.FBUnityJoinGameGroupActivity;
import com.facebook.unity.FBUnityLoginActivity;
import com.facebook.unity.UnityCallable;
import com.facebook.unity.UnityMessage;
import com.facebook.unity.UnityParams;
import com.facebook.unity.UnityReflection;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Currency;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FB {
    static final String TAG = FB.class.getName();
    static final String FB_UNITY_OBJECT = "UnityFacebookSDKPlugin";
    private static Intent intent;
    private static Intent clearedIntent;
    private static AppEventsLogger appEventsLogger;
    private static AtomicBoolean activateAppCalled;
    static ShareDialog.Mode ShareDialogMode;

    private static AppEventsLogger getAppEventsLogger() {
        if (appEventsLogger == null) {
            appEventsLogger = AppEventsLogger.newLogger((Context)FB.getUnityActivity().getApplicationContext());
        }
        return appEventsLogger;
    }

    public static Activity getUnityActivity() {
        return UnityReflection.GetUnityActivity();
    }

    @UnityCallable
    public static void Init(String params_str) {
        Log.v((String)TAG, (String)("Init(" + params_str + ")"));
        UnityParams unity_params = UnityParams.parse(params_str, "couldn't parse init params: " + params_str);
        final String appID = unity_params.hasString("appId") != false ? unity_params.getString("appId") : Utility.getMetadataApplicationId((Context)FB.getUnityActivity());
        FacebookSdk.setApplicationId((String)appID);
        FacebookSdk.sdkInitialize((Context)FB.getUnityActivity(), (FacebookSdk.InitializeCallback)new FacebookSdk.InitializeCallback(){

            public void onInitialized() {
                UnityMessage unityMessage = new UnityMessage("OnInitComplete");
                AccessToken token = AccessToken.getCurrentAccessToken();
                if (token != null) {
                    FBLogin.addLoginParametersToMessage(unityMessage, token, null);
                } else {
                    unityMessage.put("key_hash", (Serializable)((Object)FB.getKeyHash()));
                }
                if (FacebookSdk.getAutoLogAppEventsEnabled()) {
                    FB.ActivateApp(appID);
                }
                unityMessage.send();
            }
        });
    }

    @UnityCallable
    public static void LoginWithReadPermissions(String params_str) {
        Log.v((String)TAG, (String)("LoginWithReadPermissions(" + params_str + ")"));
        Intent intent = new Intent((Context)FB.getUnityActivity(), FBUnityLoginActivity.class);
        intent.putExtra("login_params", params_str);
        intent.putExtra("login_type", (Serializable)((Object)FBUnityLoginActivity.LoginType.READ));
        FB.getUnityActivity().startActivity(intent);
    }

    @UnityCallable
    public static void LoginWithPublishPermissions(String params_str) {
        Log.v((String)TAG, (String)("LoginWithPublishPermissions(" + params_str + ")"));
        Intent intent = new Intent((Context)FB.getUnityActivity(), FBUnityLoginActivity.class);
        intent.putExtra("login_params", params_str);
        intent.putExtra("login_type", (Serializable)((Object)FBUnityLoginActivity.LoginType.PUBLISH));
        FB.getUnityActivity().startActivity(intent);
    }

    @UnityCallable
    public static void Logout(String params_str) {
        Log.v((String)TAG, (String)("Logout(" + params_str + ")"));
        LoginManager.getInstance().logOut();
        UnityMessage message = new UnityMessage("OnLogoutComplete");
        message.put("did_complete", Boolean.valueOf(true));
        message.send();
    }

    @UnityCallable
    public static void RetrieveLoginStatus(String params_str) {
        Log.v((String)TAG, (String)("RetrieveLoginStatus(" + params_str + ")"));
        if (!FacebookSdk.isInitialized()) {
            Log.w((String)TAG, (String)"Facebook SDK not initialized. Call init() before calling login()");
            return;
        }
        final UnityMessage unityMessage = new UnityMessage("OnLoginStatusRetrieved");
        unityMessage.put("key_hash", (Serializable)((Object)FB.getKeyHash()));
        UnityParams unity_params = UnityParams.parse(params_str, "couldn't parse login params: " + params_str);
        String callbackIDString = null;
        if (unity_params.has("callback_id")) {
            callbackIDString = unity_params.getString("callback_id");
            unityMessage.put("callback_id", (Serializable)((Object)callbackIDString));
        }
        final String callbackID = callbackIDString;
        LoginManager.getInstance().retrieveLoginStatus((Context)FB.getUnityActivity(), new LoginStatusCallback(){

            public void onCompleted(AccessToken accessToken) {
                FBLogin.addLoginParametersToMessage(unityMessage, accessToken, callbackID);
                unityMessage.send();
            }

            public void onFailure() {
                unityMessage.put("failed", Boolean.valueOf(true));
                unityMessage.send();
            }

            public void onError(Exception exception) {
                unityMessage.sendError(exception.getMessage());
            }
        });
    }

    @UnityCallable
    public static void loginForTVWithReadPermissions(String params_str) {
        Log.v((String)TAG, (String)("loginForTVWithReadPermissions(" + params_str + ")"));
        Intent intent = new Intent((Context)FB.getUnityActivity(), FBUnityLoginActivity.class);
        intent.putExtra("login_params", params_str);
        intent.putExtra("login_type", (Serializable)((Object)FBUnityLoginActivity.LoginType.TV_READ));
        FB.getUnityActivity().startActivity(intent);
    }

    @UnityCallable
    public static void LoginForTVWithPublishPermissions(String params_str) {
        Log.v((String)TAG, (String)("LoginForTVWithPublishPermissions(" + params_str + ")"));
        Intent intent = new Intent((Context)FB.getUnityActivity(), FBUnityLoginActivity.class);
        intent.putExtra("login_params", params_str);
        intent.putExtra("login_type", (Serializable)((Object)FBUnityLoginActivity.LoginType.TV_PUBLISH));
        FB.getUnityActivity().startActivity(intent);
    }

    @UnityCallable
    public static void AppRequest(String params_str) {
        Log.v((String)TAG, (String)("AppRequest(" + params_str + ")"));
        Intent intent = new Intent((Context)FB.getUnityActivity(), FBUnityGameRequestActivity.class);
        UnityParams unity_params = UnityParams.parse(params_str);
        Bundle params = unity_params.getStringParams();
        intent.putExtra("game_request_params", params);
        FB.getUnityActivity().startActivity(intent);
    }

    @UnityCallable
    public static void GameGroupCreate(String params_str) {
        Log.v((String)TAG, (String)("GameGroupCreate(" + params_str + ")"));
        UnityParams unity_params = UnityParams.parse(params_str);
        Bundle params = unity_params.getStringParams();
        Intent intent = new Intent((Context)FB.getUnityActivity(), FBUnityCreateGameGroupActivity.class);
        intent.putExtra(FBUnityCreateGameGroupActivity.CREATE_GAME_GROUP_PARAMS, params);
        FB.getUnityActivity().startActivity(intent);
    }

    @UnityCallable
    public static void GameGroupJoin(String params_str) {
        Log.v((String)TAG, (String)("GameGroupJoin(" + params_str + ")"));
        UnityParams unity_params = UnityParams.parse(params_str);
        Bundle params = unity_params.getStringParams();
        Intent intent = new Intent((Context)FB.getUnityActivity(), FBUnityJoinGameGroupActivity.class);
        intent.putExtra(FBUnityJoinGameGroupActivity.JOIN_GAME_GROUP_PARAMS, params);
        FB.getUnityActivity().startActivity(intent);
    }

    @UnityCallable
    public static void ShareLink(String params_str) {
        Log.v((String)TAG, (String)("ShareLink(" + params_str + ")"));
        UnityParams unity_params = UnityParams.parse(params_str);
        Bundle params = unity_params.getStringParams();
        Intent intent = new Intent((Context)FB.getUnityActivity(), FBUnityDialogsActivity.class);
        intent.putExtra("dialog_type", (Serializable)ShareDialogMode);
        intent.putExtra("share_dialog_params", params);
        FB.getUnityActivity().startActivity(intent);
    }

    @UnityCallable
    public static void FeedShare(String params_str) {
        Log.v((String)TAG, (String)("FeedShare(" + params_str + ")"));
        UnityParams unityParams = UnityParams.parse(params_str);
        Bundle params = unityParams.getStringParams();
        Intent intent = new Intent((Context)FB.getUnityActivity(), FBUnityDialogsActivity.class);
        intent.putExtra("dialog_type", (Serializable)ShareDialog.Mode.FEED);
        intent.putExtra("feed_dialog_params", params);
        FB.getUnityActivity().startActivity(intent);
    }

    @UnityCallable
    public static void SetUserID(String params_str) {
        Log.v((String)TAG, (String)("SetUserID(" + params_str + ")"));
        AppEventsLogger.setUserID((String)params_str);
    }

    @UnityCallable
    public static String GetUserID() {
        if (!FacebookSdk.isInitialized()) {
            return null;
        }
        return AppEventsLogger.getUserID();
    }

    @UnityCallable
    public static void UpdateUserProperties(String params_str) {
        Log.v((String)TAG, (String)("UpdateUserProperties(" + params_str + ")"));
        UnityParams unityParams = UnityParams.parse(params_str);
        Bundle params = unityParams.getStringParams();
        AppEventsLogger.updateUserProperties((Bundle)params, null);
    }

    @UnityCallable
    public static void SetDataProcessingOptions(String params_str) {
        Log.v((String)TAG, (String)("SetDataProcessingOptions(" + params_str + ")"));
        UnityParams unityParams = UnityParams.parse(params_str);
        try {
            JSONObject json = unityParams.json;
            JSONArray array = json.getJSONArray("options");
            int country = json.optInt("country", 0);
            int state = json.optInt("state", 0);
            String[] options = new String[array.length()];
            for (int i = 0; i < array.length(); ++i) {
                options[i] = array.getString(i);
            }
            FacebookSdk.setDataProcessingOptions((String[])options, (int)country, (int)state);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void SetIntent(Intent intent) {
        FB.intent = intent;
    }

    public static void SetLimitEventUsage(String params_str) {
        Log.v((String)TAG, (String)("SetLimitEventUsage(" + params_str + ")"));
        FacebookSdk.setLimitEventAndDataUsage((Context)FB.getUnityActivity().getApplicationContext(), (boolean)Boolean.valueOf(params_str));
    }

    @UnityCallable
    public static void LogAppEvent(String params_str) {
        Log.v((String)TAG, (String)("LogAppEvent(" + params_str + ")"));
        UnityParams unity_params = UnityParams.parse(params_str);
        Bundle parameters = new Bundle();
        if (unity_params.has("parameters")) {
            UnityParams unity_params_parameter = unity_params.getParamsObject("parameters");
            parameters = unity_params_parameter.getStringParams();
        }
        if (unity_params.has("logPurchase")) {
            FB.getAppEventsLogger().logPurchase(new BigDecimal(unity_params.getDouble("logPurchase")), Currency.getInstance(unity_params.getString("currency")), parameters);
        } else if (unity_params.hasString("logEvent").booleanValue()) {
            if (unity_params.has("valueToSum")) {
                FB.getAppEventsLogger().logEvent(unity_params.getString("logEvent"), unity_params.getDouble("valueToSum"), parameters);
            } else {
                FB.getAppEventsLogger().logEvent(unity_params.getString("logEvent"), parameters);
            }
        } else {
            Log.e((String)TAG, (String)("couldn't logPurchase or logEvent params: " + params_str));
        }
    }

    @UnityCallable
    public static boolean IsImplicitPurchaseLoggingEnabled() {
        return AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled();
    }

    @UnityCallable
    public static void SetShareDialogMode(String mode) {
        Log.v((String)TAG, (String)("SetShareDialogMode(" + mode + ")"));
        ShareDialogMode = mode.equalsIgnoreCase("NATIVE") ? ShareDialog.Mode.NATIVE : (mode.equalsIgnoreCase("WEB") ? ShareDialog.Mode.WEB : (mode.equalsIgnoreCase("FEED") ? ShareDialog.Mode.FEED : ShareDialog.Mode.AUTOMATIC));
    }

    @UnityCallable
    public static void SetAutoLogAppEventsEnabled(String autoLogAppEventsEnabled) {
        Log.v((String)TAG, (String)("SetAutoLogAppEventsEnabled(" + autoLogAppEventsEnabled + ")"));
        FacebookSdk.setAutoLogAppEventsEnabled((boolean)Boolean.valueOf(autoLogAppEventsEnabled));
    }

    @UnityCallable
    public static void SetAdvertiserIDCollectionEnabled(String advertiserIDCollectionEnabled) {
        Log.v((String)TAG, (String)("SetAdvertiserIDCollectionEnabled(" + advertiserIDCollectionEnabled + ")"));
        FacebookSdk.setAdvertiserIDCollectionEnabled((boolean)Boolean.valueOf(advertiserIDCollectionEnabled));
    }

    @UnityCallable
    public static String GetSdkVersion() {
        return FacebookSdk.getSdkVersion();
    }

    @UnityCallable
    public static void SetUserAgentSuffix(String suffix) {
        Log.v((String)TAG, (String)("SetUserAgentSuffix(" + suffix + ")"));
        InternalSettings.setCustomUserAgent((String)suffix);
    }

    @UnityCallable
    public static void FetchDeferredAppLinkData(String paramsStr) {
        FB.LogMethodCall("FetchDeferredAppLinkData", paramsStr);
        UnityParams unityParams = UnityParams.parse(paramsStr);
        final UnityMessage unityMessage = new UnityMessage("OnFetchDeferredAppLinkComplete");
        if (unityParams.hasString("callback_id").booleanValue()) {
            unityMessage.put("callback_id", (Serializable)((Object)unityParams.getString("callback_id")));
        }
        AppLinkData.fetchDeferredAppLinkData((Context)FB.getUnityActivity(), (AppLinkData.CompletionHandler)new AppLinkData.CompletionHandler(){

            public void onDeferredAppLinkDataFetched(AppLinkData appLinkData) {
                FB.addAppLinkToMessage(unityMessage, appLinkData);
                unityMessage.send();
            }
        });
    }

    @UnityCallable
    public static void GetAppLink(String paramsStr) {
        Log.v((String)TAG, (String)("GetAppLink(" + paramsStr + ")"));
        UnityParams unityParams = UnityParams.parse(paramsStr);
        UnityMessage unityMessage = UnityMessage.createWithCallbackFromParams("OnGetAppLinkComplete", unityParams);
        if (intent == null) {
            unityMessage.put("did_complete", Boolean.valueOf(true));
            unityMessage.send();
            return;
        }
        if (intent == clearedIntent) {
            unityMessage.put("did_complete", Boolean.valueOf(true));
            unityMessage.send();
            return;
        }
        AppLinkData appLinkData = AppLinkData.createFromAlApplinkData((Intent)intent);
        if (appLinkData != null) {
            FB.addAppLinkToMessage(unityMessage, appLinkData);
            unityMessage.put("url", (Serializable)((Object)intent.getDataString()));
        } else if (intent.getData() != null) {
            unityMessage.put("url", (Serializable)((Object)intent.getDataString()));
        } else {
            unityMessage.put("did_complete", Boolean.valueOf(true));
        }
        unityMessage.send();
    }

    @UnityCallable
    public static void ClearAppLink() {
        Log.v((String)TAG, (String)"ClearAppLink");
        clearedIntent = intent;
    }

    @UnityCallable
    public static void RefreshCurrentAccessToken(String paramsStr) {
        FB.LogMethodCall("RefreshCurrentAccessToken", paramsStr);
        UnityParams unityParams = UnityParams.parse(paramsStr);
        final UnityMessage unityMessage = new UnityMessage("OnRefreshCurrentAccessTokenComplete");
        if (unityParams.hasString("callback_id").booleanValue()) {
            unityMessage.put("callback_id", (Serializable)((Object)unityParams.getString("callback_id")));
        }
        AccessToken.refreshCurrentAccessTokenAsync((AccessToken.AccessTokenRefreshCallback)new AccessToken.AccessTokenRefreshCallback(){

            public void OnTokenRefreshed(AccessToken accessToken) {
                FBLogin.addLoginParametersToMessage(unityMessage, accessToken, null);
                unityMessage.send();
            }

            public void OnTokenRefreshFailed(FacebookException e) {
                unityMessage.sendError(e.getMessage());
            }
        });
    }

    @TargetApi(value=8)
    public static String getKeyHash() {
        try {
            Activity activity = FB.getUnityActivity();
            if (activity == null) {
                return "";
            }
            PackageInfo info = activity.getPackageManager().getPackageInfo(activity.getPackageName(), 64);
            int n = 0;
            Signature[] signatureArray = info.signatures;
            int n2 = signatureArray.length;
            if (n < n2) {
                Signature signature = signatureArray[n];
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                String keyHash = Base64.encodeToString((byte[])md.digest(), (int)0);
                Log.d((String)TAG, (String)("KeyHash: " + keyHash));
                return keyHash;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return "";
    }

    @UnityCallable
    public static void ActivateApp() {
        AppEventsLogger.activateApp((Context)FB.getUnityActivity());
    }

    @UnityCallable
    public static void OpenFriendFinderDialog(String params_str) {
        Log.v((String)TAG, (String)("OpenFriendFinderDialog(" + params_str + ")"));
        UnityParams unity_params = UnityParams.parse(params_str);
        Bundle params = unity_params.getStringParams();
        Intent intent = new Intent((Context)FB.getUnityActivity(), FBUnityGamingServicesFriendFinderActivity.class);
        intent.putExtra("dialog_params", params);
        FB.getUnityActivity().startActivity(intent);
    }

    @UnityCallable
    public static void UploadImageToMediaLibrary(String params_str) {
        Log.v((String)TAG, (String)("UploadImageToMediaLibrary(" + params_str + ")"));
        UnityParams unityParams = UnityParams.parse(params_str);
        String caption = unityParams.getString("caption");
        Uri imageUri = Uri.parse((String)unityParams.getString("imageUri"));
        if (imageUri.getScheme() == null) {
            imageUri = imageUri.buildUpon().scheme("file").build();
        }
        boolean shouldLaunchMediaDialog = Boolean.parseBoolean(unityParams.getString("shouldLaunchMediaDialog"));
        final UnityMessage unityMessage = new UnityMessage("OnUploadImageToMediaLibraryComplete");
        if (unityParams.hasString("callback_id").booleanValue()) {
            unityMessage.put("callback_id", (Serializable)((Object)unityParams.getString("callback_id")));
        }
        GamingImageUploader imageUploader = new GamingImageUploader((Context)FB.getUnityActivity());
        try {
            imageUploader.uploadToMediaLibrary(caption, imageUri, shouldLaunchMediaDialog, new GraphRequest.Callback(){

                public void onCompleted(GraphResponse response) {
                    if (response.getError() != null) {
                        unityMessage.sendError(response.getError().toString());
                    } else {
                        String id = response.getJSONObject().optString("id", null);
                        if (id == null) {
                            unityMessage.sendError("Response did not contain ImageID");
                        } else {
                            unityMessage.put("id", (Serializable)((Object)id));
                            unityMessage.send();
                        }
                    }
                }
            });
        }
        catch (FileNotFoundException e) {
            unityMessage.sendError(e.toString());
        }
    }

    @UnityCallable
    public static void UploadVideoToMediaLibrary(String params_str) {
        Log.v((String)TAG, (String)("UploadVideoToMediaLibrary(" + params_str + ")"));
        UnityParams unityParams = UnityParams.parse(params_str);
        String caption = unityParams.getString("caption");
        Uri videoUri = Uri.parse((String)unityParams.getString("videoUri"));
        if (videoUri.getScheme() == null) {
            videoUri = videoUri.buildUpon().scheme("file").build();
        }
        final UnityMessage unityMessage = new UnityMessage("OnUploadVideoToMediaLibraryComplete");
        if (unityParams.hasString("callback_id").booleanValue()) {
            unityMessage.put("callback_id", (Serializable)((Object)unityParams.getString("callback_id")));
        }
        GamingVideoUploader videoUploader = new GamingVideoUploader((Context)FB.getUnityActivity());
        try {
            videoUploader.uploadToMediaLibrary(caption, videoUri, new GraphRequest.OnProgressCallback(){

                public void onCompleted(GraphResponse response) {
                    if (response.getError() != null) {
                        unityMessage.sendError(response.getError().toString());
                    } else {
                        String id = response.getJSONObject().optString("video_id", null);
                        if (id == null) {
                            unityMessage.sendError("Response did not contain ImageID");
                        } else {
                            unityMessage.put("video_id", (Serializable)((Object)id));
                            unityMessage.send();
                        }
                    }
                }

                public void onProgress(long current, long total) {
                }
            });
        }
        catch (FileNotFoundException e) {
            unityMessage.sendError(e.toString());
        }
    }

    private static void ActivateApp(String appId) {
        if (!activateAppCalled.compareAndSet(false, true)) {
            Log.w((String)TAG, (String)"Activite app only needs to be called once");
            return;
        }
        final Activity unityActivity = FB.getUnityActivity();
        if (appId != null) {
            AppEventsLogger.activateApp((Application)unityActivity.getApplication(), (String)appId);
        } else {
            AppEventsLogger.activateApp((Application)unityActivity.getApplication());
        }
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                ActivityLifecycleTracker.onActivityCreated((Activity)unityActivity);
                ActivityLifecycleTracker.onActivityResumed((Activity)unityActivity);
            }
        });
    }

    private static void startActivity(Class<?> cls, String paramsStr) {
        Intent intent = new Intent((Context)FB.getUnityActivity(), cls);
        UnityParams unityParams = UnityParams.parse(paramsStr);
        Bundle params = unityParams.getStringParams();
        intent.putExtra("activity_params", params);
        FB.getUnityActivity().startActivity(intent);
    }

    private static void LogMethodCall(String methodName, String paramsStr) {
        Log.v((String)TAG, (String)String.format(Locale.ROOT, "%s(%s)", methodName, paramsStr));
    }

    private static void addAppLinkToMessage(UnityMessage unityMessage, AppLinkData appLinkData) {
        if (appLinkData == null) {
            unityMessage.put("did_complete", Boolean.valueOf(true));
            return;
        }
        unityMessage.put("ref", (Serializable)((Object)appLinkData.getRef()));
        unityMessage.put("target_url", (Serializable)((Object)appLinkData.getTargetUri().toString()));
        try {
            if (appLinkData.getArgumentBundle() != null) {
                unityMessage.put("extras", (Serializable)((Object)BundleJSONConverter.convertToJSON((Bundle)appLinkData.getArgumentBundle()).toString()));
            }
        }
        catch (JSONException ex) {
            Log.e((String)TAG, (String)ex.getLocalizedMessage());
        }
    }

    static {
        activateAppCalled = new AtomicBoolean();
        ShareDialogMode = ShareDialog.Mode.AUTOMATIC;
    }
}

