/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.unity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.share.Sharer;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.widget.ShareDialog;
import com.facebook.unity.BaseActivity;
import com.facebook.unity.FBDialogUtils;
import com.facebook.unity.UnityMessage;
import java.io.Serializable;
import java.util.Locale;

public class FBUnityDialogsActivity
extends BaseActivity {
    private static String TAG = FBUnityDialogsActivity.class.getName();
    public static final String DIALOG_TYPE = "dialog_type";
    public static final String SHARE_DIALOG_PARAMS = "share_dialog_params";
    public static final String FEED_DIALOG_PARAMS = "feed_dialog_params";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        ShareLinkContent shareContent;
        Bundle params;
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent.hasExtra(SHARE_DIALOG_PARAMS)) {
            params = intent.getBundleExtra(SHARE_DIALOG_PARAMS);
            shareContent = FBDialogUtils.createShareContentBuilder(params).build();
        } else if (intent.hasExtra(FEED_DIALOG_PARAMS)) {
            params = intent.getBundleExtra(FEED_DIALOG_PARAMS);
            shareContent = FBDialogUtils.createFeedContentBuilder(params).build();
        } else {
            Log.e((String)TAG, (String)String.format(Locale.ROOT, "Failed to find extra %s or %s", SHARE_DIALOG_PARAMS, FEED_DIALOG_PARAMS));
            this.finish();
            return;
        }
        ShareDialog dialog = new ShareDialog((Activity)this);
        final UnityMessage response = new UnityMessage("OnShareLinkComplete");
        String callbackID = params.getString("callback_id");
        if (callbackID != null) {
            response.put("callback_id", (Serializable)((Object)callbackID));
        }
        dialog.registerCallback(this.mCallbackManager, (FacebookCallback)new FacebookCallback<Sharer.Result>(){

            public void onSuccess(Sharer.Result result) {
                if (result.getPostId() != null) {
                    response.putID(result.getPostId());
                }
                response.put("posted", Boolean.valueOf(true));
                response.send();
            }

            public void onCancel() {
                response.putCancelled();
                response.send();
            }

            public void onError(FacebookException e) {
                response.sendError(e.getMessage());
            }
        });
        ShareDialog.Mode mode = (ShareDialog.Mode)this.getIntent().getSerializableExtra(DIALOG_TYPE);
        dialog.show((ShareContent)shareContent, mode);
    }
}

