/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.api;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.util.SparseArray;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.device.DeviceError;
import com.unity3d.services.core.device.IVolumeChangeListener;
import com.unity3d.services.core.device.VolumeChange;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceInfo {
    private static SparseArray<IVolumeChangeListener> _volumeChangeListeners;

    @WebViewExposed
    public static void getAndroidId(WebViewCallback callback) {
        callback.invoke(Device.getAndroidId());
    }

    @WebViewExposed
    public static void getAdvertisingTrackingId(WebViewCallback callback) {
        callback.invoke(Device.getAdvertisingTrackingId());
    }

    @WebViewExposed
    public static void getLimitAdTrackingFlag(WebViewCallback callback) {
        callback.invoke(Device.isLimitAdTrackingEnabled());
    }

    @WebViewExposed
    public static void getApiLevel(WebViewCallback callback) {
        callback.invoke(Device.getApiLevel());
    }

    @WebViewExposed
    public static void getOsVersion(WebViewCallback callback) {
        callback.invoke(Device.getOsVersion());
    }

    @WebViewExposed
    public static void getManufacturer(WebViewCallback callback) {
        callback.invoke(Device.getManufacturer());
    }

    @WebViewExposed
    public static void getModel(WebViewCallback callback) {
        callback.invoke(Device.getModel());
    }

    @WebViewExposed
    public static void getScreenLayout(WebViewCallback callback) {
        callback.invoke(Device.getScreenLayout());
    }

    @WebViewExposed
    public static void getDisplayMetricDensity(WebViewCallback callback) {
        callback.invoke(Float.valueOf(Device.getDisplayMetricDensity()));
    }

    @WebViewExposed
    public static void getScreenDensity(WebViewCallback callback) {
        callback.invoke(Device.getScreenDensity());
    }

    @WebViewExposed
    public static void getScreenWidth(WebViewCallback callback) {
        callback.invoke(Device.getScreenWidth());
    }

    @WebViewExposed
    public static void getScreenHeight(WebViewCallback callback) {
        callback.invoke(Device.getScreenHeight());
    }

    @WebViewExposed
    public static void getTimeZone(Boolean dst, WebViewCallback callback) {
        callback.invoke(TimeZone.getDefault().getDisplayName(dst, 0, Locale.US));
    }

    @WebViewExposed
    public static void getTimeZoneOffset(WebViewCallback callback) {
        callback.invoke(TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 1000);
    }

    @WebViewExposed
    public static void getConnectionType(WebViewCallback callback) {
        String connectionType = Device.isUsingWifi() ? "wifi" : (Device.isActiveNetworkConnected() ? "cellular" : "none");
        callback.invoke(connectionType);
    }

    @WebViewExposed
    public static void getNetworkType(WebViewCallback callback) {
        callback.invoke(Device.getNetworkType());
    }

    @WebViewExposed
    public static void getNetworkMetered(WebViewCallback callback) {
        callback.invoke(Device.getNetworkMetered());
    }

    @WebViewExposed
    public static void getNetworkOperator(WebViewCallback callback) {
        callback.invoke(Device.getNetworkOperator());
    }

    @WebViewExposed
    public static void getNetworkOperatorName(WebViewCallback callback) {
        callback.invoke(Device.getNetworkOperatorName());
    }

    @WebViewExposed
    public static void getNetworkCountryISO(WebViewCallback callback) {
        callback.invoke(Device.getNetworkCountryISO());
    }

    @WebViewExposed
    public static void isRooted(WebViewCallback callback) {
        callback.invoke(Device.isRooted());
    }

    @WebViewExposed
    public static void isAdbEnabled(WebViewCallback callback) {
        Boolean adbEnabled = Device.isAdbEnabled();
        if (adbEnabled != null) {
            callback.invoke(adbEnabled);
        } else {
            callback.error(DeviceError.COULDNT_GET_ADB_STATUS, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getPackageInfo(String packageName, WebViewCallback callback) {
        if (ClientProperties.getApplicationContext() != null) {
            PackageInfo appInfo;
            PackageManager pm = ClientProperties.getApplicationContext().getPackageManager();
            try {
                appInfo = pm.getPackageInfo(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                callback.error(DeviceError.APPLICATION_INFO_NOT_AVAILABLE, packageName);
                return;
            }
            JSONObject data = new JSONObject();
            try {
                data.put("installer", (Object)pm.getInstallerPackageName(packageName));
                data.put("firstInstallTime", appInfo.firstInstallTime);
                data.put("lastUpdateTime", appInfo.lastUpdateTime);
                data.put("versionCode", appInfo.versionCode);
                data.put("versionName", (Object)appInfo.versionName);
                data.put("packageName", (Object)appInfo.packageName);
            }
            catch (JSONException e) {
                callback.error(DeviceError.JSON_ERROR, e.getMessage());
                return;
            }
            callback.invoke(data);
        } else {
            callback.error(DeviceError.APPLICATION_CONTEXT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getUniqueEventId(WebViewCallback callback) {
        callback.invoke(Device.getUniqueEventId());
    }

    @WebViewExposed
    public static void getHeadset(WebViewCallback callback) {
        callback.invoke(Device.isWiredHeadsetOn());
    }

    @WebViewExposed
    public static void getSystemProperty(String propertyName, String defaultValue, WebViewCallback callback) {
        callback.invoke(Device.getSystemProperty(propertyName, defaultValue));
    }

    @WebViewExposed
    public static void getRingerMode(WebViewCallback callback) {
        int ringerMode = Device.getRingerMode();
        if (ringerMode > -1) {
            callback.invoke(ringerMode);
        } else {
            switch (ringerMode) {
                case -1: {
                    callback.error(DeviceError.APPLICATION_CONTEXT_NULL, ringerMode);
                    break;
                }
                case -2: {
                    callback.error(DeviceError.AUDIOMANAGER_NULL, ringerMode);
                    break;
                }
                default: {
                    DeviceLog.error("Unhandled ringerMode error: " + ringerMode);
                }
            }
        }
    }

    @WebViewExposed
    public static void getSystemLanguage(WebViewCallback callback) {
        callback.invoke(Locale.getDefault().toString());
    }

    @WebViewExposed
    public static void getDeviceVolume(Integer streamType, WebViewCallback callback) {
        int volume = Device.getStreamVolume(streamType);
        if (volume > -1) {
            callback.invoke(volume);
        } else {
            switch (volume) {
                case -1: {
                    callback.error(DeviceError.APPLICATION_CONTEXT_NULL, volume);
                    break;
                }
                case -2: {
                    callback.error(DeviceError.AUDIOMANAGER_NULL, volume);
                    break;
                }
                default: {
                    DeviceLog.error("Unhandled deviceVolume error: " + volume);
                }
            }
        }
    }

    @WebViewExposed
    public static void getDeviceMaxVolume(Integer streamType, WebViewCallback callback) {
        int maxVolume = Device.getStreamMaxVolume(streamType);
        if (maxVolume > -1) {
            callback.invoke(maxVolume);
        } else {
            switch (maxVolume) {
                case -1: {
                    callback.error(DeviceError.APPLICATION_CONTEXT_NULL, maxVolume);
                    break;
                }
                case -2: {
                    callback.error(DeviceError.AUDIOMANAGER_NULL, maxVolume);
                    break;
                }
                default: {
                    DeviceLog.error("Unhandled deviceMaxVolume error: " + maxVolume);
                }
            }
        }
    }

    @WebViewExposed
    public static void registerVolumeChangeListener(final Integer streamType, WebViewCallback callback) {
        if (_volumeChangeListeners == null) {
            _volumeChangeListeners = new SparseArray();
        }
        if (_volumeChangeListeners.get(streamType.intValue()) == null) {
            IVolumeChangeListener listener = new IVolumeChangeListener(){
                private int _streamType;
                {
                    this._streamType = streamType;
                }

                @Override
                public void onVolumeChanged(int volume) {
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.DEVICEINFO, DeviceInfoEvent.VOLUME_CHANGED, this.getStreamType(), volume, Device.getStreamMaxVolume(this._streamType));
                }

                @Override
                public int getStreamType() {
                    return this._streamType;
                }
            };
            _volumeChangeListeners.append(streamType.intValue(), (Object)listener);
            VolumeChange.registerListener(listener);
        }
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void unregisterVolumeChangeListener(Integer streamType, WebViewCallback callback) {
        if (_volumeChangeListeners != null && _volumeChangeListeners.get(streamType.intValue()) != null) {
            IVolumeChangeListener listener = (IVolumeChangeListener)_volumeChangeListeners.get(streamType.intValue());
            VolumeChange.unregisterListener(listener);
            _volumeChangeListeners.remove(streamType.intValue());
        }
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getScreenBrightness(WebViewCallback callback) {
        int screenBrightness = Device.getScreenBrightness();
        if (screenBrightness > -1) {
            callback.invoke(screenBrightness);
        } else {
            switch (screenBrightness) {
                case -1: {
                    callback.error(DeviceError.APPLICATION_CONTEXT_NULL, screenBrightness);
                    break;
                }
                default: {
                    DeviceLog.error("Unhandled screenBrightness error: " + screenBrightness);
                }
            }
        }
    }

    private static StorageType getStorageTypeFromString(String storageType) {
        StorageType storage;
        try {
            storage = StorageType.valueOf(storageType);
        }
        catch (IllegalArgumentException e) {
            DeviceLog.exception("Illegal argument: " + storageType, e);
            return null;
        }
        return storage;
    }

    private static File getFileForStorageType(StorageType storageType) {
        switch (storageType) {
            case INTERNAL: {
                return ClientProperties.getApplicationContext().getCacheDir();
            }
            case EXTERNAL: {
                return ClientProperties.getApplicationContext().getExternalCacheDir();
            }
        }
        DeviceLog.error("Unhandled storagetype: " + (Object)((Object)storageType));
        return null;
    }

    @WebViewExposed
    public static void getFreeSpace(String storageType, WebViewCallback callback) {
        StorageType storage = DeviceInfo.getStorageTypeFromString(storageType);
        if (storage == null) {
            callback.error(DeviceError.INVALID_STORAGETYPE, storageType);
            return;
        }
        long space = Device.getFreeSpace(DeviceInfo.getFileForStorageType(storage));
        if (space > -1L) {
            callback.invoke(space);
        } else {
            callback.error(DeviceError.COULDNT_GET_STORAGE_LOCATION, space);
        }
    }

    @WebViewExposed
    public static void getTotalSpace(String storageType, WebViewCallback callback) {
        StorageType storage = DeviceInfo.getStorageTypeFromString(storageType);
        if (storage == null) {
            callback.error(DeviceError.INVALID_STORAGETYPE, storageType);
            return;
        }
        long space = Device.getTotalSpace(DeviceInfo.getFileForStorageType(storage));
        if (space > -1L) {
            callback.invoke(space);
        } else {
            callback.error(DeviceError.COULDNT_GET_STORAGE_LOCATION, space);
        }
    }

    @WebViewExposed
    public static void getBatteryLevel(WebViewCallback callback) {
        callback.invoke(Float.valueOf(Device.getBatteryLevel()));
    }

    @WebViewExposed
    public static void getBatteryStatus(WebViewCallback callback) {
        callback.invoke(Device.getBatteryStatus());
    }

    @WebViewExposed
    public static void getFreeMemory(WebViewCallback callback) {
        callback.invoke(Device.getFreeMemory());
    }

    @WebViewExposed
    public static void getTotalMemory(WebViewCallback callback) {
        callback.invoke(Device.getTotalMemory());
    }

    @WebViewExposed
    public static void getGLVersion(WebViewCallback callback) {
        String glVersion = Device.getGLVersion();
        if (glVersion != null) {
            callback.invoke(glVersion);
        } else {
            callback.error(DeviceError.COULDNT_GET_GL_VERSION, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getApkDigest(WebViewCallback callback) {
        try {
            callback.invoke(Device.getApkDigest());
        }
        catch (Exception e) {
            callback.error(DeviceError.COULDNT_GET_DIGEST, e.toString());
        }
    }

    @WebViewExposed
    public static void getCertificateFingerprint(WebViewCallback callback) {
        String fingerprint = Device.getCertificateFingerprint();
        if (fingerprint != null) {
            callback.invoke(fingerprint);
        } else {
            callback.error(DeviceError.COULDNT_GET_FINGERPRINT, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getBoard(WebViewCallback callback) {
        callback.invoke(Device.getBoard());
    }

    @WebViewExposed
    public static void getBootloader(WebViewCallback callback) {
        callback.invoke(Device.getBootloader());
    }

    @WebViewExposed
    public static void getBrand(WebViewCallback callback) {
        callback.invoke(Device.getBrand());
    }

    @WebViewExposed
    public static void getDevice(WebViewCallback callback) {
        callback.invoke(Device.getDevice());
    }

    @WebViewExposed
    public static void getHardware(WebViewCallback callback) {
        callback.invoke(Device.getHardware());
    }

    @WebViewExposed
    public static void getHost(WebViewCallback callback) {
        callback.invoke(Device.getHost());
    }

    @WebViewExposed
    public static void getProduct(WebViewCallback callback) {
        callback.invoke(Device.getProduct());
    }

    @WebViewExposed
    public static void getFingerprint(WebViewCallback callback) {
        callback.invoke(Device.getFingerprint());
    }

    @WebViewExposed
    public static void getSupportedAbis(WebViewCallback callback) {
        JSONArray abis = new JSONArray();
        for (String abi : Device.getSupportedAbis()) {
            abis.put((Object)abi);
        }
        callback.invoke(abis);
    }

    @WebViewExposed
    public static void getSensorList(WebViewCallback callback) {
        JSONArray sensors = new JSONArray();
        List<Sensor> sensorList = Device.getSensorList();
        if (sensorList != null) {
            for (Sensor sensor : sensorList) {
                JSONObject sensorInfo = new JSONObject();
                try {
                    sensorInfo.put("name", (Object)sensor.getName());
                    sensorInfo.put("type", sensor.getType());
                    sensorInfo.put("vendor", (Object)sensor.getVendor());
                    sensorInfo.put("maximumRange", (double)sensor.getMaximumRange());
                    sensorInfo.put("power", (double)sensor.getPower());
                    sensorInfo.put("version", sensor.getVersion());
                    sensorInfo.put("resolution", (double)sensor.getResolution());
                    sensorInfo.put("minDelay", sensor.getMinDelay());
                }
                catch (JSONException e) {
                    callback.error(DeviceError.JSON_ERROR, e.getMessage());
                    return;
                }
                sensors.put((Object)sensorInfo);
            }
        }
        callback.invoke(sensors);
    }

    @WebViewExposed
    public static void getProcessInfo(WebViewCallback callback) {
        JSONObject retObj = new JSONObject();
        Map<String, String> processInfo = Device.getProcessInfo();
        if (processInfo != null) {
            try {
                if (processInfo.containsKey("stat")) {
                    retObj.put("stat", (Object)processInfo.get("stat"));
                }
                if (processInfo.containsKey("uptime")) {
                    retObj.put("uptime", (Object)processInfo.get("uptime"));
                }
            }
            catch (Exception e) {
                DeviceLog.exception("Error while constructing process info", e);
            }
        }
        callback.invoke(retObj);
    }

    @WebViewExposed
    public static void isUSBConnected(WebViewCallback callback) {
        callback.invoke(Device.isUSBConnected());
    }

    @WebViewExposed
    public static void getCPUCount(WebViewCallback callback) {
        callback.invoke(Device.getCPUCount());
    }

    @WebViewExposed
    public static void getUptime(WebViewCallback callback) {
        callback.invoke(Device.getUptime());
    }

    @WebViewExposed
    public static void getElapsedRealtime(WebViewCallback callback) {
        callback.invoke(Device.getElapsedRealtime());
    }

    @WebViewExposed
    public static void getBuildId(WebViewCallback callback) {
        callback.invoke(Device.getBuildId());
    }

    @WebViewExposed
    public static void getBuildVersionIncremental(WebViewCallback callback) {
        callback.invoke(Device.getBuildVersionIncremental());
    }

    public static enum DeviceInfoEvent {
        VOLUME_CHANGED;

    }

    public static enum StorageType {
        EXTERNAL,
        INTERNAL;

    }
}

