/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.IModuleConfiguration;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.WebRequest;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class Configuration {
    private String _webViewUrl;
    private String _webViewHash;
    private String _webViewVersion;
    private String _webViewData;
    private String _url;
    private Map<String, IModuleConfiguration> _moduleConfigurations;
    private String[] _moduleConfigurationList = new String[]{"com.unity3d.services.core.configuration.CoreModuleConfiguration", "com.unity3d.services.ads.configuration.AdsModuleConfiguration", "com.unity3d.services.monetization.core.configuration.MonetizationModuleConfiguration", "com.unity3d.services.purchasing.core.configuration.PurchasingModuleConfiguration", "com.unity3d.services.analytics.core.configuration.AnalyticsModuleConfiguration", "com.unity3d.services.ar.configuration.ARModuleConfiguration", "com.unity3d.services.banners.configuration.BannersModuleConfiguration", "com.unity3d.services.store.core.configuration.StoreModuleConfiguration"};
    private Class[] _webAppApiClassList;

    public Configuration() {
    }

    public Configuration(String configUrl) {
        this._url = configUrl;
    }

    public void setConfigUrl(String url) {
        this._url = url;
    }

    public String getConfigUrl() {
        return this._url;
    }

    public Class[] getWebAppApiClassList() {
        if (this._webAppApiClassList == null) {
            this.createWebAppApiClassList();
        }
        return this._webAppApiClassList;
    }

    public String[] getModuleConfigurationList() {
        return this._moduleConfigurationList;
    }

    public String getWebViewUrl() {
        return this._webViewUrl;
    }

    public void setWebViewUrl(String url) {
        this._webViewUrl = url;
    }

    public String getWebViewHash() {
        return this._webViewHash;
    }

    public void setWebViewHash(String hash) {
        this._webViewHash = hash;
    }

    public String getWebViewVersion() {
        return this._webViewVersion;
    }

    public String getWebViewData() {
        return this._webViewData;
    }

    public void setWebViewData(String data) {
        this._webViewData = data;
    }

    public IModuleConfiguration getModuleConfiguration(String moduleName) {
        if (this._moduleConfigurations != null && this._moduleConfigurations.containsKey(moduleName)) {
            return this._moduleConfigurations.get(moduleName);
        }
        try {
            IModuleConfiguration module = (IModuleConfiguration)Class.forName(moduleName).newInstance();
            if (module != null) {
                if (this._moduleConfigurations == null) {
                    this._moduleConfigurations = new HashMap<String, IModuleConfiguration>();
                    this._moduleConfigurations.put(moduleName, module);
                }
                return module;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String buildQueryString() {
        String queryString = "?ts=" + System.currentTimeMillis() + "&sdkVersion=" + SdkProperties.getVersionCode() + "&sdkVersionName=" + SdkProperties.getVersionName();
        return queryString;
    }

    protected void makeRequest() throws Exception {
        if (this._url == null) {
            throw new MalformedURLException("Base URL is null");
        }
        String url = this._url + this.buildQueryString();
        DeviceLog.debug("Requesting configuration with: " + url);
        WebRequest request = new WebRequest(url, "GET", null);
        String data = request.makeRequest();
        JSONObject config = new JSONObject(data);
        this._webViewUrl = config.getString("url");
        this._webViewHash = !config.isNull("hash") ? config.getString("hash") : null;
        this._webViewVersion = config.has("version") ? config.getString("version") : null;
        if (this._webViewUrl == null || this._webViewUrl.isEmpty()) {
            throw new MalformedURLException("Invalid data. Web view URL is null or empty");
        }
    }

    private void createWebAppApiClassList() {
        ArrayList<Class> apiList = new ArrayList<Class>();
        for (String moduleConfigClass : this.getModuleConfigurationList()) {
            IModuleConfiguration moduleConfiguration = this.getModuleConfiguration(moduleConfigClass);
            if (moduleConfiguration == null || moduleConfiguration.getWebAppApiClassList() == null) continue;
            apiList.addAll(Arrays.asList(moduleConfiguration.getWebAppApiClassList()));
        }
        this._webAppApiClassList = apiList.toArray(new Class[apiList.size()]);
    }
}

