/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.connectivity;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.unity3d.services.core.connectivity.ConnectivityChangeReceiver;
import com.unity3d.services.core.connectivity.ConnectivityEvent;
import com.unity3d.services.core.connectivity.ConnectivityNetworkCallback;
import com.unity3d.services.core.connectivity.IConnectivityListener;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.HashSet;

public class ConnectivityMonitor {
    private static int _connected = -1;
    private static boolean _listening = false;
    private static boolean _webappMonitoring = false;
    private static boolean _wifi = false;
    private static int _networkType = -1;
    private static HashSet<IConnectivityListener> _listeners = null;

    public static void setConnectionMonitoring(boolean monitoring) {
        _webappMonitoring = monitoring;
        ConnectivityMonitor.updateListeningStatus();
    }

    public static void addListener(IConnectivityListener listener) {
        if (_listeners == null) {
            _listeners = new HashSet();
        }
        _listeners.add(listener);
        ConnectivityMonitor.updateListeningStatus();
    }

    public static void removeListener(IConnectivityListener listener) {
        if (_listeners == null) {
            return;
        }
        _listeners.remove(listener);
        ConnectivityMonitor.updateListeningStatus();
    }

    public static void stopAll() {
        _listeners = null;
        _webappMonitoring = false;
        ConnectivityMonitor.updateListeningStatus();
    }

    private static void updateListeningStatus() {
        if (_webappMonitoring || _listeners != null && !_listeners.isEmpty()) {
            ConnectivityMonitor.startListening();
        } else {
            ConnectivityMonitor.stopListening();
        }
    }

    private static void startListening() {
        if (_listening) {
            return;
        }
        _listening = true;
        ConnectivityMonitor.initConnectionStatus();
        if (Build.VERSION.SDK_INT < 21) {
            ConnectivityChangeReceiver.register();
        } else {
            ConnectivityNetworkCallback.register();
        }
    }

    private static void stopListening() {
        if (!_listening) {
            return;
        }
        _listening = false;
        if (Build.VERSION.SDK_INT < 21) {
            ConnectivityChangeReceiver.unregister();
        } else {
            ConnectivityNetworkCallback.unregister();
        }
    }

    private static void initConnectionStatus() {
        ConnectivityManager cm = (ConnectivityManager)ClientProperties.getApplicationContext().getSystemService("connectivity");
        if (cm == null) {
            return;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        if (ni != null && ni.isConnected()) {
            _connected = 1;
            boolean bl = _wifi = ni.getType() == 1;
            if (!_wifi) {
                TelephonyManager tm = (TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone");
                _networkType = tm.getNetworkType();
            }
        } else {
            _connected = 0;
        }
    }

    public static void connected() {
        if (_connected == 1) {
            return;
        }
        DeviceLog.debug("Unity Ads connectivity change: connected");
        ConnectivityMonitor.initConnectionStatus();
        if (_listeners != null) {
            for (IConnectivityListener listener : _listeners) {
                listener.onConnected();
            }
        }
        ConnectivityMonitor.sendToWebview(ConnectivityEvent.CONNECTED, _wifi, _networkType);
    }

    public static void disconnected() {
        if (_connected == 0) {
            return;
        }
        _connected = 0;
        DeviceLog.debug("Unity Ads connectivity change: disconnected");
        if (_listeners != null) {
            for (IConnectivityListener listener : _listeners) {
                listener.onDisconnected();
            }
        }
        ConnectivityMonitor.sendToWebview(ConnectivityEvent.DISCONNECTED, false, 0);
    }

    public static void connectionStatusChanged() {
        if (_connected != 1) {
            return;
        }
        ConnectivityManager cm = (ConnectivityManager)ClientProperties.getApplicationContext().getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        if (ni != null && ni.isConnected()) {
            boolean wifiStatus = ni.getType() == 1;
            TelephonyManager tm = (TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone");
            int mobileNetworkType = tm.getNetworkType();
            if (wifiStatus == _wifi && (mobileNetworkType == _networkType || _wifi)) {
                return;
            }
            _wifi = wifiStatus;
            _networkType = mobileNetworkType;
            DeviceLog.debug("Unity Ads connectivity change: network change");
            ConnectivityMonitor.sendToWebview(ConnectivityEvent.NETWORK_CHANGE, wifiStatus, mobileNetworkType);
        }
    }

    private static void sendToWebview(ConnectivityEvent eventType, boolean wifi, int networkType) {
        if (!_webappMonitoring) {
            return;
        }
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp == null || !webViewApp.isWebAppLoaded()) {
            return;
        }
        switch (eventType) {
            case CONNECTED: {
                if (wifi) {
                    webViewApp.sendEvent(WebViewEventCategory.CONNECTIVITY, ConnectivityEvent.CONNECTED, wifi, 0);
                    break;
                }
                webViewApp.sendEvent(WebViewEventCategory.CONNECTIVITY, ConnectivityEvent.CONNECTED, wifi, networkType);
                break;
            }
            case DISCONNECTED: {
                webViewApp.sendEvent(WebViewEventCategory.CONNECTIVITY, ConnectivityEvent.DISCONNECTED, new Object[0]);
                break;
            }
            case NETWORK_CHANGE: {
                if (wifi) {
                    webViewApp.sendEvent(WebViewEventCategory.CONNECTIVITY, ConnectivityEvent.NETWORK_CHANGE, wifi, 0);
                    break;
                }
                webViewApp.sendEvent(WebViewEventCategory.CONNECTIVITY, ConnectivityEvent.NETWORK_CHANGE, wifi, networkType);
                break;
            }
        }
    }
}

