/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.browseractions;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.browser.R;
import androidx.browser.browseractions.BrowserActionItem;
import androidx.core.content.res.ResourcesCompat;
import java.util.List;

class BrowserActionsFallbackMenuAdapter
extends BaseAdapter {
    private final List<BrowserActionItem> mMenuItems;
    private final Context mContext;

    BrowserActionsFallbackMenuAdapter(List<BrowserActionItem> menuItems, Context context) {
        this.mMenuItems = menuItems;
        this.mContext = context;
    }

    public int getCount() {
        return this.mMenuItems.size();
    }

    public Object getItem(int position) {
        return this.mMenuItems.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolderItem viewHolder;
        BrowserActionItem menuItem = this.mMenuItems.get(position);
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.browser_actions_context_menu_row, null);
            viewHolder = new ViewHolderItem();
            viewHolder.mIcon = (ImageView)convertView.findViewById(R.id.browser_actions_menu_item_icon);
            viewHolder.mText = (TextView)convertView.findViewById(R.id.browser_actions_menu_item_text);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolderItem)convertView.getTag();
        }
        viewHolder.mText.setText((CharSequence)menuItem.getTitle());
        if (menuItem.getIconId() != 0) {
            Drawable drawable = ResourcesCompat.getDrawable((Resources)this.mContext.getResources(), (int)menuItem.getIconId(), null);
            viewHolder.mIcon.setImageDrawable(drawable);
        } else {
            viewHolder.mIcon.setImageDrawable(null);
        }
        return convertView;
    }

    static class ViewHolderItem {
        ImageView mIcon;
        TextView mText;

        ViewHolderItem() {
        }
    }
}

