/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.browseractions;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;

class BrowserActionsFallbackMenuDialog
extends Dialog {
    private static final long ENTER_ANIMATION_DURATION_MS = 250L;
    private static final long EXIT_ANIMATION_DURATION_MS = 150L;
    private final View mContentView;

    BrowserActionsFallbackMenuDialog(Context context, View contentView) {
        super(context);
        this.mContentView = contentView;
    }

    public void show() {
        Window dialogWindow = this.getWindow();
        dialogWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.startAnimation(true);
        super.show();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.dismiss();
            return true;
        }
        return false;
    }

    public void dismiss() {
        this.startAnimation(false);
    }

    private void startAnimation(final boolean isEnterAnimation) {
        float from = isEnterAnimation ? 0.0f : 1.0f;
        float to = isEnterAnimation ? 1.0f : 0.0f;
        long duration = isEnterAnimation ? 250L : 150L;
        this.mContentView.setScaleX(from);
        this.mContentView.setScaleY(from);
        this.mContentView.animate().scaleX(to).scaleY(to).setDuration(duration).setInterpolator((TimeInterpolator)new LinearOutSlowInInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (!isEnterAnimation) {
                    BrowserActionsFallbackMenuDialog.super.dismiss();
                }
            }
        }).start();
    }
}

