/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.customtabs;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.customtabs.ICustomTabsCallback;
import android.support.customtabs.IPostMessageService;
import androidx.browser.customtabs.CustomTabsSessionToken;
import androidx.browser.customtabs.PostMessageService;

public abstract class PostMessageServiceConnection
implements ServiceConnection {
    private final Object mLock = new Object();
    private final ICustomTabsCallback mSessionBinder;
    private IPostMessageService mService;

    public PostMessageServiceConnection(CustomTabsSessionToken session) {
        this.mSessionBinder = ICustomTabsCallback.Stub.asInterface(session.getCallbackBinder());
    }

    public boolean bindSessionToPostMessageService(Context context, String packageName) {
        Intent intent = new Intent();
        intent.setClassName(packageName, PostMessageService.class.getName());
        return context.bindService(intent, (ServiceConnection)this, 1);
    }

    public void unbindFromContext(Context context) {
        context.unbindService((ServiceConnection)this);
    }

    public final void onServiceConnected(ComponentName name, IBinder service) {
        this.mService = IPostMessageService.Stub.asInterface(service);
        this.onPostMessageServiceConnected();
    }

    public final void onServiceDisconnected(ComponentName name) {
        this.mService = null;
        this.onPostMessageServiceDisconnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean notifyMessageChannelReady(Bundle extras) {
        if (this.mService == null) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mService.onMessageChannelReady(this.mSessionBinder, extras);
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean postMessage(String message, Bundle extras) {
        if (this.mService == null) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mService.onPostMessage(this.mSessionBinder, message, extras);
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return true;
    }

    public void onPostMessageServiceConnected() {
    }

    public void onPostMessageServiceDisconnected() {
    }
}

