/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.Transformation;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.activity.OnBackPressedDispatcherOwner;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArraySet;
import androidx.core.util.DebugUtils;
import androidx.core.util.LogWriter;
import androidx.core.view.OneShotPreDrawListener;
import androidx.fragment.app.BackStackRecord;
import androidx.fragment.app.BackStackState;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentContainer;
import androidx.fragment.app.FragmentFactory;
import androidx.fragment.app.FragmentHostCallback;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentManagerNonConfig;
import androidx.fragment.app.FragmentManagerState;
import androidx.fragment.app.FragmentManagerViewModel;
import androidx.fragment.app.FragmentState;
import androidx.fragment.app.FragmentTransaction;
import androidx.fragment.app.FragmentTransition;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

final class FragmentManagerImpl
extends FragmentManager
implements LayoutInflater.Factory2 {
    static boolean DEBUG = false;
    static final String TAG = "FragmentManager";
    static final String TARGET_REQUEST_CODE_STATE_TAG = "android:target_req_state";
    static final String TARGET_STATE_TAG = "android:target_state";
    static final String VIEW_STATE_TAG = "android:view_state";
    static final String USER_VISIBLE_HINT_TAG = "android:user_visible_hint";
    ArrayList<OpGenerator> mPendingActions;
    boolean mExecutingActions;
    int mNextFragmentIndex = 0;
    final ArrayList<Fragment> mAdded = new ArrayList();
    final HashMap<String, Fragment> mActive = new HashMap();
    ArrayList<BackStackRecord> mBackStack;
    ArrayList<Fragment> mCreatedMenus;
    private OnBackPressedDispatcher mOnBackPressedDispatcher;
    private final OnBackPressedCallback mOnBackPressedCallback = new OnBackPressedCallback(false){

        public void handleOnBackPressed() {
            FragmentManagerImpl.this.handleOnBackPressed();
        }
    };
    ArrayList<BackStackRecord> mBackStackIndices;
    ArrayList<Integer> mAvailBackStackIndices;
    ArrayList<FragmentManager.OnBackStackChangedListener> mBackStackChangeListeners;
    private final CopyOnWriteArrayList<FragmentLifecycleCallbacksHolder> mLifecycleCallbacks = new CopyOnWriteArrayList();
    int mCurState = 0;
    FragmentHostCallback mHost;
    FragmentContainer mContainer;
    Fragment mParent;
    @Nullable
    Fragment mPrimaryNav;
    boolean mNeedMenuInvalidate;
    boolean mStateSaved;
    boolean mStopped;
    boolean mDestroyed;
    boolean mHavePendingDeferredStart;
    ArrayList<BackStackRecord> mTmpRecords;
    ArrayList<Boolean> mTmpIsPop;
    ArrayList<Fragment> mTmpAddedFragments;
    Bundle mStateBundle = null;
    SparseArray<Parcelable> mStateArray = null;
    ArrayList<StartEnterTransitionListener> mPostponedTransactions;
    private FragmentManagerViewModel mNonConfig;
    Runnable mExecCommit = new Runnable(){

        @Override
        public void run() {
            FragmentManagerImpl.this.execPendingActions();
        }
    };
    static final Interpolator DECELERATE_QUINT = new DecelerateInterpolator(2.5f);
    static final Interpolator DECELERATE_CUBIC = new DecelerateInterpolator(1.5f);
    static final int ANIM_DUR = 220;
    public static final int ANIM_STYLE_OPEN_ENTER = 1;
    public static final int ANIM_STYLE_OPEN_EXIT = 2;
    public static final int ANIM_STYLE_CLOSE_ENTER = 3;
    public static final int ANIM_STYLE_CLOSE_EXIT = 4;
    public static final int ANIM_STYLE_FADE_ENTER = 5;
    public static final int ANIM_STYLE_FADE_EXIT = 6;

    FragmentManagerImpl() {
    }

    private void throwException(RuntimeException ex) {
        Log.e((String)TAG, (String)ex.getMessage());
        Log.e((String)TAG, (String)"Activity state:");
        LogWriter logw = new LogWriter(TAG);
        PrintWriter pw = new PrintWriter((Writer)logw);
        if (this.mHost != null) {
            try {
                this.mHost.onDump("  ", null, pw, new String[0]);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)e);
            }
        } else {
            try {
                this.dump("  ", null, pw, new String[0]);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)e);
            }
        }
        throw ex;
    }

    @Override
    @NonNull
    public FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    @Override
    public boolean executePendingTransactions() {
        boolean updates = this.execPendingActions();
        this.forcePostponedTransactions();
        return updates;
    }

    private void updateOnBackPressedCallbackEnabled() {
        if (this.mPendingActions != null && !this.mPendingActions.isEmpty()) {
            this.mOnBackPressedCallback.setEnabled(true);
            return;
        }
        this.mOnBackPressedCallback.setEnabled(this.getBackStackEntryCount() > 0 && this.isPrimaryNavigation(this.mParent));
    }

    boolean isPrimaryNavigation(@Nullable Fragment parent) {
        if (parent == null) {
            return true;
        }
        FragmentManagerImpl parentFragmentManager = parent.mFragmentManager;
        Fragment primaryNavigationFragment = parentFragmentManager.getPrimaryNavigationFragment();
        return parent == primaryNavigationFragment && this.isPrimaryNavigation(parentFragmentManager.mParent);
    }

    void handleOnBackPressed() {
        this.execPendingActions();
        if (this.mOnBackPressedCallback.isEnabled()) {
            this.popBackStackImmediate();
        } else {
            this.mOnBackPressedDispatcher.onBackPressed();
        }
    }

    @Override
    public void popBackStack() {
        this.enqueueAction(new PopBackStackState(null, -1, 0), false);
    }

    @Override
    public boolean popBackStackImmediate() {
        this.checkStateLoss();
        return this.popBackStackImmediate(null, -1, 0);
    }

    @Override
    public void popBackStack(@Nullable String name, int flags) {
        this.enqueueAction(new PopBackStackState(name, -1, flags), false);
    }

    @Override
    public boolean popBackStackImmediate(@Nullable String name, int flags) {
        this.checkStateLoss();
        return this.popBackStackImmediate(name, -1, flags);
    }

    @Override
    public void popBackStack(int id, int flags) {
        if (id < 0) {
            throw new IllegalArgumentException("Bad id: " + id);
        }
        this.enqueueAction(new PopBackStackState(null, id, flags), false);
    }

    @Override
    public boolean popBackStackImmediate(int id, int flags) {
        this.checkStateLoss();
        this.execPendingActions();
        if (id < 0) {
            throw new IllegalArgumentException("Bad id: " + id);
        }
        return this.popBackStackImmediate(null, id, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean popBackStackImmediate(String name, int id, int flags) {
        FragmentManager childManager;
        this.execPendingActions();
        this.ensureExecReady(true);
        if (this.mPrimaryNav != null && id < 0 && name == null && (childManager = this.mPrimaryNav.getChildFragmentManager()).popBackStackImmediate()) {
            return true;
        }
        boolean executePop = this.popBackStackState(this.mTmpRecords, this.mTmpIsPop, name, id, flags);
        if (executePop) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.burpActive();
        return executePop;
    }

    @Override
    public int getBackStackEntryCount() {
        return this.mBackStack != null ? this.mBackStack.size() : 0;
    }

    @Override
    public FragmentManager.BackStackEntry getBackStackEntryAt(int index) {
        return this.mBackStack.get(index);
    }

    @Override
    public void addOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener listener) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList();
        }
        this.mBackStackChangeListeners.add(listener);
    }

    @Override
    public void removeOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener listener) {
        if (this.mBackStackChangeListeners != null) {
            this.mBackStackChangeListeners.remove(listener);
        }
    }

    @Override
    public void putFragment(Bundle bundle, String key, Fragment fragment) {
        if (fragment.mFragmentManager != this) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        bundle.putString(key, fragment.mWho);
    }

    @Override
    @Nullable
    public Fragment getFragment(Bundle bundle, String key) {
        String who = bundle.getString(key);
        if (who == null) {
            return null;
        }
        Fragment f = this.mActive.get(who);
        if (f == null) {
            this.throwException(new IllegalStateException("Fragment no longer exists for key " + key + ": unique id " + who));
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Fragment> getFragments() {
        if (this.mAdded.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            return (List)this.mAdded.clone();
        }
    }

    @NonNull
    ViewModelStore getViewModelStore(@NonNull Fragment f) {
        return this.mNonConfig.getViewModelStore(f);
    }

    @NonNull
    FragmentManagerViewModel getChildNonConfig(@NonNull Fragment f) {
        return this.mNonConfig.getChildNonConfig(f);
    }

    void addRetainedFragment(@NonNull Fragment f) {
        if (this.isStateSaved()) {
            if (DEBUG) {
                Log.v((String)TAG, (String)"Ignoring addRetainedFragment as the state is already saved");
            }
            return;
        }
        boolean added = this.mNonConfig.addRetainedFragment(f);
        if (added && DEBUG) {
            Log.v((String)TAG, (String)("Updating retained Fragments: Added " + f));
        }
    }

    void removeRetainedFragment(@NonNull Fragment f) {
        if (this.isStateSaved()) {
            if (DEBUG) {
                Log.v((String)TAG, (String)"Ignoring removeRetainedFragment as the state is already saved");
            }
            return;
        }
        boolean removed = this.mNonConfig.removeRetainedFragment(f);
        if (removed && DEBUG) {
            Log.v((String)TAG, (String)("Updating retained Fragments: Removed " + f));
        }
    }

    @NonNull
    List<Fragment> getActiveFragments() {
        return new ArrayList<Fragment>(this.mActive.values());
    }

    int getActiveFragmentCount() {
        return this.mActive.size();
    }

    @Override
    @Nullable
    public Fragment.SavedState saveFragmentInstanceState(@NonNull Fragment fragment) {
        if (fragment.mFragmentManager != this) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        if (fragment.mState > 0) {
            Bundle result = this.saveFragmentBasicState(fragment);
            return result != null ? new Fragment.SavedState(result) : null;
        }
        return null;
    }

    @Override
    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("FragmentManager{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" in ");
        if (this.mParent != null) {
            DebugUtils.buildShortClassTag((Object)this.mParent, (StringBuilder)sb);
        } else {
            DebugUtils.buildShortClassTag((Object)this.mHost, (StringBuilder)sb);
        }
        sb.append("}}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(@NonNull String prefix, @Nullable FileDescriptor fd, @NonNull PrintWriter writer, @Nullable String[] args) {
        Fragment f;
        int N;
        String innerPrefix = prefix + "    ";
        if (!this.mActive.isEmpty()) {
            writer.print(prefix);
            writer.print("Active Fragments in ");
            writer.print(Integer.toHexString(System.identityHashCode(this)));
            writer.println(":");
            for (Fragment f2 : this.mActive.values()) {
                writer.print(prefix);
                writer.println(f2);
                if (f2 == null) continue;
                f2.dump(innerPrefix, fd, writer, args);
            }
        }
        if ((N = this.mAdded.size()) > 0) {
            writer.print(prefix);
            writer.println("Added Fragments:");
            for (int i = 0; i < N; ++i) {
                f = this.mAdded.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f.toString());
            }
        }
        if (this.mCreatedMenus != null && (N = this.mCreatedMenus.size()) > 0) {
            writer.print(prefix);
            writer.println("Fragments Created Menus:");
            for (int i = 0; i < N; ++i) {
                f = this.mCreatedMenus.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f.toString());
            }
        }
        if (this.mBackStack != null && (N = this.mBackStack.size()) > 0) {
            writer.print(prefix);
            writer.println("Back Stack:");
            for (int i = 0; i < N; ++i) {
                BackStackRecord bs = this.mBackStack.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(bs.toString());
                bs.dump(innerPrefix, writer);
            }
        }
        FragmentManagerImpl i = this;
        synchronized (i) {
            if (this.mBackStackIndices != null && (N = this.mBackStackIndices.size()) > 0) {
                writer.print(prefix);
                writer.println("Back Stack Indices:");
                for (int i2 = 0; i2 < N; ++i2) {
                    BackStackRecord bs = this.mBackStackIndices.get(i2);
                    writer.print(prefix);
                    writer.print("  #");
                    writer.print(i2);
                    writer.print(": ");
                    writer.println(bs);
                }
            }
            if (this.mAvailBackStackIndices != null && this.mAvailBackStackIndices.size() > 0) {
                writer.print(prefix);
                writer.print("mAvailBackStackIndices: ");
                writer.println(Arrays.toString(this.mAvailBackStackIndices.toArray()));
            }
        }
        if (this.mPendingActions != null && (N = this.mPendingActions.size()) > 0) {
            writer.print(prefix);
            writer.println("Pending Actions:");
            for (int i3 = 0; i3 < N; ++i3) {
                OpGenerator r = this.mPendingActions.get(i3);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i3);
                writer.print(": ");
                writer.println(r);
            }
        }
        writer.print(prefix);
        writer.println("FragmentManager misc state:");
        writer.print(prefix);
        writer.print("  mHost=");
        writer.println(this.mHost);
        writer.print(prefix);
        writer.print("  mContainer=");
        writer.println(this.mContainer);
        if (this.mParent != null) {
            writer.print(prefix);
            writer.print("  mParent=");
            writer.println(this.mParent);
        }
        writer.print(prefix);
        writer.print("  mCurState=");
        writer.print(this.mCurState);
        writer.print(" mStateSaved=");
        writer.print(this.mStateSaved);
        writer.print(" mStopped=");
        writer.print(this.mStopped);
        writer.print(" mDestroyed=");
        writer.println(this.mDestroyed);
        if (this.mNeedMenuInvalidate) {
            writer.print(prefix);
            writer.print("  mNeedMenuInvalidate=");
            writer.println(this.mNeedMenuInvalidate);
        }
    }

    static AnimationOrAnimator makeOpenCloseAnimation(float startScale, float endScale, float startAlpha, float endAlpha) {
        AnimationSet set = new AnimationSet(false);
        ScaleAnimation scale = new ScaleAnimation(startScale, endScale, startScale, endScale, 1, 0.5f, 1, 0.5f);
        scale.setInterpolator(DECELERATE_QUINT);
        scale.setDuration(220L);
        set.addAnimation((Animation)scale);
        AlphaAnimation alpha = new AlphaAnimation(startAlpha, endAlpha);
        alpha.setInterpolator(DECELERATE_CUBIC);
        alpha.setDuration(220L);
        set.addAnimation((Animation)alpha);
        return new AnimationOrAnimator((Animation)set);
    }

    static AnimationOrAnimator makeFadeAnimation(float start, float end) {
        AlphaAnimation anim = new AlphaAnimation(start, end);
        anim.setInterpolator(DECELERATE_CUBIC);
        anim.setDuration(220L);
        return new AnimationOrAnimator((Animation)anim);
    }

    AnimationOrAnimator loadAnimation(Fragment fragment, int transit, boolean enter, int transitionStyle) {
        block26: {
            int nextAnim = fragment.getNextAnim();
            fragment.setNextAnim(0);
            if (fragment.mContainer != null && fragment.mContainer.getLayoutTransition() != null) {
                return null;
            }
            Animation animation = fragment.onCreateAnimation(transit, enter, nextAnim);
            if (animation != null) {
                return new AnimationOrAnimator(animation);
            }
            Animator animator = fragment.onCreateAnimator(transit, enter, nextAnim);
            if (animator != null) {
                return new AnimationOrAnimator(animator);
            }
            if (nextAnim != 0) {
                String dir = this.mHost.getContext().getResources().getResourceTypeName(nextAnim);
                boolean isAnim = "anim".equals(dir);
                boolean successfulLoad = false;
                if (isAnim) {
                    try {
                        animation = AnimationUtils.loadAnimation((Context)this.mHost.getContext(), (int)nextAnim);
                        if (animation != null) {
                            return new AnimationOrAnimator(animation);
                        }
                        successfulLoad = true;
                    }
                    catch (Resources.NotFoundException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                if (!successfulLoad) {
                    try {
                        animator = AnimatorInflater.loadAnimator((Context)this.mHost.getContext(), (int)nextAnim);
                        if (animator != null) {
                            return new AnimationOrAnimator(animator);
                        }
                    }
                    catch (RuntimeException e) {
                        if (isAnim) {
                            throw e;
                        }
                        animation = AnimationUtils.loadAnimation((Context)this.mHost.getContext(), (int)nextAnim);
                        if (animation == null) break block26;
                        return new AnimationOrAnimator(animation);
                    }
                }
            }
        }
        if (transit == 0) {
            return null;
        }
        int styleIndex = FragmentManagerImpl.transitToStyleIndex(transit, enter);
        if (styleIndex < 0) {
            return null;
        }
        switch (styleIndex) {
            case 1: {
                return FragmentManagerImpl.makeOpenCloseAnimation(1.125f, 1.0f, 0.0f, 1.0f);
            }
            case 2: {
                return FragmentManagerImpl.makeOpenCloseAnimation(1.0f, 0.975f, 1.0f, 0.0f);
            }
            case 3: {
                return FragmentManagerImpl.makeOpenCloseAnimation(0.975f, 1.0f, 0.0f, 1.0f);
            }
            case 4: {
                return FragmentManagerImpl.makeOpenCloseAnimation(1.0f, 1.075f, 1.0f, 0.0f);
            }
            case 5: {
                return FragmentManagerImpl.makeFadeAnimation(0.0f, 1.0f);
            }
            case 6: {
                return FragmentManagerImpl.makeFadeAnimation(1.0f, 0.0f);
            }
        }
        if (transitionStyle == 0 && this.mHost.onHasWindowAnimations()) {
            transitionStyle = this.mHost.onGetWindowAnimations();
        }
        if (transitionStyle == 0) {
            return null;
        }
        return null;
    }

    public void performPendingDeferredStart(Fragment f) {
        if (f.mDeferStart) {
            if (this.mExecutingActions) {
                this.mHavePendingDeferredStart = true;
                return;
            }
            f.mDeferStart = false;
            this.moveToState(f, this.mCurState, 0, 0, false);
        }
    }

    boolean isStateAtLeast(int state) {
        return this.mCurState >= state;
    }

    void moveToState(Fragment f, int newState, int transit, int transitionStyle, boolean keepActive) {
        if ((!f.mAdded || f.mDetached) && newState > 1) {
            newState = 1;
        }
        if (f.mRemoving && newState > f.mState) {
            newState = f.mState == 0 && f.isInBackStack() ? 1 : f.mState;
        }
        if (f.mDeferStart && f.mState < 3 && newState > 2) {
            newState = 2;
        }
        if (f.mState <= (newState = f.mMaxState == Lifecycle.State.CREATED ? Math.min(newState, 1) : Math.min(newState, f.mMaxState.ordinal()))) {
            if (f.mFromLayout && !f.mInLayout) {
                return;
            }
            if (f.getAnimatingAway() != null || f.getAnimator() != null) {
                f.setAnimatingAway(null);
                f.setAnimator(null);
                this.moveToState(f, f.getStateAfterAnimating(), 0, 0, true);
            }
            switch (f.mState) {
                case 0: {
                    if (newState > 0) {
                        Fragment target;
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("moveto CREATED: " + f));
                        }
                        if (f.mSavedFragmentState != null) {
                            f.mSavedFragmentState.setClassLoader(this.mHost.getContext().getClassLoader());
                            f.mSavedViewState = f.mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
                            target = this.getFragment(f.mSavedFragmentState, TARGET_STATE_TAG);
                            String string = f.mTargetWho = target != null ? target.mWho : null;
                            if (f.mTargetWho != null) {
                                f.mTargetRequestCode = f.mSavedFragmentState.getInt(TARGET_REQUEST_CODE_STATE_TAG, 0);
                            }
                            if (f.mSavedUserVisibleHint != null) {
                                f.mUserVisibleHint = f.mSavedUserVisibleHint;
                                f.mSavedUserVisibleHint = null;
                            } else {
                                f.mUserVisibleHint = f.mSavedFragmentState.getBoolean(USER_VISIBLE_HINT_TAG, true);
                            }
                            if (!f.mUserVisibleHint) {
                                f.mDeferStart = true;
                                if (newState > 2) {
                                    newState = 2;
                                }
                            }
                        }
                        f.mHost = this.mHost;
                        f.mParentFragment = this.mParent;
                        FragmentManagerImpl fragmentManagerImpl = f.mFragmentManager = this.mParent != null ? this.mParent.mChildFragmentManager : this.mHost.mFragmentManager;
                        if (f.mTarget != null) {
                            if (this.mActive.get(f.mTarget.mWho) != f.mTarget) {
                                throw new IllegalStateException("Fragment " + f + " declared target fragment " + f.mTarget + " that does not belong to this FragmentManager!");
                            }
                            if (f.mTarget.mState < 1) {
                                this.moveToState(f.mTarget, 1, 0, 0, true);
                            }
                            f.mTargetWho = f.mTarget.mWho;
                            f.mTarget = null;
                        }
                        if (f.mTargetWho != null) {
                            target = this.mActive.get(f.mTargetWho);
                            if (target == null) {
                                throw new IllegalStateException("Fragment " + f + " declared target fragment " + f.mTargetWho + " that does not belong to this FragmentManager!");
                            }
                            if (target.mState < 1) {
                                this.moveToState(target, 1, 0, 0, true);
                            }
                        }
                        this.dispatchOnFragmentPreAttached(f, this.mHost.getContext(), false);
                        f.performAttach();
                        if (f.mParentFragment == null) {
                            this.mHost.onAttachFragment(f);
                        } else {
                            f.mParentFragment.onAttachFragment(f);
                        }
                        this.dispatchOnFragmentAttached(f, this.mHost.getContext(), false);
                        if (!f.mIsCreated) {
                            this.dispatchOnFragmentPreCreated(f, f.mSavedFragmentState, false);
                            f.performCreate(f.mSavedFragmentState);
                            this.dispatchOnFragmentCreated(f, f.mSavedFragmentState, false);
                        } else {
                            f.restoreChildFragmentState(f.mSavedFragmentState);
                            f.mState = 1;
                        }
                    }
                }
                case 1: {
                    if (newState > 0) {
                        this.ensureInflatedFragmentView(f);
                    }
                    if (newState > 1) {
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("moveto ACTIVITY_CREATED: " + f));
                        }
                        if (!f.mFromLayout) {
                            ViewGroup container = null;
                            if (f.mContainerId != 0) {
                                if (f.mContainerId == -1) {
                                    this.throwException(new IllegalArgumentException("Cannot create fragment " + f + " for a container view with no id"));
                                }
                                if ((container = (ViewGroup)this.mContainer.onFindViewById(f.mContainerId)) == null && !f.mRestored) {
                                    String resName;
                                    try {
                                        resName = f.getResources().getResourceName(f.mContainerId);
                                    }
                                    catch (Resources.NotFoundException e) {
                                        resName = "unknown";
                                    }
                                    this.throwException(new IllegalArgumentException("No view found for id 0x" + Integer.toHexString(f.mContainerId) + " (" + resName + ") for fragment " + f));
                                }
                            }
                            f.mContainer = container;
                            f.performCreateView(f.performGetLayoutInflater(f.mSavedFragmentState), container, f.mSavedFragmentState);
                            if (f.mView != null) {
                                f.mInnerView = f.mView;
                                f.mView.setSaveFromParentEnabled(false);
                                if (container != null) {
                                    container.addView(f.mView);
                                }
                                if (f.mHidden) {
                                    f.mView.setVisibility(8);
                                }
                                f.onViewCreated(f.mView, f.mSavedFragmentState);
                                this.dispatchOnFragmentViewCreated(f, f.mView, f.mSavedFragmentState, false);
                                f.mIsNewlyAdded = f.mView.getVisibility() == 0 && f.mContainer != null;
                            } else {
                                f.mInnerView = null;
                            }
                        }
                        f.performActivityCreated(f.mSavedFragmentState);
                        this.dispatchOnFragmentActivityCreated(f, f.mSavedFragmentState, false);
                        if (f.mView != null) {
                            f.restoreViewState(f.mSavedFragmentState);
                        }
                        f.mSavedFragmentState = null;
                    }
                }
                case 2: {
                    if (newState > 2) {
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("moveto STARTED: " + f));
                        }
                        f.performStart();
                        this.dispatchOnFragmentStarted(f, false);
                    }
                }
                case 3: {
                    if (newState <= 3) break;
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("moveto RESUMED: " + f));
                    }
                    f.performResume();
                    this.dispatchOnFragmentResumed(f, false);
                    f.mSavedFragmentState = null;
                    f.mSavedViewState = null;
                }
            }
        } else if (f.mState > newState) {
            switch (f.mState) {
                case 4: {
                    if (newState < 4) {
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("movefrom RESUMED: " + f));
                        }
                        f.performPause();
                        this.dispatchOnFragmentPaused(f, false);
                    }
                }
                case 3: {
                    if (newState < 3) {
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("movefrom STARTED: " + f));
                        }
                        f.performStop();
                        this.dispatchOnFragmentStopped(f, false);
                    }
                }
                case 2: {
                    if (newState < 2) {
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("movefrom ACTIVITY_CREATED: " + f));
                        }
                        if (f.mView != null && this.mHost.onShouldSaveFragmentState(f) && f.mSavedViewState == null) {
                            this.saveFragmentViewState(f);
                        }
                        f.performDestroyView();
                        this.dispatchOnFragmentViewDestroyed(f, false);
                        if (f.mView != null && f.mContainer != null) {
                            f.mContainer.endViewTransition(f.mView);
                            f.mView.clearAnimation();
                            AnimationOrAnimator anim = null;
                            if (f.getParentFragment() == null || !f.getParentFragment().mRemoving) {
                                if (this.mCurState > 0 && !this.mDestroyed && f.mView.getVisibility() == 0 && f.mPostponedAlpha >= 0.0f) {
                                    anim = this.loadAnimation(f, transit, false, transitionStyle);
                                }
                                f.mPostponedAlpha = 0.0f;
                                if (anim != null) {
                                    this.animateRemoveFragment(f, anim, newState);
                                }
                                f.mContainer.removeView(f.mView);
                            }
                        }
                        f.mContainer = null;
                        f.mView = null;
                        f.mViewLifecycleOwner = null;
                        f.mViewLifecycleOwnerLiveData.setValue(null);
                        f.mInnerView = null;
                        f.mInLayout = false;
                    }
                }
                case 1: {
                    Fragment target;
                    boolean beingRemoved;
                    if (newState >= 1) break;
                    if (this.mDestroyed) {
                        if (f.getAnimatingAway() != null) {
                            View v = f.getAnimatingAway();
                            f.setAnimatingAway(null);
                            v.clearAnimation();
                        } else if (f.getAnimator() != null) {
                            Animator animator = f.getAnimator();
                            f.setAnimator(null);
                            animator.cancel();
                        }
                    }
                    if (f.getAnimatingAway() != null || f.getAnimator() != null) {
                        f.setStateAfterAnimating(newState);
                        newState = 1;
                        break;
                    }
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("movefrom CREATED: " + f));
                    }
                    boolean bl = beingRemoved = f.mRemoving && !f.isInBackStack();
                    if (beingRemoved || this.mNonConfig.shouldDestroy(f)) {
                        Activity activity;
                        boolean shouldClear = this.mHost instanceof ViewModelStoreOwner ? this.mNonConfig.isCleared() : (this.mHost.getContext() instanceof Activity ? !(activity = (Activity)this.mHost.getContext()).isChangingConfigurations() : true);
                        if (beingRemoved || shouldClear) {
                            this.mNonConfig.clearNonConfigState(f);
                        }
                        f.performDestroy();
                        this.dispatchOnFragmentDestroyed(f, false);
                    } else {
                        f.mState = 0;
                    }
                    f.performDetach();
                    this.dispatchOnFragmentDetached(f, false);
                    if (keepActive) break;
                    if (beingRemoved || this.mNonConfig.shouldDestroy(f)) {
                        this.makeInactive(f);
                        break;
                    }
                    f.mHost = null;
                    f.mParentFragment = null;
                    f.mFragmentManager = null;
                    if (f.mTargetWho == null || (target = this.mActive.get(f.mTargetWho)) == null || !target.getRetainInstance()) break;
                    f.mTarget = target;
                }
            }
        }
        if (f.mState != newState) {
            Log.w((String)TAG, (String)("moveToState: Fragment state for " + f + " not updated inline; expected state " + newState + " found " + f.mState));
            f.mState = newState;
        }
    }

    private void animateRemoveFragment(final @NonNull Fragment fragment, @NonNull AnimationOrAnimator anim, int newState) {
        final View viewToAnimate = fragment.mView;
        final ViewGroup container = fragment.mContainer;
        container.startViewTransition(viewToAnimate);
        fragment.setStateAfterAnimating(newState);
        if (anim.animation != null) {
            EndViewTransitionAnimation animation = new EndViewTransitionAnimation(anim.animation, container, viewToAnimate);
            fragment.setAnimatingAway(fragment.mView);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    container.post(new Runnable(){

                        @Override
                        public void run() {
                            if (fragment.getAnimatingAway() != null) {
                                fragment.setAnimatingAway(null);
                                FragmentManagerImpl.this.moveToState(fragment, fragment.getStateAfterAnimating(), 0, 0, false);
                            }
                        }
                    });
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            fragment.mView.startAnimation((Animation)animation);
        } else {
            Animator animator = anim.animator;
            fragment.setAnimator(anim.animator);
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator anim) {
                    container.endViewTransition(viewToAnimate);
                    Animator animator = fragment.getAnimator();
                    fragment.setAnimator(null);
                    if (animator != null && container.indexOfChild(viewToAnimate) < 0) {
                        FragmentManagerImpl.this.moveToState(fragment, fragment.getStateAfterAnimating(), 0, 0, false);
                    }
                }
            });
            animator.setTarget((Object)fragment.mView);
            animator.start();
        }
    }

    void moveToState(Fragment f) {
        this.moveToState(f, this.mCurState, 0, 0, false);
    }

    void ensureInflatedFragmentView(Fragment f) {
        if (f.mFromLayout && !f.mPerformedCreateView) {
            f.performCreateView(f.performGetLayoutInflater(f.mSavedFragmentState), null, f.mSavedFragmentState);
            if (f.mView != null) {
                f.mInnerView = f.mView;
                f.mView.setSaveFromParentEnabled(false);
                if (f.mHidden) {
                    f.mView.setVisibility(8);
                }
                f.onViewCreated(f.mView, f.mSavedFragmentState);
                this.dispatchOnFragmentViewCreated(f, f.mView, f.mSavedFragmentState, false);
            } else {
                f.mInnerView = null;
            }
        }
    }

    void completeShowHideFragment(final Fragment fragment) {
        if (fragment.mView != null) {
            AnimationOrAnimator anim = this.loadAnimation(fragment, fragment.getNextTransition(), !fragment.mHidden, fragment.getNextTransitionStyle());
            if (anim != null && anim.animator != null) {
                anim.animator.setTarget((Object)fragment.mView);
                if (fragment.mHidden) {
                    if (fragment.isHideReplaced()) {
                        fragment.setHideReplaced(false);
                    } else {
                        final ViewGroup container = fragment.mContainer;
                        final View animatingView = fragment.mView;
                        container.startViewTransition(animatingView);
                        anim.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animation) {
                                container.endViewTransition(animatingView);
                                animation.removeListener((Animator.AnimatorListener)this);
                                if (fragment.mView != null && fragment.mHidden) {
                                    fragment.mView.setVisibility(8);
                                }
                            }
                        });
                    }
                } else {
                    fragment.mView.setVisibility(0);
                }
                anim.animator.start();
            } else {
                if (anim != null) {
                    fragment.mView.startAnimation(anim.animation);
                    anim.animation.start();
                }
                int visibility = fragment.mHidden && !fragment.isHideReplaced() ? 8 : 0;
                fragment.mView.setVisibility(visibility);
                if (fragment.isHideReplaced()) {
                    fragment.setHideReplaced(false);
                }
            }
        }
        if (fragment.mAdded && this.isMenuAvailable(fragment)) {
            this.mNeedMenuInvalidate = true;
        }
        fragment.mHiddenChanged = false;
        fragment.onHiddenChanged(fragment.mHidden);
    }

    void moveFragmentToExpectedState(Fragment f) {
        if (f == null) {
            return;
        }
        if (!this.mActive.containsKey(f.mWho)) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Ignoring moving " + f + " to state " + this.mCurState + "since it is not added to " + this));
            }
            return;
        }
        int nextState = this.mCurState;
        if (f.mRemoving) {
            nextState = f.isInBackStack() ? Math.min(nextState, 1) : Math.min(nextState, 0);
        }
        this.moveToState(f, nextState, f.getNextTransition(), f.getNextTransitionStyle(), false);
        if (f.mView != null) {
            Fragment underFragment = this.findFragmentUnder(f);
            if (underFragment != null) {
                View underView = underFragment.mView;
                ViewGroup container = f.mContainer;
                int underIndex = container.indexOfChild(underView);
                int viewIndex = container.indexOfChild(f.mView);
                if (viewIndex < underIndex) {
                    container.removeViewAt(viewIndex);
                    container.addView(f.mView, underIndex);
                }
            }
            if (f.mIsNewlyAdded && f.mContainer != null) {
                if (f.mPostponedAlpha > 0.0f) {
                    f.mView.setAlpha(f.mPostponedAlpha);
                }
                f.mPostponedAlpha = 0.0f;
                f.mIsNewlyAdded = false;
                AnimationOrAnimator anim = this.loadAnimation(f, f.getNextTransition(), true, f.getNextTransitionStyle());
                if (anim != null) {
                    if (anim.animation != null) {
                        f.mView.startAnimation(anim.animation);
                    } else {
                        anim.animator.setTarget((Object)f.mView);
                        anim.animator.start();
                    }
                }
            }
        }
        if (f.mHiddenChanged) {
            this.completeShowHideFragment(f);
        }
    }

    void moveToState(int newState, boolean always) {
        if (this.mHost == null && newState != 0) {
            throw new IllegalStateException("No activity");
        }
        if (!always && newState == this.mCurState) {
            return;
        }
        this.mCurState = newState;
        int numAdded = this.mAdded.size();
        for (int i = 0; i < numAdded; ++i) {
            Fragment f = this.mAdded.get(i);
            this.moveFragmentToExpectedState(f);
        }
        for (Fragment f : this.mActive.values()) {
            if (f == null || !f.mRemoving && !f.mDetached || f.mIsNewlyAdded) continue;
            this.moveFragmentToExpectedState(f);
        }
        this.startPendingDeferredFragments();
        if (this.mNeedMenuInvalidate && this.mHost != null && this.mCurState == 4) {
            this.mHost.onSupportInvalidateOptionsMenu();
            this.mNeedMenuInvalidate = false;
        }
    }

    void startPendingDeferredFragments() {
        for (Fragment f : this.mActive.values()) {
            if (f == null) continue;
            this.performPendingDeferredStart(f);
        }
    }

    void makeActive(Fragment f) {
        if (this.mActive.get(f.mWho) != null) {
            return;
        }
        this.mActive.put(f.mWho, f);
        if (f.mRetainInstanceChangedWhileDetached) {
            if (f.mRetainInstance) {
                this.addRetainedFragment(f);
            } else {
                this.removeRetainedFragment(f);
            }
            f.mRetainInstanceChangedWhileDetached = false;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("Added fragment to active set " + f));
        }
    }

    void makeInactive(Fragment f) {
        if (this.mActive.get(f.mWho) == null) {
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("Removed fragment from active set " + f));
        }
        for (Fragment fragment : this.mActive.values()) {
            if (fragment == null || !f.mWho.equals(fragment.mTargetWho)) continue;
            fragment.mTarget = f;
            fragment.mTargetWho = null;
        }
        this.mActive.put(f.mWho, null);
        this.removeRetainedFragment(f);
        if (f.mTargetWho != null) {
            f.mTarget = this.mActive.get(f.mTargetWho);
        }
        f.initState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFragment(Fragment fragment, boolean moveToStateNow) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("add: " + fragment));
        }
        this.makeActive(fragment);
        if (!fragment.mDetached) {
            if (this.mAdded.contains(fragment)) {
                throw new IllegalStateException("Fragment already added: " + fragment);
            }
            ArrayList<Fragment> arrayList = this.mAdded;
            synchronized (arrayList) {
                this.mAdded.add(fragment);
            }
            fragment.mAdded = true;
            fragment.mRemoving = false;
            if (fragment.mView == null) {
                fragment.mHiddenChanged = false;
            }
            if (this.isMenuAvailable(fragment)) {
                this.mNeedMenuInvalidate = true;
            }
            if (moveToStateNow) {
                this.moveToState(fragment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFragment(Fragment fragment) {
        boolean inactive;
        if (DEBUG) {
            Log.v((String)TAG, (String)("remove: " + fragment + " nesting=" + fragment.mBackStackNesting));
        }
        boolean bl = inactive = !fragment.isInBackStack();
        if (!fragment.mDetached || inactive) {
            ArrayList<Fragment> arrayList = this.mAdded;
            synchronized (arrayList) {
                this.mAdded.remove(fragment);
            }
            if (this.isMenuAvailable(fragment)) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.mAdded = false;
            fragment.mRemoving = true;
        }
    }

    public void hideFragment(Fragment fragment) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("hide: " + fragment));
        }
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            fragment.mHiddenChanged = !fragment.mHiddenChanged;
        }
    }

    public void showFragment(Fragment fragment) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("show: " + fragment));
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            fragment.mHiddenChanged = !fragment.mHiddenChanged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachFragment(Fragment fragment) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("detach: " + fragment));
        }
        if (!fragment.mDetached) {
            fragment.mDetached = true;
            if (fragment.mAdded) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("remove from detach: " + fragment));
                }
                ArrayList<Fragment> arrayList = this.mAdded;
                synchronized (arrayList) {
                    this.mAdded.remove(fragment);
                }
                if (this.isMenuAvailable(fragment)) {
                    this.mNeedMenuInvalidate = true;
                }
                fragment.mAdded = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachFragment(Fragment fragment) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("attach: " + fragment));
        }
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (!fragment.mAdded) {
                if (this.mAdded.contains(fragment)) {
                    throw new IllegalStateException("Fragment already added: " + fragment);
                }
                if (DEBUG) {
                    Log.v((String)TAG, (String)("add from attach: " + fragment));
                }
                ArrayList<Fragment> arrayList = this.mAdded;
                synchronized (arrayList) {
                    this.mAdded.add(fragment);
                }
                fragment.mAdded = true;
                if (this.isMenuAvailable(fragment)) {
                    this.mNeedMenuInvalidate = true;
                }
            }
        }
    }

    @Override
    @Nullable
    public Fragment findFragmentById(int id) {
        for (int i = this.mAdded.size() - 1; i >= 0; --i) {
            Fragment f = this.mAdded.get(i);
            if (f == null || f.mFragmentId != id) continue;
            return f;
        }
        for (Fragment f : this.mActive.values()) {
            if (f == null || f.mFragmentId != id) continue;
            return f;
        }
        return null;
    }

    @Override
    @Nullable
    public Fragment findFragmentByTag(@Nullable String tag) {
        if (tag != null) {
            for (int i = this.mAdded.size() - 1; i >= 0; --i) {
                Fragment f = this.mAdded.get(i);
                if (f == null || !tag.equals(f.mTag)) continue;
                return f;
            }
        }
        if (tag != null) {
            for (Fragment f : this.mActive.values()) {
                if (f == null || !tag.equals(f.mTag)) continue;
                return f;
            }
        }
        return null;
    }

    public Fragment findFragmentByWho(@NonNull String who) {
        for (Fragment f : this.mActive.values()) {
            if (f == null || (f = f.findFragmentByWho(who)) == null) continue;
            return f;
        }
        return null;
    }

    private void checkStateLoss() {
        if (this.isStateSaved()) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
    }

    @Override
    public boolean isStateSaved() {
        return this.mStateSaved || this.mStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueAction(OpGenerator action, boolean allowStateLoss) {
        if (!allowStateLoss) {
            this.checkStateLoss();
        }
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            if (this.mDestroyed || this.mHost == null) {
                if (allowStateLoss) {
                    return;
                }
                throw new IllegalStateException("Activity has been destroyed");
            }
            if (this.mPendingActions == null) {
                this.mPendingActions = new ArrayList();
            }
            this.mPendingActions.add(action);
            this.scheduleCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleCommit() {
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            boolean pendingReady;
            boolean postponeReady = this.mPostponedTransactions != null && !this.mPostponedTransactions.isEmpty();
            boolean bl = pendingReady = this.mPendingActions != null && this.mPendingActions.size() == 1;
            if (postponeReady || pendingReady) {
                this.mHost.getHandler().removeCallbacks(this.mExecCommit);
                this.mHost.getHandler().post(this.mExecCommit);
                this.updateOnBackPressedCallbackEnabled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocBackStackIndex(BackStackRecord bse) {
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            if (this.mAvailBackStackIndices == null || this.mAvailBackStackIndices.size() <= 0) {
                if (this.mBackStackIndices == null) {
                    this.mBackStackIndices = new ArrayList();
                }
                int index = this.mBackStackIndices.size();
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Setting back stack index " + index + " to " + bse));
                }
                this.mBackStackIndices.add(bse);
                return index;
            }
            int index = this.mAvailBackStackIndices.remove(this.mAvailBackStackIndices.size() - 1);
            if (DEBUG) {
                Log.v((String)TAG, (String)("Adding back stack index " + index + " with " + bse));
            }
            this.mBackStackIndices.set(index, bse);
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackStackIndex(int index, BackStackRecord bse) {
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            int N;
            if (this.mBackStackIndices == null) {
                this.mBackStackIndices = new ArrayList();
            }
            if (index < (N = this.mBackStackIndices.size())) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Setting back stack index " + index + " to " + bse));
                }
                this.mBackStackIndices.set(index, bse);
            } else {
                while (N < index) {
                    this.mBackStackIndices.add(null);
                    if (this.mAvailBackStackIndices == null) {
                        this.mAvailBackStackIndices = new ArrayList();
                    }
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("Adding available back stack index " + N));
                    }
                    this.mAvailBackStackIndices.add(N);
                    ++N;
                }
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Adding back stack index " + index + " with " + bse));
                }
                this.mBackStackIndices.add(bse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeBackStackIndex(int index) {
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            this.mBackStackIndices.set(index, null);
            if (this.mAvailBackStackIndices == null) {
                this.mAvailBackStackIndices = new ArrayList();
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("Freeing back stack index " + index));
            }
            this.mAvailBackStackIndices.add(index);
        }
    }

    private void ensureExecReady(boolean allowStateLoss) {
        if (this.mExecutingActions) {
            throw new IllegalStateException("FragmentManager is already executing transactions");
        }
        if (this.mHost == null) {
            throw new IllegalStateException("Fragment host has been destroyed");
        }
        if (Looper.myLooper() != this.mHost.getHandler().getLooper()) {
            throw new IllegalStateException("Must be called from main thread of fragment host");
        }
        if (!allowStateLoss) {
            this.checkStateLoss();
        }
        if (this.mTmpRecords == null) {
            this.mTmpRecords = new ArrayList();
            this.mTmpIsPop = new ArrayList();
        }
        this.mExecutingActions = true;
        try {
            this.executePostponedTransaction(null, null);
        }
        finally {
            this.mExecutingActions = false;
        }
    }

    public void execSingleAction(OpGenerator action, boolean allowStateLoss) {
        if (allowStateLoss && (this.mHost == null || this.mDestroyed)) {
            return;
        }
        this.ensureExecReady(allowStateLoss);
        if (action.generateOps(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.burpActive();
    }

    private void cleanupExec() {
        this.mExecutingActions = false;
        this.mTmpIsPop.clear();
        this.mTmpRecords.clear();
    }

    public boolean execPendingActions() {
        this.ensureExecReady(true);
        boolean didSomething = false;
        while (this.generateOpsForPendingActions(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
            didSomething = true;
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.burpActive();
        return didSomething;
    }

    private void executePostponedTransaction(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop) {
        int numPostponed = this.mPostponedTransactions == null ? 0 : this.mPostponedTransactions.size();
        for (int i = 0; i < numPostponed; ++i) {
            int index;
            StartEnterTransitionListener listener = this.mPostponedTransactions.get(i);
            if (records != null && !listener.mIsBack && (index = records.indexOf(listener.mRecord)) != -1 && isRecordPop.get(index).booleanValue()) {
                this.mPostponedTransactions.remove(i);
                --i;
                --numPostponed;
                listener.cancelTransaction();
                continue;
            }
            if (!listener.isReady() && (records == null || !listener.mRecord.interactsWith(records, 0, records.size()))) continue;
            this.mPostponedTransactions.remove(i);
            --i;
            --numPostponed;
            if (records != null && !listener.mIsBack && (index = records.indexOf(listener.mRecord)) != -1 && isRecordPop.get(index).booleanValue()) {
                listener.cancelTransaction();
                continue;
            }
            listener.completeTransaction();
        }
    }

    private void removeRedundantOperationsAndExecute(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop) {
        if (records == null || records.isEmpty()) {
            return;
        }
        if (isRecordPop == null || records.size() != isRecordPop.size()) {
            throw new IllegalStateException("Internal error with the back stack records");
        }
        this.executePostponedTransaction(records, isRecordPop);
        int numRecords = records.size();
        int startIndex = 0;
        for (int recordNum = 0; recordNum < numRecords; ++recordNum) {
            int reorderingEnd;
            boolean canReorder = records.get((int)recordNum).mReorderingAllowed;
            if (canReorder) continue;
            if (startIndex != recordNum) {
                this.executeOpsTogether(records, isRecordPop, startIndex, recordNum);
            }
            if (isRecordPop.get(recordNum).booleanValue()) {
                for (reorderingEnd = recordNum + 1; reorderingEnd < numRecords && isRecordPop.get(reorderingEnd).booleanValue() && !records.get((int)reorderingEnd).mReorderingAllowed; ++reorderingEnd) {
                }
            }
            this.executeOpsTogether(records, isRecordPop, recordNum, reorderingEnd);
            startIndex = reorderingEnd;
            recordNum = reorderingEnd - 1;
        }
        if (startIndex != numRecords) {
            this.executeOpsTogether(records, isRecordPop, startIndex, numRecords);
        }
    }

    private void executeOpsTogether(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex) {
        boolean allowReordering = records.get((int)startIndex).mReorderingAllowed;
        boolean addToBackStack = false;
        if (this.mTmpAddedFragments == null) {
            this.mTmpAddedFragments = new ArrayList();
        } else {
            this.mTmpAddedFragments.clear();
        }
        this.mTmpAddedFragments.addAll(this.mAdded);
        Fragment oldPrimaryNav = this.getPrimaryNavigationFragment();
        for (int recordNum = startIndex; recordNum < endIndex; ++recordNum) {
            BackStackRecord record = records.get(recordNum);
            boolean isPop = isRecordPop.get(recordNum);
            oldPrimaryNav = !isPop ? record.expandOps(this.mTmpAddedFragments, oldPrimaryNav) : record.trackAddedFragmentsInPop(this.mTmpAddedFragments, oldPrimaryNav);
            addToBackStack = addToBackStack || record.mAddToBackStack;
        }
        this.mTmpAddedFragments.clear();
        if (!allowReordering) {
            FragmentTransition.startTransitions(this, records, isRecordPop, startIndex, endIndex, false);
        }
        FragmentManagerImpl.executeOps(records, isRecordPop, startIndex, endIndex);
        int postponeIndex = endIndex;
        if (allowReordering) {
            ArraySet addedFragments = new ArraySet();
            this.addAddedFragments((ArraySet<Fragment>)addedFragments);
            postponeIndex = this.postponePostponableTransactions(records, isRecordPop, startIndex, endIndex, (ArraySet<Fragment>)addedFragments);
            this.makeRemovedFragmentsInvisible((ArraySet<Fragment>)addedFragments);
        }
        if (postponeIndex != startIndex && allowReordering) {
            FragmentTransition.startTransitions(this, records, isRecordPop, startIndex, postponeIndex, true);
            this.moveToState(this.mCurState, true);
        }
        for (int recordNum = startIndex; recordNum < endIndex; ++recordNum) {
            BackStackRecord record = records.get(recordNum);
            boolean isPop = isRecordPop.get(recordNum);
            if (isPop && record.mIndex >= 0) {
                this.freeBackStackIndex(record.mIndex);
                record.mIndex = -1;
            }
            record.runOnCommitRunnables();
        }
        if (addToBackStack) {
            this.reportBackStackChanged();
        }
    }

    private void makeRemovedFragmentsInvisible(ArraySet<Fragment> fragments) {
        int numAdded = fragments.size();
        for (int i = 0; i < numAdded; ++i) {
            Fragment fragment = (Fragment)fragments.valueAt(i);
            if (fragment.mAdded) continue;
            View view = fragment.requireView();
            fragment.mPostponedAlpha = view.getAlpha();
            view.setAlpha(0.0f);
        }
    }

    private int postponePostponableTransactions(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex, ArraySet<Fragment> added) {
        int postponeIndex = endIndex;
        for (int i = endIndex - 1; i >= startIndex; --i) {
            boolean isPostponed;
            BackStackRecord record = records.get(i);
            boolean isPop = isRecordPop.get(i);
            boolean bl = isPostponed = record.isPostponed() && !record.interactsWith(records, i + 1, endIndex);
            if (!isPostponed) continue;
            if (this.mPostponedTransactions == null) {
                this.mPostponedTransactions = new ArrayList();
            }
            StartEnterTransitionListener listener = new StartEnterTransitionListener(record, isPop);
            this.mPostponedTransactions.add(listener);
            record.setOnStartPostponedListener(listener);
            if (isPop) {
                record.executeOps();
            } else {
                record.executePopOps(false);
            }
            if (i != --postponeIndex) {
                records.remove(i);
                records.add(postponeIndex, record);
            }
            this.addAddedFragments(added);
        }
        return postponeIndex;
    }

    void completeExecute(BackStackRecord record, boolean isPop, boolean runTransitions, boolean moveToState) {
        if (isPop) {
            record.executePopOps(moveToState);
        } else {
            record.executeOps();
        }
        ArrayList<BackStackRecord> records = new ArrayList<BackStackRecord>(1);
        ArrayList<Boolean> isRecordPop = new ArrayList<Boolean>(1);
        records.add(record);
        isRecordPop.add(isPop);
        if (runTransitions) {
            FragmentTransition.startTransitions(this, records, isRecordPop, 0, 1, true);
        }
        if (moveToState) {
            this.moveToState(this.mCurState, true);
        }
        for (Fragment fragment : this.mActive.values()) {
            if (fragment == null || fragment.mView == null || !fragment.mIsNewlyAdded || !record.interactsWith(fragment.mContainerId)) continue;
            if (fragment.mPostponedAlpha > 0.0f) {
                fragment.mView.setAlpha(fragment.mPostponedAlpha);
            }
            if (moveToState) {
                fragment.mPostponedAlpha = 0.0f;
                continue;
            }
            fragment.mPostponedAlpha = -1.0f;
            fragment.mIsNewlyAdded = false;
        }
    }

    private Fragment findFragmentUnder(Fragment f) {
        ViewGroup container = f.mContainer;
        View view = f.mView;
        if (container == null || view == null) {
            return null;
        }
        int fragmentIndex = this.mAdded.indexOf(f);
        for (int i = fragmentIndex - 1; i >= 0; --i) {
            Fragment underFragment = this.mAdded.get(i);
            if (underFragment.mContainer != container || underFragment.mView == null) continue;
            return underFragment;
        }
        return null;
    }

    private static void executeOps(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            BackStackRecord record = records.get(i);
            boolean isPop = isRecordPop.get(i);
            if (isPop) {
                record.bumpBackStackNesting(-1);
                boolean moveToState = i == endIndex - 1;
                record.executePopOps(moveToState);
                continue;
            }
            record.bumpBackStackNesting(1);
            record.executeOps();
        }
    }

    private void addAddedFragments(ArraySet<Fragment> added) {
        if (this.mCurState < 1) {
            return;
        }
        int state = Math.min(this.mCurState, 3);
        int numAdded = this.mAdded.size();
        for (int i = 0; i < numAdded; ++i) {
            Fragment fragment = this.mAdded.get(i);
            if (fragment.mState >= state) continue;
            this.moveToState(fragment, state, fragment.getNextAnim(), fragment.getNextTransition(), false);
            if (fragment.mView == null || fragment.mHidden || !fragment.mIsNewlyAdded) continue;
            added.add((Object)fragment);
        }
    }

    private void forcePostponedTransactions() {
        if (this.mPostponedTransactions != null) {
            while (!this.mPostponedTransactions.isEmpty()) {
                this.mPostponedTransactions.remove(0).completeTransaction();
            }
        }
    }

    private void endAnimatingAwayFragments() {
        for (Fragment fragment : this.mActive.values()) {
            if (fragment == null) continue;
            if (fragment.getAnimatingAway() != null) {
                int stateAfterAnimating = fragment.getStateAfterAnimating();
                View animatingAway = fragment.getAnimatingAway();
                Animation animation = animatingAway.getAnimation();
                if (animation != null) {
                    animation.cancel();
                    animatingAway.clearAnimation();
                }
                fragment.setAnimatingAway(null);
                this.moveToState(fragment, stateAfterAnimating, 0, 0, false);
                continue;
            }
            if (fragment.getAnimator() == null) continue;
            fragment.getAnimator().end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateOpsForPendingActions(ArrayList<BackStackRecord> records, ArrayList<Boolean> isPop) {
        boolean didSomething = false;
        FragmentManagerImpl fragmentManagerImpl = this;
        synchronized (fragmentManagerImpl) {
            if (this.mPendingActions == null || this.mPendingActions.size() == 0) {
                return false;
            }
            int numActions = this.mPendingActions.size();
            for (int i = 0; i < numActions; ++i) {
                didSomething |= this.mPendingActions.get(i).generateOps(records, isPop);
            }
            this.mPendingActions.clear();
            this.mHost.getHandler().removeCallbacks(this.mExecCommit);
        }
        return didSomething;
    }

    void doPendingDeferredStart() {
        if (this.mHavePendingDeferredStart) {
            this.mHavePendingDeferredStart = false;
            this.startPendingDeferredFragments();
        }
    }

    void reportBackStackChanged() {
        if (this.mBackStackChangeListeners != null) {
            for (int i = 0; i < this.mBackStackChangeListeners.size(); ++i) {
                this.mBackStackChangeListeners.get(i).onBackStackChanged();
            }
        }
    }

    void addBackStackState(BackStackRecord state) {
        if (this.mBackStack == null) {
            this.mBackStack = new ArrayList();
        }
        this.mBackStack.add(state);
    }

    boolean popBackStackState(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, String name, int id, int flags) {
        if (this.mBackStack == null) {
            return false;
        }
        if (name == null && id < 0 && (flags & 1) == 0) {
            int last = this.mBackStack.size() - 1;
            if (last < 0) {
                return false;
            }
            records.add(this.mBackStack.remove(last));
            isRecordPop.add(true);
        } else {
            int index = -1;
            if (name != null || id >= 0) {
                BackStackRecord bss;
                for (index = this.mBackStack.size() - 1; index >= 0; --index) {
                    bss = this.mBackStack.get(index);
                    if (name != null && name.equals(bss.getName()) || id >= 0 && id == bss.mIndex) break;
                }
                if (index < 0) {
                    return false;
                }
                if ((flags & 1) != 0) {
                    --index;
                    while (index >= 0) {
                        bss = this.mBackStack.get(index);
                        if ((name == null || !name.equals(bss.getName())) && (id < 0 || id != bss.mIndex)) break;
                        --index;
                    }
                }
            }
            if (index == this.mBackStack.size() - 1) {
                return false;
            }
            for (int i = this.mBackStack.size() - 1; i > index; --i) {
                records.add(this.mBackStack.remove(i));
                isRecordPop.add(true);
            }
        }
        return true;
    }

    @Deprecated
    FragmentManagerNonConfig retainNonConfig() {
        if (this.mHost instanceof ViewModelStoreOwner) {
            this.throwException(new IllegalStateException("You cannot use retainNonConfig when your FragmentHostCallback implements ViewModelStoreOwner."));
        }
        return this.mNonConfig.getSnapshot();
    }

    void saveFragmentViewState(Fragment f) {
        if (f.mInnerView == null) {
            return;
        }
        if (this.mStateArray == null) {
            this.mStateArray = new SparseArray();
        } else {
            this.mStateArray.clear();
        }
        f.mInnerView.saveHierarchyState(this.mStateArray);
        if (this.mStateArray.size() > 0) {
            f.mSavedViewState = this.mStateArray;
            this.mStateArray = null;
        }
    }

    Bundle saveFragmentBasicState(Fragment f) {
        Bundle result = null;
        if (this.mStateBundle == null) {
            this.mStateBundle = new Bundle();
        }
        f.performSaveInstanceState(this.mStateBundle);
        this.dispatchOnFragmentSaveInstanceState(f, this.mStateBundle, false);
        if (!this.mStateBundle.isEmpty()) {
            result = this.mStateBundle;
            this.mStateBundle = null;
        }
        if (f.mView != null) {
            this.saveFragmentViewState(f);
        }
        if (f.mSavedViewState != null) {
            if (result == null) {
                result = new Bundle();
            }
            result.putSparseParcelableArray(VIEW_STATE_TAG, f.mSavedViewState);
        }
        if (!f.mUserVisibleHint) {
            if (result == null) {
                result = new Bundle();
            }
            result.putBoolean(USER_VISIBLE_HINT_TAG, f.mUserVisibleHint);
        }
        return result;
    }

    Parcelable saveAllState() {
        this.forcePostponedTransactions();
        this.endAnimatingAwayFragments();
        this.execPendingActions();
        this.mStateSaved = true;
        if (this.mActive.isEmpty()) {
            return null;
        }
        int size = this.mActive.size();
        ArrayList<FragmentState> active = new ArrayList<FragmentState>(size);
        boolean haveFragments = false;
        for (Fragment f : this.mActive.values()) {
            if (f == null) continue;
            if (f.mFragmentManager != this) {
                this.throwException(new IllegalStateException("Failure saving state: active " + f + " was removed from the FragmentManager"));
            }
            haveFragments = true;
            FragmentState fs = new FragmentState(f);
            active.add(fs);
            if (f.mState > 0 && fs.mSavedFragmentState == null) {
                fs.mSavedFragmentState = this.saveFragmentBasicState(f);
                if (f.mTargetWho != null) {
                    Fragment target = this.mActive.get(f.mTargetWho);
                    if (target == null) {
                        this.throwException(new IllegalStateException("Failure saving state: " + f + " has target not in fragment manager: " + f.mTargetWho));
                    }
                    if (fs.mSavedFragmentState == null) {
                        fs.mSavedFragmentState = new Bundle();
                    }
                    this.putFragment(fs.mSavedFragmentState, TARGET_STATE_TAG, target);
                    if (f.mTargetRequestCode != 0) {
                        fs.mSavedFragmentState.putInt(TARGET_REQUEST_CODE_STATE_TAG, f.mTargetRequestCode);
                    }
                }
            } else {
                fs.mSavedFragmentState = f.mSavedFragmentState;
            }
            if (!DEBUG) continue;
            Log.v((String)TAG, (String)("Saved state of " + f + ": " + fs.mSavedFragmentState));
        }
        if (!haveFragments) {
            if (DEBUG) {
                Log.v((String)TAG, (String)"saveAllState: no fragments!");
            }
            return null;
        }
        ArrayList<String> added = null;
        BackStackState[] backStack = null;
        size = this.mAdded.size();
        if (size > 0) {
            added = new ArrayList<String>(size);
            for (Fragment f : this.mAdded) {
                added.add(f.mWho);
                if (f.mFragmentManager != this) {
                    this.throwException(new IllegalStateException("Failure saving state: active " + f + " was removed from the FragmentManager"));
                }
                if (!DEBUG) continue;
                Log.v((String)TAG, (String)("saveAllState: adding fragment (" + f.mWho + "): " + f));
            }
        }
        if (this.mBackStack != null && (size = this.mBackStack.size()) > 0) {
            backStack = new BackStackState[size];
            for (int i = 0; i < size; ++i) {
                backStack[i] = new BackStackState(this.mBackStack.get(i));
                if (!DEBUG) continue;
                Log.v((String)TAG, (String)("saveAllState: adding back stack #" + i + ": " + this.mBackStack.get(i)));
            }
        }
        FragmentManagerState fms = new FragmentManagerState();
        fms.mActive = active;
        fms.mAdded = added;
        fms.mBackStack = backStack;
        if (this.mPrimaryNav != null) {
            fms.mPrimaryNavActiveWho = this.mPrimaryNav.mWho;
        }
        fms.mNextFragmentIndex = this.mNextFragmentIndex;
        return fms;
    }

    void restoreAllState(Parcelable state, FragmentManagerNonConfig nonConfig) {
        if (this.mHost instanceof ViewModelStoreOwner) {
            this.throwException(new IllegalStateException("You must use restoreSaveState when your FragmentHostCallback implements ViewModelStoreOwner"));
        }
        this.mNonConfig.restoreFromSnapshot(nonConfig);
        this.restoreSaveState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreSaveState(Parcelable state) {
        Fragment f;
        if (state == null) {
            return;
        }
        FragmentManagerState fms = (FragmentManagerState)state;
        if (fms.mActive == null) {
            return;
        }
        for (Fragment f2 : this.mNonConfig.getRetainedFragments()) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("restoreSaveState: re-attaching retained " + f2));
            }
            FragmentState fs = null;
            for (FragmentState fragmentState : fms.mActive) {
                if (!fragmentState.mWho.equals(f2.mWho)) continue;
                fs = fragmentState;
                break;
            }
            if (fs == null) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Discarding retained Fragment " + f2 + " that was not found in the set of active Fragments " + fms.mActive));
                }
                this.moveToState(f2, 1, 0, 0, false);
                f2.mRemoving = true;
                this.moveToState(f2, 0, 0, 0, false);
                continue;
            }
            fs.mInstance = f2;
            f2.mSavedViewState = null;
            f2.mBackStackNesting = 0;
            f2.mInLayout = false;
            f2.mAdded = false;
            f2.mTargetWho = f2.mTarget != null ? f2.mTarget.mWho : null;
            f2.mTarget = null;
            if (fs.mSavedFragmentState == null) continue;
            fs.mSavedFragmentState.setClassLoader(this.mHost.getContext().getClassLoader());
            f2.mSavedViewState = fs.mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
            f2.mSavedFragmentState = fs.mSavedFragmentState;
        }
        this.mActive.clear();
        for (FragmentState fs : fms.mActive) {
            if (fs == null) continue;
            f = fs.instantiate(this.mHost.getContext().getClassLoader(), this.getFragmentFactory());
            f.mFragmentManager = this;
            if (DEBUG) {
                Log.v((String)TAG, (String)("restoreSaveState: active (" + f.mWho + "): " + f));
            }
            this.mActive.put(f.mWho, f);
            fs.mInstance = null;
        }
        this.mAdded.clear();
        if (fms.mAdded != null) {
            for (String who : fms.mAdded) {
                f = this.mActive.get(who);
                if (f == null) {
                    this.throwException(new IllegalStateException("No instantiated fragment for (" + who + ")"));
                }
                f.mAdded = true;
                if (DEBUG) {
                    Log.v((String)TAG, (String)("restoreSaveState: added (" + who + "): " + f));
                }
                if (this.mAdded.contains(f)) {
                    throw new IllegalStateException("Already added " + f);
                }
                ArrayList<Fragment> arrayList = this.mAdded;
                synchronized (arrayList) {
                    this.mAdded.add(f);
                }
            }
        }
        if (fms.mBackStack != null) {
            this.mBackStack = new ArrayList(fms.mBackStack.length);
            for (int i = 0; i < fms.mBackStack.length; ++i) {
                BackStackRecord bse = fms.mBackStack[i].instantiate(this);
                if (DEBUG) {
                    Log.v((String)TAG, (String)("restoreAllState: back stack #" + i + " (index " + bse.mIndex + "): " + bse));
                    LogWriter logw = new LogWriter(TAG);
                    PrintWriter pw = new PrintWriter((Writer)logw);
                    bse.dump("  ", pw, false);
                    pw.close();
                }
                this.mBackStack.add(bse);
                if (bse.mIndex < 0) continue;
                this.setBackStackIndex(bse.mIndex, bse);
            }
        } else {
            this.mBackStack = null;
        }
        if (fms.mPrimaryNavActiveWho != null) {
            this.mPrimaryNav = this.mActive.get(fms.mPrimaryNavActiveWho);
            this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
        }
        this.mNextFragmentIndex = fms.mNextFragmentIndex;
    }

    private void burpActive() {
        Collection<Fragment> values = this.mActive.values();
        values.removeAll(Collections.singleton(null));
    }

    public void attachController(@NonNull FragmentHostCallback host, @NonNull FragmentContainer container, @Nullable Fragment parent) {
        if (this.mHost != null) {
            throw new IllegalStateException("Already attached");
        }
        this.mHost = host;
        this.mContainer = container;
        this.mParent = parent;
        if (this.mParent != null) {
            this.updateOnBackPressedCallbackEnabled();
        }
        if (host instanceof OnBackPressedDispatcherOwner) {
            OnBackPressedDispatcherOwner dispatcherOwner = (OnBackPressedDispatcherOwner)host;
            this.mOnBackPressedDispatcher = dispatcherOwner.getOnBackPressedDispatcher();
            Fragment owner = parent != null ? parent : dispatcherOwner;
            this.mOnBackPressedDispatcher.addCallback((LifecycleOwner)owner, this.mOnBackPressedCallback);
        }
        if (parent != null) {
            this.mNonConfig = parent.mFragmentManager.getChildNonConfig(parent);
        } else if (host instanceof ViewModelStoreOwner) {
            ViewModelStore viewModelStore = ((ViewModelStoreOwner)host).getViewModelStore();
            this.mNonConfig = FragmentManagerViewModel.getInstance(viewModelStore);
        } else {
            this.mNonConfig = new FragmentManagerViewModel(false);
        }
    }

    public void noteStateNotSaved() {
        this.mStateSaved = false;
        this.mStopped = false;
        int addedCount = this.mAdded.size();
        for (int i = 0; i < addedCount; ++i) {
            Fragment fragment = this.mAdded.get(i);
            if (fragment == null) continue;
            fragment.noteStateNotSaved();
        }
    }

    public void dispatchCreate() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.dispatchStateChange(1);
    }

    public void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.dispatchStateChange(2);
    }

    public void dispatchStart() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.dispatchStateChange(3);
    }

    public void dispatchResume() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.dispatchStateChange(4);
    }

    public void dispatchPause() {
        this.dispatchStateChange(3);
    }

    public void dispatchStop() {
        this.mStopped = true;
        this.dispatchStateChange(2);
    }

    public void dispatchDestroyView() {
        this.dispatchStateChange(1);
    }

    public void dispatchDestroy() {
        this.mDestroyed = true;
        this.execPendingActions();
        this.dispatchStateChange(0);
        this.mHost = null;
        this.mContainer = null;
        this.mParent = null;
        if (this.mOnBackPressedDispatcher != null) {
            this.mOnBackPressedCallback.remove();
            this.mOnBackPressedDispatcher = null;
        }
    }

    private void dispatchStateChange(int nextState) {
        try {
            this.mExecutingActions = true;
            this.moveToState(nextState, false);
        }
        finally {
            this.mExecutingActions = false;
        }
        this.execPendingActions();
    }

    public void dispatchMultiWindowModeChanged(boolean isInMultiWindowMode) {
        for (int i = this.mAdded.size() - 1; i >= 0; --i) {
            Fragment f = this.mAdded.get(i);
            if (f == null) continue;
            f.performMultiWindowModeChanged(isInMultiWindowMode);
        }
    }

    public void dispatchPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
        for (int i = this.mAdded.size() - 1; i >= 0; --i) {
            Fragment f = this.mAdded.get(i);
            if (f == null) continue;
            f.performPictureInPictureModeChanged(isInPictureInPictureMode);
        }
    }

    public void dispatchConfigurationChanged(@NonNull Configuration newConfig) {
        for (int i = 0; i < this.mAdded.size(); ++i) {
            Fragment f = this.mAdded.get(i);
            if (f == null) continue;
            f.performConfigurationChanged(newConfig);
        }
    }

    public void dispatchLowMemory() {
        for (int i = 0; i < this.mAdded.size(); ++i) {
            Fragment f = this.mAdded.get(i);
            if (f == null) continue;
            f.performLowMemory();
        }
    }

    public boolean dispatchCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        Fragment f;
        int i;
        if (this.mCurState < 1) {
            return false;
        }
        boolean show = false;
        ArrayList<Fragment> newMenus = null;
        for (i = 0; i < this.mAdded.size(); ++i) {
            f = this.mAdded.get(i);
            if (f == null || !f.performCreateOptionsMenu(menu, inflater)) continue;
            show = true;
            if (newMenus == null) {
                newMenus = new ArrayList<Fragment>();
            }
            newMenus.add(f);
        }
        if (this.mCreatedMenus != null) {
            for (i = 0; i < this.mCreatedMenus.size(); ++i) {
                f = this.mCreatedMenus.get(i);
                if (newMenus != null && newMenus.contains(f)) continue;
                f.onDestroyOptionsMenu();
            }
        }
        this.mCreatedMenus = newMenus;
        return show;
    }

    public boolean dispatchPrepareOptionsMenu(@NonNull Menu menu) {
        if (this.mCurState < 1) {
            return false;
        }
        boolean show = false;
        for (int i = 0; i < this.mAdded.size(); ++i) {
            Fragment f = this.mAdded.get(i);
            if (f == null || !f.performPrepareOptionsMenu(menu)) continue;
            show = true;
        }
        return show;
    }

    public boolean dispatchOptionsItemSelected(@NonNull MenuItem item) {
        if (this.mCurState < 1) {
            return false;
        }
        for (int i = 0; i < this.mAdded.size(); ++i) {
            Fragment f = this.mAdded.get(i);
            if (f == null || !f.performOptionsItemSelected(item)) continue;
            return true;
        }
        return false;
    }

    public boolean dispatchContextItemSelected(@NonNull MenuItem item) {
        if (this.mCurState < 1) {
            return false;
        }
        for (int i = 0; i < this.mAdded.size(); ++i) {
            Fragment f = this.mAdded.get(i);
            if (f == null || !f.performContextItemSelected(item)) continue;
            return true;
        }
        return false;
    }

    public void dispatchOptionsMenuClosed(@NonNull Menu menu) {
        if (this.mCurState < 1) {
            return;
        }
        for (int i = 0; i < this.mAdded.size(); ++i) {
            Fragment f = this.mAdded.get(i);
            if (f == null) continue;
            f.performOptionsMenuClosed(menu);
        }
    }

    public void setPrimaryNavigationFragment(Fragment f) {
        if (f != null && (this.mActive.get(f.mWho) != f || f.mHost != null && f.getFragmentManager() != this)) {
            throw new IllegalArgumentException("Fragment " + f + " is not an active fragment of FragmentManager " + this);
        }
        Fragment previousPrimaryNav = this.mPrimaryNav;
        this.mPrimaryNav = f;
        this.dispatchParentPrimaryNavigationFragmentChanged(previousPrimaryNav);
        this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
    }

    private void dispatchParentPrimaryNavigationFragmentChanged(@Nullable Fragment f) {
        if (f != null && this.mActive.get(f.mWho) == f) {
            f.performPrimaryNavigationFragmentChanged();
        }
    }

    void dispatchPrimaryNavigationFragmentChanged() {
        this.updateOnBackPressedCallbackEnabled();
        this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
    }

    @Override
    @Nullable
    public Fragment getPrimaryNavigationFragment() {
        return this.mPrimaryNav;
    }

    public void setMaxLifecycle(Fragment f, Lifecycle.State state) {
        if (this.mActive.get(f.mWho) != f || f.mHost != null && f.getFragmentManager() != this) {
            throw new IllegalArgumentException("Fragment " + f + " is not an active fragment of FragmentManager " + this);
        }
        f.mMaxState = state;
    }

    @Override
    @NonNull
    public FragmentFactory getFragmentFactory() {
        FragmentFactory factory = super.getFragmentFactory();
        if (factory == DEFAULT_FACTORY) {
            if (this.mParent != null) {
                return this.mParent.mFragmentManager.getFragmentFactory();
            }
            this.setFragmentFactory(new FragmentFactory(){

                @Override
                @NonNull
                public Fragment instantiate(@NonNull ClassLoader classLoader, @NonNull String className) {
                    return FragmentManagerImpl.this.mHost.instantiate(FragmentManagerImpl.this.mHost.getContext(), className, null);
                }
            });
        }
        return super.getFragmentFactory();
    }

    @Override
    public void registerFragmentLifecycleCallbacks(@NonNull FragmentManager.FragmentLifecycleCallbacks cb, boolean recursive) {
        this.mLifecycleCallbacks.add(new FragmentLifecycleCallbacksHolder(cb, recursive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFragmentLifecycleCallbacks(@NonNull FragmentManager.FragmentLifecycleCallbacks cb) {
        CopyOnWriteArrayList<FragmentLifecycleCallbacksHolder> copyOnWriteArrayList = this.mLifecycleCallbacks;
        synchronized (copyOnWriteArrayList) {
            int N = this.mLifecycleCallbacks.size();
            for (int i = 0; i < N; ++i) {
                if (this.mLifecycleCallbacks.get((int)i).mCallback != cb) continue;
                this.mLifecycleCallbacks.remove(i);
                break;
            }
        }
    }

    void dispatchOnFragmentPreAttached(@NonNull Fragment f, @NonNull Context context, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentPreAttached(f, context, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentPreAttached(this, f, context);
        }
    }

    void dispatchOnFragmentAttached(@NonNull Fragment f, @NonNull Context context, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentAttached(f, context, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentAttached(this, f, context);
        }
    }

    void dispatchOnFragmentPreCreated(@NonNull Fragment f, @Nullable Bundle savedInstanceState, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentPreCreated(f, savedInstanceState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentPreCreated(this, f, savedInstanceState);
        }
    }

    void dispatchOnFragmentCreated(@NonNull Fragment f, @Nullable Bundle savedInstanceState, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentCreated(f, savedInstanceState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentCreated(this, f, savedInstanceState);
        }
    }

    void dispatchOnFragmentActivityCreated(@NonNull Fragment f, @Nullable Bundle savedInstanceState, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentActivityCreated(f, savedInstanceState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentActivityCreated(this, f, savedInstanceState);
        }
    }

    void dispatchOnFragmentViewCreated(@NonNull Fragment f, @NonNull View v, @Nullable Bundle savedInstanceState, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentViewCreated(f, v, savedInstanceState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentViewCreated(this, f, v, savedInstanceState);
        }
    }

    void dispatchOnFragmentStarted(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentStarted(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentStarted(this, f);
        }
    }

    void dispatchOnFragmentResumed(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentResumed(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentResumed(this, f);
        }
    }

    void dispatchOnFragmentPaused(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentPaused(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentPaused(this, f);
        }
    }

    void dispatchOnFragmentStopped(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentStopped(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentStopped(this, f);
        }
    }

    void dispatchOnFragmentSaveInstanceState(@NonNull Fragment f, @NonNull Bundle outState, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentSaveInstanceState(f, outState, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentSaveInstanceState(this, f, outState);
        }
    }

    void dispatchOnFragmentViewDestroyed(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentViewDestroyed(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentViewDestroyed(this, f);
        }
    }

    void dispatchOnFragmentDestroyed(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentDestroyed(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentDestroyed(this, f);
        }
    }

    void dispatchOnFragmentDetached(@NonNull Fragment f, boolean onlyRecursive) {
        FragmentManager parentManager;
        if (this.mParent != null && (parentManager = this.mParent.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)parentManager).dispatchOnFragmentDetached(f, true);
        }
        for (FragmentLifecycleCallbacksHolder holder : this.mLifecycleCallbacks) {
            if (onlyRecursive && !holder.mRecursive) continue;
            holder.mCallback.onFragmentDetached(this, f);
        }
    }

    boolean checkForMenus() {
        boolean hasMenu = false;
        for (Fragment f : this.mActive.values()) {
            if (f != null) {
                hasMenu = this.isMenuAvailable(f);
            }
            if (!hasMenu) continue;
            return true;
        }
        return false;
    }

    private boolean isMenuAvailable(Fragment f) {
        return f.mHasMenu && f.mMenuVisible || f.mChildFragmentManager.checkForMenus();
    }

    public static int reverseTransit(int transit) {
        int rev = 0;
        switch (transit) {
            case 4097: {
                rev = 8194;
                break;
            }
            case 8194: {
                rev = 4097;
                break;
            }
            case 4099: {
                rev = 4099;
            }
        }
        return rev;
    }

    public static int transitToStyleIndex(int transit, boolean enter) {
        int animAttr = -1;
        switch (transit) {
            case 4097: {
                animAttr = enter ? 1 : 2;
                break;
            }
            case 8194: {
                animAttr = enter ? 3 : 4;
                break;
            }
            case 4099: {
                animAttr = enter ? 5 : 6;
            }
        }
        return animAttr;
    }

    @Nullable
    public View onCreateView(@Nullable View parent, @NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        Fragment fragment;
        int containerId;
        if (!"fragment".equals(name)) {
            return null;
        }
        String fname = attrs.getAttributeValue(null, "class");
        TypedArray a = context.obtainStyledAttributes(attrs, FragmentTag.Fragment);
        if (fname == null) {
            fname = a.getString(0);
        }
        int id = a.getResourceId(1, -1);
        String tag = a.getString(2);
        a.recycle();
        if (fname == null || !FragmentFactory.isFragmentClass(context.getClassLoader(), fname)) {
            return null;
        }
        int n = containerId = parent != null ? parent.getId() : 0;
        if (containerId == -1 && id == -1 && tag == null) {
            throw new IllegalArgumentException(attrs.getPositionDescription() + ": Must specify unique android:id, android:tag, or have a parent with an id for " + fname);
        }
        Fragment fragment2 = fragment = id != -1 ? this.findFragmentById(id) : null;
        if (fragment == null && tag != null) {
            fragment = this.findFragmentByTag(tag);
        }
        if (fragment == null && containerId != -1) {
            fragment = this.findFragmentById(containerId);
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("onCreateView: id=0x" + Integer.toHexString(id) + " fname=" + fname + " existing=" + fragment));
        }
        if (fragment == null) {
            fragment = this.getFragmentFactory().instantiate(context.getClassLoader(), fname);
            fragment.mFromLayout = true;
            fragment.mFragmentId = id != 0 ? id : containerId;
            fragment.mContainerId = containerId;
            fragment.mTag = tag;
            fragment.mInLayout = true;
            fragment.mFragmentManager = this;
            fragment.mHost = this.mHost;
            fragment.onInflate(this.mHost.getContext(), attrs, fragment.mSavedFragmentState);
            this.addFragment(fragment, true);
        } else {
            if (fragment.mInLayout) {
                throw new IllegalArgumentException(attrs.getPositionDescription() + ": Duplicate id 0x" + Integer.toHexString(id) + ", tag " + tag + ", or parent id 0x" + Integer.toHexString(containerId) + " with another fragment for " + fname);
            }
            fragment.mInLayout = true;
            fragment.mHost = this.mHost;
            fragment.onInflate(this.mHost.getContext(), attrs, fragment.mSavedFragmentState);
        }
        if (this.mCurState < 1 && fragment.mFromLayout) {
            this.moveToState(fragment, 1, 0, 0, false);
        } else {
            this.moveToState(fragment);
        }
        if (fragment.mView == null) {
            throw new IllegalStateException("Fragment " + fname + " did not create a view.");
        }
        if (id != 0) {
            fragment.mView.setId(id);
        }
        if (fragment.mView.getTag() == null) {
            fragment.mView.setTag((Object)tag);
        }
        return fragment.mView;
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        return this.onCreateView(null, name, context, attrs);
    }

    LayoutInflater.Factory2 getLayoutInflaterFactory() {
        return this;
    }

    private static class EndViewTransitionAnimation
    extends AnimationSet
    implements Runnable {
        private final ViewGroup mParent;
        private final View mChild;
        private boolean mEnded;
        private boolean mTransitionEnded;
        private boolean mAnimating = true;

        EndViewTransitionAnimation(@NonNull Animation animation, @NonNull ViewGroup parent, @NonNull View child) {
            super(false);
            this.mParent = parent;
            this.mChild = child;
            this.addAnimation(animation);
            this.mParent.post((Runnable)this);
        }

        public boolean getTransformation(long currentTime, Transformation t) {
            this.mAnimating = true;
            if (this.mEnded) {
                return !this.mTransitionEnded;
            }
            boolean more = super.getTransformation(currentTime, t);
            if (!more) {
                this.mEnded = true;
                OneShotPreDrawListener.add((View)this.mParent, (Runnable)this);
            }
            return true;
        }

        public boolean getTransformation(long currentTime, Transformation outTransformation, float scale) {
            this.mAnimating = true;
            if (this.mEnded) {
                return !this.mTransitionEnded;
            }
            boolean more = super.getTransformation(currentTime, outTransformation, scale);
            if (!more) {
                this.mEnded = true;
                OneShotPreDrawListener.add((View)this.mParent, (Runnable)this);
            }
            return true;
        }

        @Override
        public void run() {
            if (!this.mEnded && this.mAnimating) {
                this.mAnimating = false;
                this.mParent.post((Runnable)this);
            } else {
                this.mParent.endViewTransition(this.mChild);
                this.mTransitionEnded = true;
            }
        }
    }

    private static class AnimationOrAnimator {
        public final Animation animation;
        public final Animator animator;

        AnimationOrAnimator(Animation animation) {
            this.animation = animation;
            this.animator = null;
            if (animation == null) {
                throw new IllegalStateException("Animation cannot be null");
            }
        }

        AnimationOrAnimator(Animator animator) {
            this.animation = null;
            this.animator = animator;
            if (animator == null) {
                throw new IllegalStateException("Animator cannot be null");
            }
        }
    }

    static class StartEnterTransitionListener
    implements Fragment.OnStartEnterTransitionListener {
        final boolean mIsBack;
        final BackStackRecord mRecord;
        private int mNumPostponed;

        StartEnterTransitionListener(BackStackRecord record, boolean isBack) {
            this.mIsBack = isBack;
            this.mRecord = record;
        }

        @Override
        public void onStartEnterTransition() {
            --this.mNumPostponed;
            if (this.mNumPostponed != 0) {
                return;
            }
            this.mRecord.mManager.scheduleCommit();
        }

        @Override
        public void startListening() {
            ++this.mNumPostponed;
        }

        public boolean isReady() {
            return this.mNumPostponed == 0;
        }

        public void completeTransaction() {
            boolean canceled = this.mNumPostponed > 0;
            FragmentManagerImpl manager = this.mRecord.mManager;
            int numAdded = manager.mAdded.size();
            for (int i = 0; i < numAdded; ++i) {
                Fragment fragment = manager.mAdded.get(i);
                fragment.setOnStartEnterTransitionListener(null);
                if (!canceled || !fragment.isPostponed()) continue;
                fragment.startPostponedEnterTransition();
            }
            this.mRecord.mManager.completeExecute(this.mRecord, this.mIsBack, !canceled, true);
        }

        public void cancelTransaction() {
            this.mRecord.mManager.completeExecute(this.mRecord, this.mIsBack, false, false);
        }
    }

    private class PopBackStackState
    implements OpGenerator {
        final String mName;
        final int mId;
        final int mFlags;

        PopBackStackState(String name, int id, int flags) {
            this.mName = name;
            this.mId = id;
            this.mFlags = flags;
        }

        @Override
        public boolean generateOps(ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop) {
            FragmentManager childManager;
            if (FragmentManagerImpl.this.mPrimaryNav != null && this.mId < 0 && this.mName == null && (childManager = FragmentManagerImpl.this.mPrimaryNav.getChildFragmentManager()).popBackStackImmediate()) {
                return false;
            }
            return FragmentManagerImpl.this.popBackStackState(records, isRecordPop, this.mName, this.mId, this.mFlags);
        }
    }

    static interface OpGenerator {
        public boolean generateOps(ArrayList<BackStackRecord> var1, ArrayList<Boolean> var2);
    }

    static class FragmentTag {
        public static final int[] Fragment = new int[]{0x1010003, 0x10100D0, 0x10100D1};
        public static final int Fragment_id = 1;
        public static final int Fragment_name = 0;
        public static final int Fragment_tag = 2;

        private FragmentTag() {
        }
    }

    private static final class FragmentLifecycleCallbacksHolder {
        final FragmentManager.FragmentLifecycleCallbacks mCallback;
        final boolean mRecursive;

        FragmentLifecycleCallbacksHolder(FragmentManager.FragmentLifecycleCallbacks callback, boolean recursive) {
            this.mCallback = callback;
            this.mRecursive = recursive;
        }
    }
}

